/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class MapBuilder<K, V>
implements Map<K, V> {
    private final Map<K, V> map;

    public MapBuilder() {
        this(Collections.emptyMap());
    }

    public MapBuilder(Map<K, V> source) {
        Assert.notNull(source, (String)"Source map must not be null");
        this.map = new LinkedHashMap<K, V>(source);
    }

    public static MapBuilder<Object, Object> map() {
        return MapBuilder.map(Object.class, Object.class);
    }

    public static <K, V> MapBuilder<K, V> map(Class<K> keyType, Class<V> valueType) {
        return new MapBuilder<K, V>();
    }

    public static <K, V> MapBuilder<K, V> map(Map<K, V> source) {
        return new MapBuilder<K, V>(source);
    }

    @Override
    public MapBuilder<K, V> entry(K key, V value) {
        this.map.put(key, value);
        return this;
    }

    public Map<K, V> build() {
        return new LinkedHashMap<K, V>(this.map);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    @Nullable
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(key, value);
    }

    @Override
    @Nullable
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }
}

