/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.ColumnTypeResolver;
import org.springframework.data.cassandra.core.convert.DefaultColumnTypeResolver;
import org.springframework.data.cassandra.core.convert.IndexSpecificationFactory;
import org.springframework.data.cassandra.core.convert.UserTypeUtil;
import org.springframework.data.cassandra.core.cql.keyspace.CreateIndexSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CreateTableSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CreateUserTypeSpecification;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.EmbeddedEntityOperations;
import org.springframework.data.cassandra.core.mapping.Indexed;
import org.springframework.data.cassandra.core.mapping.UserTypeResolver;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SchemaFactory {
    private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
    private final ColumnTypeResolver typeResolver;
    private final EmbeddedEntityOperations embeddedEntityOperations;

    public SchemaFactory(CassandraConverter converter) {
        Assert.notNull((Object)converter, (String)"CassandraConverter must not be null");
        this.mappingContext = converter.getMappingContext();
        this.typeResolver = new DefaultColumnTypeResolver(this.mappingContext, ShallowUserTypeResolver.INSTANCE, converter::getCodecRegistry, converter::getCustomConversions);
        this.embeddedEntityOperations = new EmbeddedEntityOperations(this.mappingContext);
    }

    public SchemaFactory(MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext, CustomConversions customConversions, CodecRegistry codecRegistry) {
        Assert.notNull(mappingContext, (String)"MappingContext must not be null");
        Assert.notNull((Object)customConversions, (String)"CustomConversions must not be null");
        Assert.notNull((Object)codecRegistry, (String)"CodecRegistry must not be null");
        this.mappingContext = mappingContext;
        this.typeResolver = new DefaultColumnTypeResolver(mappingContext, ShallowUserTypeResolver.INSTANCE, () -> codecRegistry, () -> customConversions);
        this.embeddedEntityOperations = new EmbeddedEntityOperations(this.mappingContext);
    }

    public CreateTableSpecification getCreateTableSpecificationFor(Class<?> entityType) {
        Assert.notNull(entityType, (String)"Entity type must not be null");
        return this.getCreateTableSpecificationFor((CassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityType));
    }

    public CreateTableSpecification getCreateTableSpecificationFor(CassandraPersistentEntity<?> entity) {
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        return this.getCreateTableSpecificationFor(entity, entity.getTableName());
    }

    public CreateTableSpecification getCreateTableSpecificationFor(CassandraPersistentEntity<?> entity, CqlIdentifier tableName) {
        Assert.notNull((Object)tableName, (String)"Table name must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        CreateTableSpecification specification = CreateTableSpecification.createTable(tableName);
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            DataType dataType;
            Iterator iterator2;
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            if (property.isCompositePrimaryKey()) {
                CassandraPersistentEntity primaryKeyEntity = (CassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(property.getRawType());
                iterator2 = primaryKeyEntity.iterator();
                while (iterator2.hasNext()) {
                    CassandraPersistentProperty primaryKeyProperty = (CassandraPersistentProperty)iterator2.next();
                    dataType = this.getDataType(primaryKeyProperty);
                    if (primaryKeyProperty.isPartitionKeyColumn()) {
                        specification.partitionKeyColumn(primaryKeyProperty.getRequiredColumnName(), dataType);
                        continue;
                    }
                    specification.clusteredKeyColumn(primaryKeyProperty.getRequiredColumnName(), dataType, primaryKeyProperty.getPrimaryKeyOrdering());
                }
                continue;
            }
            if (property.isEmbedded()) {
                CassandraPersistentEntity<?> embeddedEntity = this.embeddedEntityOperations.getEntity(property);
                iterator2 = embeddedEntity.iterator();
                while (iterator2.hasNext()) {
                    CassandraPersistentProperty embeddedProperty = (CassandraPersistentProperty)iterator2.next();
                    dataType = this.getDataType(embeddedProperty);
                    specification.column(embeddedProperty.getRequiredColumnName(), dataType);
                }
                continue;
            }
            DataType type = UserTypeUtil.potentiallyFreeze(this.getDataType(property));
            if (property.isIdProperty() || property.isPartitionKeyColumn()) {
                specification.partitionKeyColumn(property.getRequiredColumnName(), type);
                continue;
            }
            if (property.isClusterKeyColumn()) {
                specification.clusteredKeyColumn(property.getRequiredColumnName(), type, property.getPrimaryKeyOrdering());
                continue;
            }
            if (property.isStaticColumn()) {
                specification.staticColumn(property.getRequiredColumnName(), type);
                continue;
            }
            specification.column(property.getRequiredColumnName(), type);
        }
        if (specification.getPartitionKeyColumns().isEmpty()) {
            throw new MappingException(String.format("No partition key columns found in entity [%s]", entity.getType()));
        }
        return specification;
    }

    private DataType getDataType(CassandraPersistentProperty property) {
        try {
            return this.typeResolver.resolve(property).getDataType();
        }
        catch (MappingException e) {
            throw new MappingException(String.format("Cannot resolve DataType for type [%s] for property [%s] in entity [%s]; Consider registering a Converter or annotating the property with @CassandraType", property.getType(), property.getName(), property.getOwner().getName()), (Throwable)e);
        }
    }

    public List<CreateIndexSpecification> getCreateIndexSpecificationsFor(Class<?> entityType) {
        Assert.notNull(entityType, (String)"Entity type must not be null");
        return this.getCreateIndexSpecificationsFor((CassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityType));
    }

    public List<CreateIndexSpecification> getCreateIndexSpecificationsFor(CassandraPersistentEntity<?> entity) {
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        return this.getCreateIndexSpecificationsFor(entity, entity.getTableName());
    }

    public List<CreateIndexSpecification> getCreateIndexSpecificationsFor(CassandraPersistentEntity<?> entity, CqlIdentifier tableName) {
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        Assert.notNull((Object)tableName, (String)"Table name must not be null");
        ArrayList<CreateIndexSpecification> indexes = new ArrayList<CreateIndexSpecification>();
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            if (property.isCompositePrimaryKey()) {
                indexes.addAll(this.getCreateIndexSpecificationsFor((CassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity((PersistentProperty)property)));
            }
            if (property.isEmbedded()) {
                if (property.isAnnotationPresent(Indexed.class)) {
                    Indexed indexed = (Indexed)property.findAnnotation(Indexed.class);
                    Iterator iterator2 = this.embeddedEntityOperations.getEntity(property).iterator();
                    while (iterator2.hasNext()) {
                        CassandraPersistentProperty embeddedProperty = (CassandraPersistentProperty)iterator2.next();
                        indexes.add(IndexSpecificationFactory.createIndexSpecification(indexed, embeddedProperty));
                    }
                    continue;
                }
                indexes.addAll(this.getCreateIndexSpecificationsFor(this.embeddedEntityOperations.getEntity(property)));
                continue;
            }
            indexes.addAll(IndexSpecificationFactory.createIndexSpecifications(property));
        }
        indexes.forEach(it -> it.tableName(entity.getTableName()));
        return indexes;
    }

    public CreateUserTypeSpecification getCreateUserTypeSpecificationFor(CassandraPersistentEntity<?> entity) {
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        CreateUserTypeSpecification specification = CreateUserTypeSpecification.createType(entity.getTableName());
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            if (property.isEmbedded()) {
                CassandraPersistentEntity<?> embeddedEntity = this.embeddedEntityOperations.getEntity(property);
                Iterator iterator2 = embeddedEntity.iterator();
                while (iterator2.hasNext()) {
                    CassandraPersistentProperty embeddedProperty = (CassandraPersistentProperty)iterator2.next();
                    DataType dataType = this.getDataType(embeddedProperty);
                    specification.field(embeddedProperty.getRequiredColumnName(), dataType);
                }
                continue;
            }
            specification.field(property.getRequiredColumnName(), UserTypeUtil.potentiallyFreeze(this.getDataType(property)));
        }
        if (specification.getFields().isEmpty()) {
            throw new MappingException(String.format("No fields in user type [%s]", entity.getType()));
        }
        return specification;
    }

    static enum ShallowUserTypeResolver implements UserTypeResolver
    {
        INSTANCE;


        @Override
        public UserDefinedType resolveType(CqlIdentifier typeName) {
            return new ShallowUserDefinedType(typeName, false);
        }
    }

    static class ShallowUserDefinedType
    implements UserDefinedType {
        private final CqlIdentifier name;
        private final boolean frozen;

        public ShallowUserDefinedType(String name, boolean frozen) {
            this(CqlIdentifier.fromInternal((String)name), frozen);
        }

        public ShallowUserDefinedType(CqlIdentifier name, boolean frozen) {
            this.name = name;
            this.frozen = frozen;
        }

        public CqlIdentifier getKeyspace() {
            return null;
        }

        public CqlIdentifier getName() {
            return this.name;
        }

        public boolean isFrozen() {
            return this.frozen;
        }

        public List<CqlIdentifier> getFieldNames() {
            throw new UnsupportedOperationException("This implementation should only be used internally, this is likely a driver bug");
        }

        public int firstIndexOf(CqlIdentifier id) {
            throw new UnsupportedOperationException("This implementation should only be used internally, this is likely a driver bug");
        }

        public int firstIndexOf(String name) {
            throw new UnsupportedOperationException("This implementation should only be used internally, this is likely a driver bug");
        }

        public List<DataType> getFieldTypes() {
            throw new UnsupportedOperationException("This implementation should only be used internally, this is likely a driver bug");
        }

        public UserDefinedType copy(boolean newFrozen) {
            return new ShallowUserDefinedType(this.name, newFrozen);
        }

        public UdtValue newValue() {
            throw new UnsupportedOperationException("This implementation should only be used internally, this is likely a driver bug");
        }

        public UdtValue newValue(Object ... fields) {
            throw new UnsupportedOperationException("This implementation should only be used internally, this is likely a driver bug");
        }

        public AttachmentPoint getAttachmentPoint() {
            throw new UnsupportedOperationException("This implementation should only be used internally, this is likely a driver bug");
        }

        public boolean isDetached() {
            throw new UnsupportedOperationException("This implementation should only be used internally, this is likely a driver bug");
        }

        public void attach(@NonNull AttachmentPoint attachmentPoint) {
            throw new UnsupportedOperationException("This implementation should only be used internally, this is likely a driver bug");
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UserDefinedType)) {
                return false;
            }
            UserDefinedType that = (UserDefinedType)o;
            return this.isFrozen() == that.isFrozen() && Objects.equals(this.getName(), that.getName());
        }

        public int hashCode() {
            return Objects.hash(this.name, this.frozen);
        }

        public String toString() {
            return "UDT(" + this.name.asCql(true) + ")";
        }
    }
}

