/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.generator;

import java.util.Map;
import org.springframework.data.cassandra.core.cql.keyspace.CqlStringUtils;
import org.springframework.data.cassandra.core.cql.keyspace.Option;

class OptionRenderUtil {
    OptionRenderUtil() {
    }

    static String render(Map<Option, Object> valueMap) {
        if (valueMap.isEmpty()) {
            return "";
        }
        StringBuilder cql = new StringBuilder(valueMap.size() * 2 * 16);
        cql.append("{ ");
        boolean mapFirst = true;
        for (Map.Entry<Option, Object> entry : valueMap.entrySet()) {
            if (mapFirst) {
                mapFirst = false;
            } else {
                cql.append(", ");
            }
            Option option = entry.getKey();
            cql.append(CqlStringUtils.singleQuote(option.getName()));
            cql.append(" : ");
            Object entryValue = entry.getValue();
            Object object = entryValue = entryValue == null ? "" : entryValue.toString();
            if (option.escapesValue()) {
                entryValue = CqlStringUtils.escapeSingle(entryValue);
            }
            if (option.quotesValue()) {
                entryValue = CqlStringUtils.singleQuote(entryValue);
            }
            cql.append(entryValue);
        }
        cql.append(" }");
        return cql.toString();
    }
}

