/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.session.lookup;

import com.datastax.oss.driver.api.core.CqlSession;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.cql.session.lookup.MapSessionFactoryLookup;
import org.springframework.data.cassandra.core.cql.session.lookup.SessionFactoryLookup;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractRoutingSessionFactory
implements SessionFactory,
InitializingBean {
    @Nullable
    private Map<Object, Object> targetSessionFactories;
    @Nullable
    private Object defaultTargetSessionFactory;
    private boolean lenientFallback = true;
    private SessionFactoryLookup sessionFactoryLookup = new MapSessionFactoryLookup();
    @Nullable
    private Map<Object, SessionFactory> resolvedSessionFactories;
    @Nullable
    private SessionFactory resolvedDefaultSessionFactory;

    public void setTargetSessionFactories(Map<Object, Object> targetSessionFactories) {
        Assert.notNull(targetSessionFactories, (String)"Target SessionFactories must not be null");
        this.targetSessionFactories = targetSessionFactories;
    }

    public void setDefaultTargetSessionFactory(Object defaultTargetSessionFactory) {
        Assert.notNull((Object)defaultTargetSessionFactory, (String)"Default target SessionFactory must not be null");
        this.defaultTargetSessionFactory = defaultTargetSessionFactory;
    }

    public void setLenientFallback(boolean lenientFallback) {
        this.lenientFallback = lenientFallback;
    }

    public void setSessionFactoryLookup(@Nullable SessionFactoryLookup sessionFactoryLookup) {
        this.sessionFactoryLookup = sessionFactoryLookup != null ? sessionFactoryLookup : new MapSessionFactoryLookup();
    }

    @Override
    public CqlSession getSession() {
        return this.determineTargetSessionFactory().getSession();
    }

    public void afterPropertiesSet() {
        Assert.notNull(this.targetSessionFactories, (String)"Property targetSessionFactories is required");
        this.resolvedSessionFactories = new HashMap<Object, SessionFactory>(this.targetSessionFactories.size());
        for (Map.Entry<Object, Object> entry : this.targetSessionFactories.entrySet()) {
            Object lookupKey = this.resolveSpecifiedLookupKey(entry.getKey());
            SessionFactory sessionFactory = this.resolveSpecifiedSessionFactory(entry.getValue());
            this.resolvedSessionFactories.put(lookupKey, sessionFactory);
        }
        if (this.defaultTargetSessionFactory != null) {
            this.resolvedDefaultSessionFactory = this.resolveSpecifiedSessionFactory(this.defaultTargetSessionFactory);
        }
    }

    protected Object resolveSpecifiedLookupKey(Object lookupKey) {
        return lookupKey;
    }

    protected SessionFactory resolveSpecifiedSessionFactory(Object sessionFactory) throws IllegalArgumentException {
        if (sessionFactory instanceof SessionFactory) {
            return (SessionFactory)sessionFactory;
        }
        if (sessionFactory instanceof String) {
            return this.sessionFactoryLookup.getSessionFactory((String)sessionFactory);
        }
        throw new IllegalArgumentException(String.format("Illegal session factory value. Only [org.springframework.data.cassandra.core.cql.session.SessionFactory] and String supported: %s", sessionFactory));
    }

    protected SessionFactory determineTargetSessionFactory() {
        Assert.notNull(this.resolvedSessionFactories, (String)"SessionFactory router not initialized");
        Object lookupKey = this.determineCurrentLookupKey();
        SessionFactory sessionFactory = this.resolvedSessionFactories.get(lookupKey);
        if (sessionFactory == null && (this.lenientFallback || lookupKey == null)) {
            sessionFactory = this.resolvedDefaultSessionFactory;
        }
        if (sessionFactory == null) {
            throw new IllegalStateException(String.format("Cannot determine target SessionFactory for lookup key [%s]", lookupKey));
        }
        return sessionFactory;
    }

    @Nullable
    protected abstract Object determineCurrentLookupKey();
}

