/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.data.cassandra.core.mapping.BasicMapId;
import org.springframework.data.cassandra.core.mapping.MapId;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

class MapIdProxyDelegate
implements InvocationHandler {
    private static final Map<Signature, Signature> MAP_ID_SIGNATURES;
    private MapId delegate = new BasicMapId();
    private Class<?> idInterface;

    MapIdProxyDelegate(Class<?> idInterface) {
        this.idInterface = idInterface;
    }

    @Override
    @Nullable
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean isSetter;
        if (this.isMapIdMethod(method)) {
            return method.invoke((Object)this.delegate, args);
        }
        if (args != null && args.length > 1) {
            throw new IllegalArgumentException(String.format("Method [%s] on interface [%s] must take zero or one argument", method, this.idInterface));
        }
        boolean bl = isSetter = args != null && args.length == 1;
        if (isSetter) {
            this.invokeSetter(method, args[0]);
            return Void.TYPE.equals(method.getReturnType()) ? null : proxy;
        }
        return this.invokeGetter(method);
    }

    private boolean isMapIdMethod(Method method) {
        return MAP_ID_SIGNATURES.containsKey(new Signature(method, true));
    }

    private Object invokeGetter(Method method) {
        String name = method.getName();
        if (name.startsWith("get")) {
            if (name.length() == 3) {
                throw new IllegalArgumentException(String.format("Method [%s] on interface [%s] must be of form '<PropertyType> get<PropertyName>()' or '<PropertyType> <propertyName>()'", name, this.idInterface));
            }
            name = StringUtils.uncapitalize((String)name.substring(3));
        }
        return this.delegate.get(name);
    }

    private void invokeSetter(Method method, @Nullable Object value) {
        String name = method.getName();
        int minLength = 1;
        boolean isSet = name.startsWith("set");
        boolean isWith = name.startsWith("with");
        minLength += isSet ? 3 : (isWith ? 4 : 0);
        int length = name.length();
        if (isSet || isWith) {
            if (length < minLength) {
                throw new IllegalArgumentException(String.format("Method [%s] on interface [%s] must be of form '<IdType|void> set<PropertyName>(<PropertyType>)', '<IdType|void> with<PropertyName>(<PropertyType>)' or '<IdType|void> <propertyName>(<PropertyType>)'", name, this.idInterface));
            }
            name = StringUtils.uncapitalize((String)name.substring(minLength - 1));
        }
        if (value == null) {
            this.delegate.put(name, null);
            return;
        }
        this.delegate.put(name, value);
    }

    static {
        Method[] mapIdMethods = MapId.class.getMethods();
        MAP_ID_SIGNATURES = Arrays.stream(mapIdMethods).map(m -> new Signature((Method)m, true)).collect(Collectors.toMap(o -> o, o -> o));
    }

    static class Signature {
        private String name;
        @Nullable
        private Class<?>[] argTypes;
        @Nullable
        private Class<?> returnType;

        Signature(Method method, boolean includeReturnType) {
            this(method.getName(), method.getParameterTypes(), includeReturnType ? method.getReturnType() : null);
        }

        Signature(String name, Class<?>[] argTypes, @Nullable Class<?> returnType) {
            this.name = name;
            this.argTypes = argTypes;
            this.returnType = returnType;
        }

        public String toString() {
            return String.format("%s %s(%s)", this.returnType, this.name, Arrays.toString(this.argTypes));
        }

        public boolean equals(@Nullable Object that) {
            if (that == null) {
                return false;
            }
            if (this == that) {
                return true;
            }
            if (!(that instanceof Signature)) {
                return false;
            }
            Signature that_ = (Signature)that;
            if (!this.name.equals(that_.name)) {
                return false;
            }
            if (this.argTypes == null && that_.argTypes != null || this.argTypes != null && that_.argTypes == null) {
                return false;
            }
            if (this.argTypes != null) {
                if (this.argTypes.length != that_.argTypes.length) {
                    return false;
                }
                for (int i = 0; i < this.argTypes.length; ++i) {
                    if (this.argTypes[i].equals(that_.argTypes[i])) continue;
                    return false;
                }
            }
            if (this.returnType == null) {
                return that_.returnType == null;
            }
            return this.returnType.equals(that_.returnType);
        }

        public int hashCode() {
            int hash = 0x25 ^ this.name.hashCode();
            if (this.argTypes != null) {
                for (Class<?> c : this.argTypes) {
                    hash ^= c.hashCode();
                }
            }
            if (this.returnType != null) {
                hash ^= this.returnType.hashCode();
            }
            return hash;
        }
    }
}

