/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.ColumnType;
import org.springframework.data.cassandra.core.convert.ColumnTypeResolver;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.EmbeddedEntityOperations;
import org.springframework.data.cassandra.core.query.ColumnName;
import org.springframework.data.cassandra.core.query.Columns;
import org.springframework.data.cassandra.core.query.Criteria;
import org.springframework.data.cassandra.core.query.CriteriaDefinition;
import org.springframework.data.cassandra.core.query.Filter;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class QueryMapper {
    private final CassandraConverter converter;
    private final CassandraMappingContext mappingContext;

    public QueryMapper(CassandraConverter converter) {
        Assert.notNull((Object)converter, (String)"CassandraConverter must not be null");
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
    }

    public CassandraConverter getConverter() {
        return this.converter;
    }

    protected CassandraMappingContext getMappingContext() {
        return this.mappingContext;
    }

    public Filter getMappedObject(Filter filter, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)filter, (String)"Filter must not be null");
        Assert.notNull(entity, (String)"Entity must not be null");
        ArrayList<Criteria> result = new ArrayList<Criteria>();
        Iterator<CriteriaDefinition> iterator = filter.iterator();
        while (iterator.hasNext()) {
            CriteriaDefinition criteriaDefinition = iterator.next();
            Field field = this.createPropertyField(entity, criteriaDefinition.getColumnName());
            field.getProperty().filter(CassandraPersistentProperty::isCompositePrimaryKey).ifPresent(it -> {
                throw new IllegalArgumentException("Cannot use composite primary key directly. Reference a property of the composite primary key");
            });
            field.getProperty().filter(it -> it.getOrdinal() != null).ifPresent(it -> {
                throw new IllegalArgumentException(String.format("Cannot reference tuple value elements, property [%s]", field.getMappedKey()));
            });
            CriteriaDefinition.Predicate predicate = criteriaDefinition.getPredicate();
            Object value = predicate.getValue();
            ColumnType typeDescriptor = this.getColumnType(field, value, ColumnTypeTransformer.of(field, predicate.getOperator()));
            Object mappedValue = value != null ? this.getConverter().convertToColumnType(value, typeDescriptor) : null;
            CriteriaDefinition.Predicate mappedPredicate = new CriteriaDefinition.Predicate(predicate.getOperator(), mappedValue);
            result.add(Criteria.of(field.getMappedKey(), mappedPredicate));
        }
        return Filter.from(result);
    }

    public List<Columns.Selector> getMappedSelectors(Columns columns, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)columns, (String)"Columns must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        if (columns.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Columns.Selector> selectors = new ArrayList<Columns.Selector>();
        for (ColumnName column : columns) {
            Field field = this.createPropertyField(entity, column);
            columns.getSelector(column).ifPresent(selector -> {
                List<CqlIdentifier> mappedColumnNames = this.getCqlIdentifier(column, field);
                for (CqlIdentifier mappedColumnName : mappedColumnNames) {
                    selectors.add(this.getMappedSelector((Columns.Selector)selector, mappedColumnName));
                }
            });
        }
        if (columns.isEmpty()) {
            this.addColumns(entity, selectors);
        }
        return selectors;
    }

    private void addColumns(CassandraPersistentEntity<?> entity, List<Columns.Selector> selectors) {
        entity.doWithProperties(property -> {
            if (property.isCompositePrimaryKey()) {
                CassandraPersistentEntity primaryKeyEntity = (CassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(property);
                this.addColumns(primaryKeyEntity, selectors);
            } else {
                selectors.add(Columns.ColumnSelector.from(property.getRequiredColumnName()));
            }
        });
    }

    private Columns.Selector getMappedSelector(Columns.Selector selector, CqlIdentifier cqlIdentifier) {
        if (selector instanceof Columns.ColumnSelector) {
            Columns.ColumnSelector columnSelector = (Columns.ColumnSelector)selector;
            Columns.ColumnSelector mappedColumnSelector = Columns.ColumnSelector.from(cqlIdentifier);
            return columnSelector.getAlias().map(mappedColumnSelector::as).orElse(mappedColumnSelector);
        }
        if (selector instanceof Columns.FunctionCall) {
            Columns.FunctionCall functionCall = (Columns.FunctionCall)selector;
            Columns.FunctionCall mappedFunctionCall = Columns.FunctionCall.from(functionCall.getExpression(), functionCall.getParameters().stream().map(obj -> {
                if (obj instanceof Columns.Selector) {
                    return this.getMappedSelector((Columns.Selector)obj, cqlIdentifier);
                }
                return obj;
            }).toArray());
            return functionCall.getAlias().map(mappedFunctionCall::as).orElse(mappedFunctionCall);
        }
        throw new IllegalArgumentException(String.format("Selector [%s] not supported", selector));
    }

    public List<CqlIdentifier> getMappedColumnNames(Columns columns, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)columns, (String)"Columns must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        if (columns.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CqlIdentifier> columnNames = new ArrayList<CqlIdentifier>();
        HashSet seen = new HashSet();
        for (ColumnName column : columns) {
            Field field = this.createPropertyField(entity, column);
            field.getProperty().ifPresent(seen::add);
            columns.getSelector(column).filter(selector -> selector instanceof Columns.ColumnSelector).ifPresent(columnSelector -> columnNames.addAll(this.getCqlIdentifier(column, field)));
        }
        if (columns.isEmpty()) {
            entity.doWithProperties(property -> {
                if (property.isCompositePrimaryKey()) {
                    return;
                }
                if (seen.add(property)) {
                    columnNames.add(property.getRequiredColumnName());
                }
            });
        }
        return columnNames;
    }

    public Sort getMappedSort(Sort sort, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        if (!sort.iterator().hasNext()) {
            return sort;
        }
        ArrayList<Sort.Order> mappedOrders = new ArrayList<Sort.Order>();
        for (Sort.Order order : sort) {
            Field field;
            ColumnName columnName = ColumnName.from(order.getProperty());
            List<CqlIdentifier> mappedColumnNames = this.getCqlIdentifier(columnName, field = this.createPropertyField(entity, columnName));
            if (mappedColumnNames.isEmpty()) {
                mappedOrders.add(order);
                continue;
            }
            for (CqlIdentifier mappedColumnName : mappedColumnNames) {
                mappedOrders.add(new Sort.Order(order.getDirection(), mappedColumnName.toString()));
            }
        }
        return Sort.by(mappedOrders);
    }

    private List<CqlIdentifier> getCqlIdentifier(ColumnName column, Field field) {
        ArrayList<CqlIdentifier> identifiers = new ArrayList<CqlIdentifier>(1);
        try {
            if (field.getProperty().isPresent()) {
                CassandraPersistentProperty property = field.getProperty().get();
                if (property.isCompositePrimaryKey()) {
                    BasicCassandraPersistentEntity primaryKeyEntity = (BasicCassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(property);
                    primaryKeyEntity.forEach(it -> identifiers.add(it.getRequiredColumnName()));
                } else {
                    identifiers.add(property.getRequiredColumnName());
                }
            } else if (column.getColumnName().isPresent()) {
                identifiers.add(CqlIdentifier.fromCql((String)column.getColumnName().get()));
            } else {
                column.getCqlIdentifier().ifPresent(identifiers::add);
            }
        }
        catch (IllegalStateException cause) {
            throw new IllegalArgumentException(cause.getMessage(), cause);
        }
        return identifiers;
    }

    Field createPropertyField(@Nullable CassandraPersistentEntity<?> entity, ColumnName key) {
        return Optional.ofNullable(entity).map(e -> new MetadataBackedField(key, (CassandraPersistentEntity<?>)e, (MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty>)this.getMappingContext())).orElseGet(() -> new Field(key));
    }

    ColumnType getColumnType(Field field, @Nullable Object value, ColumnTypeTransformer operator) {
        ColumnTypeResolver resolver = this.converter.getColumnTypeResolver();
        return field.getProperty().map(it -> operator.transform(resolver.resolve((CassandraPersistentProperty)it), (CassandraPersistentProperty)it)).map(ColumnType.class::cast).orElseGet(() -> resolver.resolve(value));
    }

    protected static class MetadataBackedField
    extends Field {
        private final CassandraPersistentEntity<?> entity;
        private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
        private final Optional<PersistentPropertyPath<CassandraPersistentProperty>> path;
        @Nullable
        private final CassandraPersistentProperty property;
        private final Optional<CassandraPersistentProperty> optionalProperty;

        public MetadataBackedField(ColumnName name, CassandraPersistentEntity<?> entity, MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext) {
            this(name, entity, mappingContext, null);
        }

        public MetadataBackedField(ColumnName name, CassandraPersistentEntity<?> entity, MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext, @Nullable CassandraPersistentProperty property) {
            super(name);
            Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
            this.entity = entity;
            this.mappingContext = mappingContext;
            this.path = this.getPath(name.toCql());
            this.property = this.path.map(PersistentPropertyPath::getLeafProperty).orElse(property);
            this.optionalProperty = Optional.ofNullable(this.property);
        }

        private Optional<PersistentPropertyPath<CassandraPersistentProperty>> getPath(String pathExpression) {
            try {
                PropertyPath propertyPath = PropertyPath.from((String)pathExpression.replaceAll("\\.\\d", ""), (TypeInformation)this.entity.getTypeInformation());
                PersistentPropertyPath persistentPropertyPath = this.mappingContext.getPersistentPropertyPath(propertyPath);
                return Optional.of(persistentPropertyPath);
            }
            catch (PropertyReferenceException e) {
                return Optional.empty();
            }
        }

        @Override
        public MetadataBackedField with(ColumnName name) {
            return new MetadataBackedField(name, this.entity, this.mappingContext, this.property);
        }

        @Override
        public Optional<CassandraPersistentProperty> getProperty() {
            return this.optionalProperty;
        }

        @Override
        public ColumnName getMappedKey() {
            if (!this.path.isPresent()) {
                return this.name;
            }
            boolean embedded = false;
            CassandraPersistentEntity<?> parentEntity = null;
            CassandraPersistentProperty leafProperty = null;
            Iterator iterator = this.path.get().iterator();
            while (iterator.hasNext()) {
                CassandraPersistentProperty p;
                leafProperty = p = (CassandraPersistentProperty)iterator.next();
                if (embedded) {
                    embedded = false;
                    leafProperty = (CassandraPersistentProperty)parentEntity.getPersistentProperty(p.getName());
                    parentEntity = null;
                }
                if (!p.isEmbedded()) continue;
                embedded = true;
                parentEntity = new EmbeddedEntityOperations(this.mappingContext).getEntity(p);
            }
            return ColumnName.from(leafProperty.getColumnName());
        }
    }

    protected static class Field {
        protected final ColumnName name;

        Field(ColumnName name) {
            Assert.notNull((Object)name, (String)"Name must not be null!");
            this.name = name;
        }

        public Field with(ColumnName name) {
            return new Field(name);
        }

        public Optional<CassandraPersistentProperty> getProperty() {
            return Optional.empty();
        }

        public ColumnName getMappedKey() {
            return this.name;
        }
    }

    static enum ColumnTypeTransformer {
        AS_IS{

            @Override
            ColumnType transform(ColumnType typeDescriptor, CassandraPersistentProperty property) {
                return typeDescriptor;
            }
        }
        ,
        COLLECTION_COMPONENT_TYPE{

            @Override
            ColumnType transform(ColumnType typeDescriptor, CassandraPersistentProperty property) {
                if (property.isCollectionLike()) {
                    return typeDescriptor.getRequiredComponentType();
                }
                return typeDescriptor;
            }
        }
        ,
        ENCLOSING_LIST{

            @Override
            ColumnType transform(ColumnType typeDescriptor, CassandraPersistentProperty property) {
                return ColumnType.listOf(typeDescriptor);
            }
        }
        ,
        ENCLOSING_SET{

            @Override
            ColumnType transform(ColumnType typeDescriptor, CassandraPersistentProperty property) {
                return ColumnType.setOf(typeDescriptor);
            }
        }
        ,
        MAP_KEY_TYPE{

            @Override
            ColumnType transform(ColumnType typeDescriptor, CassandraPersistentProperty property) {
                if (property.isMapLike()) {
                    return typeDescriptor.getRequiredComponentType();
                }
                return typeDescriptor;
            }
        }
        ,
        MAP_VALUE_TYPE{

            @Override
            ColumnType transform(ColumnType typeDescriptor, CassandraPersistentProperty property) {
                if (property.isMapLike()) {
                    return typeDescriptor.getRequiredMapValueType();
                }
                return typeDescriptor;
            }
        }
        ,
        ENCLOSING_MAP_KEY_SET{

            @Override
            ColumnType transform(ColumnType typeDescriptor, CassandraPersistentProperty property) {
                return ColumnType.setOf(MAP_KEY_TYPE.transform(typeDescriptor, property));
            }
        };


        abstract ColumnType transform(ColumnType var1, CassandraPersistentProperty var2);

        static ColumnTypeTransformer of(Field field, CriteriaDefinition.Operator operator) {
            if (operator == CriteriaDefinition.Operators.CONTAINS) {
                return field.getProperty().filter(CassandraPersistentProperty::isMapLike).map(it -> MAP_VALUE_TYPE).orElse(COLLECTION_COMPONENT_TYPE);
            }
            if (operator == CriteriaDefinition.Operators.CONTAINS_KEY) {
                return MAP_KEY_TYPE;
            }
            if (operator == CriteriaDefinition.Operators.IN) {
                return ENCLOSING_LIST;
            }
            return AS_IS;
        }
    }
}

