/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.springframework.data.cassandra.core.cql.ExecutionProfileResolver;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.lang.Nullable;

public class InsertOptions
extends WriteOptions {
    private static final InsertOptions EMPTY = new InsertOptionsBuilder().build();
    private final boolean ifNotExists;
    private final boolean insertNulls;

    private InsertOptions(@Nullable ConsistencyLevel consistencyLevel, ExecutionProfileResolver executionProfileResolver, @Nullable Boolean idempotent, @Nullable CqlIdentifier keyspace, @Nullable Integer pageSize, @Nullable CqlIdentifier routingKeyspace, @Nullable ByteBuffer routingKey, @Nullable ConsistencyLevel serialConsistencyLevel, Duration timeout, Duration ttl, @Nullable Long timestamp, @Nullable Boolean tracing, boolean ifNotExists, boolean insertNulls) {
        super(consistencyLevel, executionProfileResolver, idempotent, keyspace, pageSize, routingKeyspace, routingKey, serialConsistencyLevel, timeout, ttl, timestamp, tracing);
        this.ifNotExists = ifNotExists;
        this.insertNulls = insertNulls;
    }

    public static InsertOptionsBuilder builder() {
        return new InsertOptionsBuilder();
    }

    public static InsertOptions empty() {
        return EMPTY;
    }

    @Override
    public InsertOptionsBuilder mutate() {
        return new InsertOptionsBuilder(this);
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public boolean isInsertNulls() {
        return this.insertNulls;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InsertOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InsertOptions that = (InsertOptions)o;
        if (this.ifNotExists != that.ifNotExists) {
            return false;
        }
        return this.insertNulls == that.insertNulls;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.ifNotExists ? 1 : 0);
        result = 31 * result + (this.insertNulls ? 1 : 0);
        return result;
    }

    public static class InsertOptionsBuilder
    extends WriteOptions.WriteOptionsBuilder {
        private boolean ifNotExists;
        private boolean insertNulls;

        private InsertOptionsBuilder() {
        }

        private InsertOptionsBuilder(InsertOptions insertOptions) {
            super(insertOptions);
            this.ifNotExists = insertOptions.ifNotExists;
            this.insertNulls = insertOptions.insertNulls;
        }

        @Override
        public InsertOptionsBuilder consistencyLevel(ConsistencyLevel consistencyLevel) {
            super.consistencyLevel(consistencyLevel);
            return this;
        }

        @Override
        public InsertOptionsBuilder executionProfile(String profileName) {
            super.executionProfile(profileName);
            return this;
        }

        @Override
        public InsertOptionsBuilder executionProfile(ExecutionProfileResolver executionProfileResolver) {
            super.executionProfile(executionProfileResolver);
            return this;
        }

        @Override
        @Deprecated
        public InsertOptionsBuilder fetchSize(int fetchSize) {
            return (InsertOptionsBuilder)super.fetchSize(fetchSize);
        }

        @Override
        public InsertOptionsBuilder idempotent(boolean idempotent) {
            super.idempotent(idempotent);
            return this;
        }

        @Override
        public InsertOptionsBuilder keyspace(CqlIdentifier keyspace) {
            super.keyspace(keyspace);
            return this;
        }

        @Override
        public InsertOptionsBuilder pageSize(int pageSize) {
            return (InsertOptionsBuilder)super.pageSize(pageSize);
        }

        @Override
        @Deprecated
        public InsertOptionsBuilder readTimeout(long readTimeout) {
            super.readTimeout(readTimeout);
            return this;
        }

        @Override
        @Deprecated
        public InsertOptionsBuilder readTimeout(long readTimeout, TimeUnit timeUnit) {
            super.readTimeout(readTimeout, timeUnit);
            return this;
        }

        @Override
        public InsertOptionsBuilder routingKeyspace(CqlIdentifier routingKeyspace) {
            super.routingKeyspace(routingKeyspace);
            return this;
        }

        @Override
        public InsertOptionsBuilder routingKey(ByteBuffer routingKey) {
            super.routingKey(routingKey);
            return this;
        }

        @Override
        public InsertOptionsBuilder serialConsistencyLevel(ConsistencyLevel consistencyLevel) {
            super.serialConsistencyLevel(consistencyLevel);
            return this;
        }

        @Override
        public InsertOptionsBuilder timeout(Duration timeout) {
            super.timeout(timeout);
            return this;
        }

        @Override
        public InsertOptionsBuilder ttl(Duration ttl) {
            super.ttl(ttl);
            return this;
        }

        @Override
        public InsertOptionsBuilder tracing(boolean tracing) {
            super.tracing(tracing);
            return this;
        }

        @Override
        public InsertOptionsBuilder withTracing() {
            super.withTracing();
            return this;
        }

        @Override
        public InsertOptionsBuilder ttl(int ttl) {
            super.ttl(ttl);
            return this;
        }

        @Override
        public InsertOptionsBuilder timestamp(long timestamp) {
            super.timestamp(timestamp);
            return this;
        }

        @Override
        public InsertOptionsBuilder timestamp(Instant timestamp) {
            super.timestamp(timestamp);
            return this;
        }

        public InsertOptionsBuilder withIfNotExists() {
            return this.ifNotExists(true);
        }

        public InsertOptionsBuilder ifNotExists(boolean ifNotExists) {
            this.ifNotExists = ifNotExists;
            return this;
        }

        public InsertOptionsBuilder withInsertNulls() {
            return this.withInsertNulls(true);
        }

        public InsertOptionsBuilder withInsertNulls(boolean insertNulls) {
            this.insertNulls = insertNulls;
            return this;
        }

        @Override
        public InsertOptions build() {
            return new InsertOptions(this.consistencyLevel, this.executionProfileResolver, this.idempotent, this.keyspace, this.pageSize, this.routingKeyspace, this.routingKey, this.serialConsistencyLevel, this.timeout, this.ttl, this.timestamp, this.tracing, this.ifNotExists, this.insertNulls);
        }
    }
}

