/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.springframework.data.cassandra.core.cql.QueryExtractorDelegate;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.function.SingletonSupplier;

class PreparedStatementDelegate {
    PreparedStatementDelegate() {
    }

    static BoundStatement bind(SimpleStatement source, PreparedStatement ps) {
        BoundStatementBuilder builder = ps.boundStatementBuilder(source.getPositionalValues().toArray());
        Mapper mapper = Mapper.INSTANCE;
        mapper.from(source.getExecutionProfileName()).whenHasText().to(arg_0 -> ((BoundStatementBuilder)builder).setExecutionProfileName(arg_0));
        mapper.from(source.getExecutionProfile()).whenNonNull().to(arg_0 -> ((BoundStatementBuilder)builder).setExecutionProfile(arg_0));
        mapper.from(source.getRoutingKeyspace()).whenNonNull().to(arg_0 -> ((BoundStatementBuilder)builder).setRoutingKeyspace(arg_0));
        mapper.from(source.getRoutingKey()).whenNonNull().to(arg_0 -> ((BoundStatementBuilder)builder).setRoutingKey(arg_0));
        mapper.from(source.getRoutingToken()).whenNonNull().to(arg_0 -> ((BoundStatementBuilder)builder).setRoutingToken(arg_0));
        mapper.from(source.isIdempotent()).whenNonNull().to(arg_0 -> ((BoundStatementBuilder)builder).setIdempotence(arg_0));
        mapper.from(source.isTracing()).whenNonNull().to(arg_0 -> ((BoundStatementBuilder)builder).setTracing(arg_0));
        mapper.from(source.getQueryTimestamp()).whenNot(it -> it == Long.MIN_VALUE).to(arg_0 -> ((BoundStatementBuilder)builder).setQueryTimestamp(arg_0));
        mapper.from(source.getPagingState()).whenNonNull().to(arg_0 -> ((BoundStatementBuilder)builder).setPagingState(arg_0));
        mapper.from(source.getPageSize()).whenNot(it -> (long)it.intValue() == 0L).to(arg_0 -> ((BoundStatementBuilder)builder).setPageSize(arg_0));
        mapper.from(source.getConsistencyLevel()).whenNonNull().to(arg_0 -> ((BoundStatementBuilder)builder).setConsistencyLevel(arg_0));
        mapper.from(source.getSerialConsistencyLevel()).whenNonNull().to(arg_0 -> ((BoundStatementBuilder)builder).setSerialConsistencyLevel(arg_0));
        mapper.from(source.getTimeout()).whenNonNull().to(arg_0 -> ((BoundStatementBuilder)builder).setTimeout(arg_0));
        mapper.from(source.getNode()).whenNonNull().to(arg_0 -> ((BoundStatementBuilder)builder).setNode(arg_0));
        mapper.from(source.getNowInSeconds()).whenNot(it -> it == Integer.MIN_VALUE).to(arg_0 -> ((BoundStatementBuilder)builder).setNowInSeconds(arg_0));
        Map namedValues = source.getNamedValues();
        ColumnDefinitions variableDefinitions = ps.getVariableDefinitions();
        CodecRegistry codecRegistry = builder.codecRegistry();
        for (Map.Entry entry : namedValues.entrySet()) {
            if (entry.getValue() == null) {
                builder = (BoundStatementBuilder)builder.setToNull((CqlIdentifier)entry.getKey());
                continue;
            }
            DataType type = variableDefinitions.get((CqlIdentifier)entry.getKey()).getType();
            builder = (BoundStatementBuilder)builder.set((CqlIdentifier)entry.getKey(), entry.getValue(), codecRegistry.codecFor(type));
        }
        return builder.build();
    }

    static SimpleStatement getStatementForPrepare(Statement<?> statement) {
        if (statement instanceof SimpleStatement) {
            return (SimpleStatement)statement;
        }
        throw new IllegalArgumentException(PreparedStatementDelegate.getMessage(statement));
    }

    static boolean canPrepare(boolean usePreparedStatements, Statement<?> statement, Log logger) {
        if (usePreparedStatements) {
            if (statement instanceof SimpleStatement) {
                return true;
            }
            logger.warn((Object)PreparedStatementDelegate.getMessage(statement));
        }
        return false;
    }

    private static String getMessage(Statement<?> statement) {
        String cql = QueryExtractorDelegate.getCql(statement);
        if (StringUtils.hasText((String)cql)) {
            return String.format("Cannot prepare statement %s (%s). Statement must be a SimpleStatement.", cql, statement);
        }
        return String.format("Cannot prepare statement %s. Statement must be a SimpleStatement.", statement);
    }

    static class Source<T> {
        private final Supplier<T> supplier;
        private final Predicate<T> predicate;

        private Source(Supplier<T> supplier, Predicate<T> predicate) {
            Assert.notNull(predicate, (String)"Predicate must not be null");
            this.supplier = supplier;
            this.predicate = predicate;
        }

        public Source<T> whenNonNull() {
            return new Source<Object>(this.supplier, Objects::nonNull);
        }

        public Source<T> whenTrue() {
            return this.when(Boolean.TRUE::equals);
        }

        public Source<T> whenFalse() {
            return this.when(Boolean.FALSE::equals);
        }

        public Source<T> whenHasText() {
            return this.when(value -> StringUtils.hasText((String)Objects.toString(value, null)));
        }

        public Source<T> whenEqualTo(Object object) {
            return this.when(object::equals);
        }

        public Source<T> whenNot(Predicate<T> predicate) {
            Assert.notNull(predicate, (String)"Predicate must not be null");
            return this.when(predicate.negate());
        }

        public Source<T> when(Predicate<T> predicate) {
            Assert.notNull(predicate, (String)"Predicate must not be null");
            return new Source<T>(this.supplier, this.predicate != null ? this.predicate.and(predicate) : predicate);
        }

        public void to(Consumer<T> consumer) {
            Assert.notNull(consumer, (String)"Consumer must not be null");
            T value = this.supplier.get();
            if (this.predicate.test(value)) {
                consumer.accept(value);
            }
        }
    }

    static enum Mapper {
        INSTANCE;


        public <T> Source<T> from(Supplier<T> supplier) {
            Assert.notNull(supplier, (String)"Supplier must not be null");
            return this.getSource(supplier);
        }

        public <T> Source<T> from(@Nullable T value) {
            return this.from((T)((Supplier<Object>)() -> value));
        }

        private <T> Source<T> getSource(Supplier<T> supplier) {
            return new Source((Supplier)SingletonSupplier.of(supplier), t -> true);
        }
    }
}

