/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

class BeanDefinitionUtils {
    BeanDefinitionUtils() {
    }

    static BeanDefinitionHolder[] getBeanDefinitionsOfType(BeanDefinitionRegistry registry, ListableBeanFactory factory, Class<?> type, boolean includeNonSingletons, boolean allowEagerInit) {
        String[] names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)factory, type, (boolean)includeNonSingletons, (boolean)allowEagerInit);
        if (names.length == 0) {
            return new BeanDefinitionHolder[0];
        }
        BeanDefinitionHolder[] array = new BeanDefinitionHolder[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            BeanDefinition beanDefinition = null;
            while (beanDefinition == null) {
                try {
                    beanDefinition = registry.getBeanDefinition(name);
                }
                catch (NoSuchBeanDefinitionException x) {
                    if (FactoryBean.class.isAssignableFrom(type)) {
                        name = name.substring("&".length());
                        continue;
                    }
                    throw x;
                }
            }
            array[i] = new BeanDefinitionHolder(beanDefinition, name);
        }
        return array;
    }
}

