/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import lombok.NonNull;
import org.reactivestreams.Publisher;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.query.CassandraPageRequest;
import org.springframework.data.cassandra.repository.query.DtoInstantiatingConverter;
import org.springframework.data.cassandra.repository.query.ProjectionUtil;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@FunctionalInterface
interface ReactiveCassandraQueryExecution {
    public Object execute(Statement var1, Class<?> var2);

    public static final class ResultProcessingConverter
    implements Converter<Object, Object> {
        @NonNull
        private final ResultProcessor processor;
        @NonNull
        private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
        @NonNull
        private final EntityInstantiators instantiators;

        public Object convert(Object source) {
            ReturnedType returnedType = this.processor.getReturnedType();
            if (returnedType.getReturnedType().equals(Void.class)) {
                if (source instanceof Mono) {
                    return ((Mono)source).then();
                }
                if (source instanceof Publisher) {
                    return Flux.from((Publisher)((Publisher)source)).then();
                }
            }
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedType.getReturnedType())) {
                return source;
            }
            if (returnedType.isInstance(source)) {
                return source;
            }
            DtoInstantiatingConverter converter = new DtoInstantiatingConverter(returnedType.getReturnedType(), this.mappingContext, this.instantiators);
            return this.processor.processResult(source, (Converter)converter);
        }

        public ResultProcessingConverter(@NonNull ResultProcessor processor, @NonNull MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext, @NonNull EntityInstantiators instantiators) {
            if (processor == null) {
                throw new NullPointerException("processor is marked non-null but is null");
            }
            if (mappingContext == null) {
                throw new NullPointerException("mappingContext is marked non-null but is null");
            }
            if (instantiators == null) {
                throw new NullPointerException("instantiators is marked non-null but is null");
            }
            this.processor = processor;
            this.mappingContext = mappingContext;
            this.instantiators = instantiators;
        }
    }

    public static final class ResultProcessingExecution
    implements ReactiveCassandraQueryExecution {
        @NonNull
        private final ReactiveCassandraQueryExecution delegate;
        @NonNull
        private final Converter<Object, Object> converter;

        @Override
        public Object execute(Statement statement, Class<?> type) {
            return this.converter.convert(this.delegate.execute(statement, type));
        }

        public ResultProcessingExecution(@NonNull ReactiveCassandraQueryExecution delegate, @NonNull Converter<Object, Object> converter) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            if (converter == null) {
                throw new NullPointerException("converter is marked non-null but is null");
            }
            this.delegate = delegate;
            this.converter = converter;
        }
    }

    public static final class ExistsExecution
    implements ReactiveCassandraQueryExecution {
        @NonNull
        private final ReactiveCassandraOperations operations;

        @Override
        public Object execute(Statement statement, Class<?> type) {
            Mono rows = this.operations.getReactiveCqlOperations().queryForRows(statement).buffer(2).next();
            return rows.map(it -> {
                Row row;
                if (it.isEmpty()) {
                    return false;
                }
                if (it.size() == 1 && ProjectionUtil.qualifiesAsCountProjection(row = (Row)it.get(0))) {
                    Object object = row.getObject(0);
                    return ((Number)object).longValue() > 0L;
                }
                return true;
            }).switchIfEmpty(Mono.just((Object)false));
        }

        public ExistsExecution(@NonNull ReactiveCassandraOperations operations) {
            if (operations == null) {
                throw new NullPointerException("operations is marked non-null but is null");
            }
            this.operations = operations;
        }
    }

    public static final class SingleEntityExecution
    implements ReactiveCassandraQueryExecution {
        @NonNull
        private final ReactiveCassandraOperations operations;
        private final boolean limiting;

        @Override
        public Object execute(Statement statement, Class<?> type) {
            return this.operations.select(statement, type).buffer(2).map(objects -> {
                if (objects.isEmpty()) {
                    return null;
                }
                if (objects.size() == 1 || this.limiting) {
                    return objects.get(0);
                }
                throw new IncorrectResultSizeDataAccessException(1, objects.size());
            });
        }

        public SingleEntityExecution(@NonNull ReactiveCassandraOperations operations, boolean limiting) {
            if (operations == null) {
                throw new NullPointerException("operations is marked non-null but is null");
            }
            this.operations = operations;
            this.limiting = limiting;
        }
    }

    public static final class CollectionExecution
    implements ReactiveCassandraQueryExecution {
        @NonNull
        private final ReactiveCassandraOperations operations;

        @Override
        public Object execute(Statement statement, Class<?> type) {
            return this.operations.select(statement, type);
        }

        public CollectionExecution(@NonNull ReactiveCassandraOperations operations) {
            if (operations == null) {
                throw new NullPointerException("operations is marked non-null but is null");
            }
            this.operations = operations;
        }
    }

    public static final class SlicedExecution
    implements ReactiveCassandraQueryExecution {
        @NonNull
        private final ReactiveCassandraOperations operations;
        @NonNull
        private final Pageable pageable;

        @Override
        public Object execute(Statement statement, Class<?> type) {
            CassandraPageRequest.validatePageable(this.pageable);
            Statement statementToUse = statement.setFetchSize(this.pageable.getPageSize());
            if (this.pageable instanceof CassandraPageRequest) {
                statementToUse = statementToUse.setPagingState(((CassandraPageRequest)this.pageable).getPagingState());
            }
            Mono<Slice<?>> slice = this.operations.slice(statementToUse, type);
            if (this.pageable.getSort().isUnsorted()) {
                return slice;
            }
            return slice.map(it -> {
                CassandraPageRequest cassandraPageRequest = (CassandraPageRequest)it.getPageable();
                return new SliceImpl(it.getContent(), (Pageable)cassandraPageRequest.withSort(this.pageable.getSort()), it.hasNext());
            });
        }

        public SlicedExecution(@NonNull ReactiveCassandraOperations operations, @NonNull Pageable pageable) {
            if (operations == null) {
                throw new NullPointerException("operations is marked non-null but is null");
            }
            if (pageable == null) {
                throw new NullPointerException("pageable is marked non-null but is null");
            }
            this.operations = operations;
            this.pageable = pageable;
        }
    }
}

