/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.core.convert.CassandraCustomConversions;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.cql.keyspace.CreateIndexSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CreateTableSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CreateUserTypeSpecification;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentTupleEntity;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentTupleProperty;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.CassandraSimpleTypeHolder;
import org.springframework.data.cassandra.core.mapping.CassandraType;
import org.springframework.data.cassandra.core.mapping.CassandraUserTypePersistentEntity;
import org.springframework.data.cassandra.core.mapping.CodecRegistryTupleTypeFactory;
import org.springframework.data.cassandra.core.mapping.CompositeCassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.core.mapping.EntityMapping;
import org.springframework.data.cassandra.core.mapping.IndexSpecificationFactory;
import org.springframework.data.cassandra.core.mapping.Mapping;
import org.springframework.data.cassandra.core.mapping.PropertyMapping;
import org.springframework.data.cassandra.core.mapping.Table;
import org.springframework.data.cassandra.core.mapping.Tuple;
import org.springframework.data.cassandra.core.mapping.TupleTypeFactory;
import org.springframework.data.cassandra.core.mapping.UserDefinedType;
import org.springframework.data.cassandra.core.mapping.UserTypeResolver;
import org.springframework.data.cassandra.core.mapping.UserTypeUtil;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.Optionals;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class CassandraMappingContext
extends AbstractMappingContext<BasicCassandraPersistentEntity<?>, CassandraPersistentProperty>
implements ApplicationContextAware,
BeanClassLoaderAware {
    @Nullable
    private ApplicationContext applicationContext;
    private CassandraPersistentEntityMetadataVerifier verifier = new CompositeCassandraPersistentEntityMetadataVerifier();
    @Nullable
    private ClassLoader beanClassLoader;
    private CustomConversions customConversions = new CassandraCustomConversions(Collections.emptyList());
    private Mapping mapping = new Mapping();
    private TupleTypeFactory tupleTypeFactory = CodecRegistryTupleTypeFactory.DEFAULT;
    @Nullable
    private UserTypeResolver userTypeResolver;
    private CodecRegistry codecRegistry = CodecRegistry.DEFAULT_INSTANCE;
    private final Map<CqlIdentifier, Set<CassandraPersistentEntity<?>>> entitySetsByTableName = new HashMap();
    private final Set<BasicCassandraPersistentEntity<?>> tableEntities = new HashSet();
    private final Set<BasicCassandraPersistentEntity<?>> userDefinedTypes = new HashSet();

    public CassandraMappingContext() {
        this.setSimpleTypeHolder(CassandraSimpleTypeHolder.HOLDER);
    }

    public CassandraMappingContext(UserTypeResolver userTypeResolver, TupleTypeFactory tupleTypeFactory) {
        this.setUserTypeResolver(userTypeResolver);
        this.setTupleTypeFactory(tupleTypeFactory);
        this.setSimpleTypeHolder(CassandraSimpleTypeHolder.HOLDER);
    }

    public void initialize() {
        super.initialize();
        this.processMappingOverrides();
    }

    private void processMappingOverrides() {
        this.mapping.getEntityMappings().stream().filter(Objects::nonNull).forEach(entityMapping -> {
            Class<?> entityClass = this.getEntityClass(entityMapping.getEntityClassName());
            CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getRequiredPersistentEntity(entityClass);
            String entityTableName = entityMapping.getTableName();
            if (StringUtils.hasText((String)entityTableName)) {
                entity.setTableName(CqlIdentifier.of(entityTableName, Boolean.valueOf(entityMapping.getForceQuote())));
            }
            CassandraMappingContext.processMappingOverrides(entity, entityMapping);
        });
    }

    private Class<?> getEntityClass(String entityClassName) {
        try {
            return ClassUtils.forName((String)entityClassName, (ClassLoader)this.beanClassLoader);
        }
        catch (ClassNotFoundException cause) {
            throw new IllegalStateException(String.format("Unknown persistent entity type name [%s]", entityClassName), cause);
        }
    }

    private static void processMappingOverrides(CassandraPersistentEntity<?> entity, EntityMapping entityMapping) {
        entityMapping.getPropertyMappings().forEach((key, propertyMapping) -> CassandraMappingContext.processMappingOverride(entity, propertyMapping));
    }

    private static void processMappingOverride(CassandraPersistentEntity<?> entity, PropertyMapping mapping) {
        CassandraPersistentProperty property = (CassandraPersistentProperty)entity.getRequiredPersistentProperty(mapping.getPropertyName());
        boolean forceQuote = Boolean.parseBoolean(mapping.getForceQuote());
        property.setForceQuote(forceQuote);
        if (StringUtils.hasText((String)mapping.getColumnName())) {
            property.setColumnName(CqlIdentifier.of(mapping.getColumnName(), forceQuote));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public void setCustomConversions(CustomConversions customConversions) {
        Assert.notNull((Object)customConversions, (String)"CustomConversions must not be null");
        this.customConversions = customConversions;
    }

    public void setMapping(Mapping mapping) {
        Assert.notNull((Object)mapping, (String)"Mapping must not be null");
        this.mapping = mapping;
    }

    public Collection<BasicCassandraPersistentEntity<?>> getTableEntities() {
        return Collections.unmodifiableCollection(this.tableEntities);
    }

    public Collection<CassandraPersistentEntity<?>> getUserDefinedTypeEntities() {
        return Collections.unmodifiableSet(this.userDefinedTypes);
    }

    public void setCodecRegistry(CodecRegistry codecRegistry) {
        Assert.notNull((Object)codecRegistry, (String)"CodecRegistry must not be null");
        this.codecRegistry = codecRegistry;
    }

    @NonNull
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    public void setTupleTypeFactory(TupleTypeFactory tupleTypeFactory) {
        Assert.notNull((Object)tupleTypeFactory, (String)"TupleTypeFactory must not be null");
        this.tupleTypeFactory = tupleTypeFactory;
    }

    @NonNull
    protected TupleTypeFactory getTupleTypeFactory() {
        return this.tupleTypeFactory;
    }

    public void setUserTypeResolver(UserTypeResolver userTypeResolver) {
        Assert.notNull((Object)userTypeResolver, (String)"UserTypeResolver must not be null");
        this.userTypeResolver = userTypeResolver;
    }

    @Nullable
    protected UserTypeResolver getUserTypeResolver() {
        return this.userTypeResolver;
    }

    public void setVerifier(CassandraPersistentEntityMetadataVerifier verifier) {
        this.verifier = verifier;
    }

    public CassandraPersistentEntityMetadataVerifier getVerifier() {
        return this.verifier;
    }

    protected Optional<BasicCassandraPersistentEntity<?>> addPersistentEntity(TypeInformation<?> typeInformation) {
        Optional optional = this.shouldCreatePersistentEntityFor(typeInformation) ? super.addPersistentEntity(typeInformation) : Optional.empty();
        optional.ifPresent(entity -> {
            if (entity.isUserDefinedType()) {
                this.userDefinedTypes.add((BasicCassandraPersistentEntity<?>)entity);
            }
            Set entities = this.entitySetsByTableName.computeIfAbsent(entity.getTableName(), cqlIdentifier -> new HashSet());
            entities.add(entity);
            if (!entity.isUserDefinedType() && !entity.isTupleType() && entity.isAnnotationPresent(Table.class)) {
                this.tableEntities.add((BasicCassandraPersistentEntity<?>)entity);
            }
        });
        return optional;
    }

    protected boolean shouldCreatePersistentEntityFor(TypeInformation<?> typeInfo) {
        return !this.customConversions.hasCustomWriteTarget(typeInfo.getType()) && super.shouldCreatePersistentEntityFor(typeInfo);
    }

    protected <T> BasicCassandraPersistentEntity<T> createPersistentEntity(TypeInformation<T> typeInformation) {
        BasicCassandraPersistentEntity entity = this.isUserDefinedType(typeInformation) ? new CassandraUserTypePersistentEntity<T>(typeInformation, this.getVerifier(), this.resolveUserTypeResolver()) : (this.isTuple(typeInformation) ? new BasicCassandraPersistentTupleEntity<T>(typeInformation, this.getTupleTypeFactory()) : new BasicCassandraPersistentEntity<T>(typeInformation, this.getVerifier()));
        Optional.ofNullable(this.applicationContext).ifPresent(entity::setApplicationContext);
        return entity;
    }

    private boolean isTuple(TypeInformation<?> typeInformation) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)typeInformation.getType(), Tuple.class);
    }

    private boolean isUserDefinedType(TypeInformation<?> typeInformation) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)typeInformation.getType(), UserDefinedType.class);
    }

    @NonNull
    private UserTypeResolver resolveUserTypeResolver() {
        UserTypeResolver resolvedUserTypeResolver = this.getUserTypeResolver();
        Assert.state((resolvedUserTypeResolver != null ? 1 : 0) != 0, (String)"UserTypeResolver must not be null");
        return resolvedUserTypeResolver;
    }

    protected CassandraPersistentProperty createPersistentProperty(Property property, BasicCassandraPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        BasicCassandraPersistentProperty persistentProperty = owner.isTupleType() ? new BasicCassandraPersistentTupleProperty(property, owner, simpleTypeHolder, this.getUserTypeResolver()) : new BasicCassandraPersistentProperty(property, owner, simpleTypeHolder, this.getUserTypeResolver());
        Optional.ofNullable(this.applicationContext).ifPresent(persistentProperty::setApplicationContext);
        return persistentProperty;
    }

    public boolean usesTable(CqlIdentifier name) {
        Assert.notNull((Object)name, (String)"Table name must not be null");
        return this.entitySetsByTableName.containsKey(name);
    }

    public boolean usesUserType(CqlIdentifier name) {
        Assert.notNull((Object)name, (String)"User type name must not be null");
        return this.hasMappedUserType(name) || this.hasReferencedUserType(name);
    }

    private boolean hasMappedUserType(CqlIdentifier identifier) {
        return this.userDefinedTypes.stream().map(CassandraPersistentEntity::getTableName).anyMatch(identifier::equals);
    }

    private boolean hasReferencedUserType(CqlIdentifier identifier) {
        return this.getPersistentEntities().stream().flatMap(entity -> StreamSupport.stream(entity.spliterator(), false)).flatMap(it -> Optionals.toStream((Optional[])new Optional[]{Optional.ofNullable(it.findAnnotation(CassandraType.class))})).map(CassandraType::userTypeName).filter(StringUtils::hasText).map(CqlIdentifier::of).anyMatch(identifier::equals);
    }

    public CreateTableSpecification getCreateTableSpecificationFor(CassandraPersistentEntity<?> entity) {
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        return this.getCreateTableSpecificationFor(entity.getTableName(), entity);
    }

    public CreateTableSpecification getCreateTableSpecificationFor(CqlIdentifier tableName, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)tableName, (String)"Table name must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        CreateTableSpecification specification = CreateTableSpecification.createTable(tableName);
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            if (property.isCompositePrimaryKey()) {
                CassandraPersistentEntity primaryKeyEntity = (CassandraPersistentEntity)this.getRequiredPersistentEntity(property.getRawType());
                Iterator iterator2 = primaryKeyEntity.iterator();
                while (iterator2.hasNext()) {
                    CassandraPersistentProperty primaryKeyProperty = (CassandraPersistentProperty)iterator2.next();
                    if (primaryKeyProperty.isPartitionKeyColumn()) {
                        specification.partitionKeyColumn(primaryKeyProperty.getRequiredColumnName(), this.getDataType(primaryKeyProperty));
                        continue;
                    }
                    specification.clusteredKeyColumn(primaryKeyProperty.getRequiredColumnName(), this.getDataType(primaryKeyProperty), primaryKeyProperty.getPrimaryKeyOrdering());
                }
                continue;
            }
            if (property.isIdProperty() || property.isPartitionKeyColumn()) {
                specification.partitionKeyColumn(property.getRequiredColumnName(), UserTypeUtil.potentiallyFreeze(this.getDataType(property)));
                continue;
            }
            if (property.isClusterKeyColumn()) {
                specification.clusteredKeyColumn(property.getRequiredColumnName(), UserTypeUtil.potentiallyFreeze(this.getDataType(property)), property.getPrimaryKeyOrdering());
                continue;
            }
            specification.column(property.getRequiredColumnName(), UserTypeUtil.potentiallyFreeze(this.getDataType(property)));
        }
        if (specification.getPartitionKeyColumns().isEmpty()) {
            throw new MappingException(String.format("No partition key columns found in entity [%s]", entity.getType()));
        }
        return specification;
    }

    public List<CreateIndexSpecification> getCreateIndexSpecificationsFor(CassandraPersistentEntity<?> entity) {
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        ArrayList<CreateIndexSpecification> indexes = new ArrayList<CreateIndexSpecification>();
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            if (property.isCompositePrimaryKey()) {
                indexes.addAll(this.getCreateIndexSpecificationsFor((CassandraPersistentEntity)this.getRequiredPersistentEntity(property)));
                continue;
            }
            indexes.addAll(IndexSpecificationFactory.createIndexSpecifications(property));
        }
        indexes.forEach(it -> it.tableName(entity.getTableName()));
        return indexes;
    }

    public CreateUserTypeSpecification getCreateUserTypeSpecificationFor(CassandraPersistentEntity<?> entity) {
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        CreateUserTypeSpecification specification = CreateUserTypeSpecification.createType(entity.getTableName());
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            specification.field(property.getRequiredColumnName(), this.getDataTypeWithUserTypeFactory(property, DataTypeProvider.FrozenLiteral));
        }
        if (specification.getFields().isEmpty()) {
            throw new MappingException(String.format("No fields in user type [%s]", entity.getType()));
        }
        return specification;
    }

    public DataType getDataType(Class<?> type) {
        return this.doGetDataType(type, this.customConversions.getCustomWriteTarget(type).orElse(type));
    }

    public TupleType getTupleType(CassandraPersistentEntity<?> persistentEntity) {
        Assert.notNull(persistentEntity, (String)"CassandraPersistentEntity must not be null");
        Assert.isTrue((boolean)persistentEntity.isTupleType(), (String)"CassandraPersistentEntity is not a mapped tuple type");
        return this.getTupleType(DataTypeProvider.EntityUserType, persistentEntity);
    }

    public DataType getDataType(CassandraPersistentProperty property) {
        return this.getDataTypeWithUserTypeFactory(property, DataTypeProvider.EntityUserType);
    }

    private DataType getDataTypeWithUserTypeFactory(CassandraPersistentProperty property, DataTypeProvider dataTypeProvider) {
        if (property.isAnnotationPresent(CassandraType.class)) {
            CassandraType annotation = (CassandraType)property.getRequiredAnnotation(CassandraType.class);
            if (annotation.type() == DataType.Name.TUPLE) {
                DataType[] dataTypes = (DataType[])Arrays.stream(annotation.typeArguments()).map(CassandraSimpleTypeHolder::getDataTypeFor).toArray(DataType[]::new);
                return this.getTupleTypeFactory().create(dataTypes);
            }
            if (annotation.type() == DataType.Name.UDT) {
                CqlIdentifier userTypeName = CqlIdentifier.of(annotation.userTypeName());
                DataType userType = dataTypeProvider.getUserType(userTypeName, this.resolveUserTypeResolver());
                if (userType == null) {
                    throw new MappingException(String.format("User type [%s] not found", userTypeName));
                }
                DataType dataType = this.getUserDataType(property.getTypeInformation(), userType);
                if (dataType != null) {
                    return dataType;
                }
            }
            return property.getDataType();
        }
        if (TupleValue.class.isAssignableFrom(property.getType())) {
            throw new MappingException(String.format("Unsupported raw TupleType to DataType for property [%s] in entity [%s]; Consider adding @CassandraType.", property.getName(), property.getOwner().getName()));
        }
        if (UDTValue.class.isAssignableFrom(property.getType())) {
            throw new MappingException(String.format("Unsupported raw UDTValue to DataType for property [%s] in entity [%s]; Consider adding @CassandraType.", property.getName(), property.getOwner().getName()));
        }
        try {
            DataType dataType = this.getDataTypeWithUserTypeFactory(property.getTypeInformation(), dataTypeProvider, property::getDataType);
            if (dataType == null) {
                throw new MappingException(String.format("Cannot resolve DataType for property [%s] in entity [%s]; Consider adding @CassandraType.", property.getName(), property.getOwner().getName()));
            }
            return dataType;
        }
        catch (InvalidDataAccessApiUsageException e) {
            throw new MappingException(String.format("%s. Consider adding @CassandraType.", e.getMessage()), (Throwable)e);
        }
    }

    @Nullable
    private DataType getDataTypeWithUserTypeFactory(TypeInformation<?> typeInformation, DataTypeProvider dataTypeProvider, Supplier<DataType> fallback) {
        Optional<DataType> customWriteTarget = this.customConversions.getCustomWriteTarget(typeInformation.getType()).map(it -> this.doGetDataType(typeInformation.getType(), (Class<?>)it));
        DataType dataType = customWriteTarget.orElseGet(() -> {
            Class propertyType = typeInformation.getRequiredActualType().getType();
            return this.customConversions.getCustomWriteTarget(propertyType).filter(it -> !typeInformation.isMap()).map(it -> {
                if (typeInformation.isCollectionLike()) {
                    if (List.class.isAssignableFrom(typeInformation.getType())) {
                        return DataType.list((DataType)this.doGetDataType(propertyType, (Class<?>)it));
                    }
                    if (Set.class.isAssignableFrom(typeInformation.getType())) {
                        return DataType.set((DataType)this.doGetDataType(propertyType, (Class<?>)it));
                    }
                }
                return this.doGetDataType(propertyType, (Class<?>)it);
            }).orElse(null);
        });
        if (dataType != null) {
            return dataType;
        }
        if (typeInformation.isCollectionLike()) {
            TypeInformation typeToUse;
            TypeInformation componentType = typeInformation.getRequiredActualType();
            BasicCassandraPersistentEntity persistentEntity = (BasicCassandraPersistentEntity)this.getPersistentEntity(componentType);
            TypeInformation typeInformation2 = typeToUse = persistentEntity != null ? persistentEntity.getTypeInformation() : componentType;
            if (List.class.isAssignableFrom(typeInformation.getType())) {
                return DataType.list((DataType)this.getDataTypeWithUserTypeFactory(typeToUse, dataTypeProvider, fallback));
            }
            if (Set.class.isAssignableFrom(typeInformation.getType())) {
                return DataType.set((DataType)this.getDataTypeWithUserTypeFactory(typeToUse, dataTypeProvider, fallback));
            }
            throw new IllegalArgumentException("Unsupported collection type: " + typeInformation);
        }
        if (typeInformation.isMap()) {
            return this.getMapDataType(typeInformation, dataTypeProvider);
        }
        BasicCassandraPersistentEntity persistentEntity = (BasicCassandraPersistentEntity)this.getPersistentEntity(typeInformation);
        if (persistentEntity != null) {
            if (persistentEntity.isUserDefinedType()) {
                DataType udtType = dataTypeProvider.getDataType(persistentEntity);
                if (udtType != null) {
                    return udtType;
                }
            } else if (persistentEntity.isTupleType()) {
                return this.getTupleType(dataTypeProvider, persistentEntity);
            }
            return dataTypeProvider.getDataType(persistentEntity);
        }
        DataType determinedType = this.doGetDataType(typeInformation);
        if (determinedType != null) {
            return determinedType;
        }
        return fallback.get();
    }

    @Nullable
    private DataType doGetDataType(TypeInformation<?> typeInformation) {
        return this.doGetDataType(typeInformation.getType(), typeInformation.getType());
    }

    @Nullable
    private DataType doGetDataType(Class<?> propertyType, Class<?> converted) {
        CassandraCustomConversions conversions;
        if (this.customConversions instanceof CassandraCustomConversions && ((conversions = (CassandraCustomConversions)this.customConversions).isNativeTimeTypeMarker(converted) || conversions.isNativeTimeTypeMarker(propertyType) && Long.class.equals(converted))) {
            return DataType.time();
        }
        return CassandraSimpleTypeHolder.getDataTypeFor(converted);
    }

    private TupleType getTupleType(DataTypeProvider dataTypeProvider, CassandraPersistentEntity<?> persistentEntity) {
        ArrayList<DataType> types = new ArrayList<DataType>();
        Iterator iterator = persistentEntity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty persistentProperty = (CassandraPersistentProperty)iterator.next();
            types.add(this.getDataTypeWithUserTypeFactory(persistentProperty, dataTypeProvider));
        }
        return this.getTupleTypeFactory().create(types);
    }

    private DataType getMapDataType(TypeInformation<?> typeInformation, DataTypeProvider dataTypeProvider) {
        TypeInformation keyTypeInformation = typeInformation.getComponentType();
        TypeInformation valueTypeInformation = typeInformation.getMapValueType();
        DataType keyType = this.getDataTypeWithUserTypeFactory(keyTypeInformation, dataTypeProvider, () -> {
            DataType type = this.doGetDataType(keyTypeInformation.getType(), keyTypeInformation.getType());
            if (type != null) {
                return type;
            }
            throw new MappingException(String.format("Cannot resolve key type for [%s]", typeInformation));
        });
        DataType valueType = this.getDataTypeWithUserTypeFactory(valueTypeInformation, dataTypeProvider, () -> {
            DataType type = this.doGetDataType(valueTypeInformation.getType(), valueTypeInformation.getType());
            if (type != null) {
                return type;
            }
            throw new MappingException("Cannot resolve value type for " + typeInformation + ".");
        });
        return DataType.map((DataType)keyType, (DataType)valueType);
    }

    @Nullable
    private DataType getUserDataType(TypeInformation<?> property, @Nullable DataType elementType) {
        if (property.isCollectionLike()) {
            if (List.class.isAssignableFrom(property.getType())) {
                return DataType.list((DataType)elementType);
            }
            if (Set.class.isAssignableFrom(property.getType())) {
                return DataType.set((DataType)elementType);
            }
        }
        return !property.isCollectionLike() && !property.isMap() ? elementType : null;
    }

    static enum DataTypeProvider {
        EntityUserType{

            @Override
            public DataType getDataType(CassandraPersistentEntity<?> entity) {
                return entity.isTupleType() ? entity.getTupleType() : entity.getUserType();
            }

            @Override
            DataType getUserType(CqlIdentifier userTypeName, UserTypeResolver userTypeResolver) {
                return userTypeResolver.resolveType(userTypeName);
            }
        }
        ,
        FrozenLiteral{

            @Override
            public DataType getDataType(CassandraPersistentEntity<?> entity) {
                return new UserTypeUtil.FrozenLiteralDataType(entity.getTableName());
            }

            @Override
            DataType getUserType(CqlIdentifier userTypeName, UserTypeResolver userTypeResolver) {
                return new UserTypeUtil.FrozenLiteralDataType(userTypeName);
            }
        };


        @Nullable
        abstract DataType getDataType(CassandraPersistentEntity<?> var1);

        @Nullable
        abstract DataType getUserType(CqlIdentifier var1, UserTypeResolver var2);
    }
}

