/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import com.datastax.driver.core.DataType;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.cql.Ordering;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface CassandraPersistentProperty
extends PersistentProperty<CassandraPersistentProperty>,
ApplicationContextAware {
    public void setColumnName(CqlIdentifier var1);

    @Nullable
    public CqlIdentifier getColumnName();

    default public CqlIdentifier getRequiredColumnName() {
        CqlIdentifier columnName = this.getColumnName();
        Assert.state((columnName != null ? 1 : 0) != 0, (String)String.format("No column name available for this persistent property [%1$s.%2$s]", this.getOwner().getName(), this.getName()));
        return columnName;
    }

    public DataType getDataType();

    public void setForceQuote(boolean var1);

    @Nullable
    public Integer getOrdinal();

    default public int getRequiredOrdinal() {
        Integer ordinal = this.getOrdinal();
        Assert.state((ordinal != null ? 1 : 0) != 0, (String)String.format("No ordinal available for this persistent property [%1$s.%2$s]", this.getOwner().getName(), this.getName()));
        return ordinal;
    }

    @Nullable
    public Ordering getPrimaryKeyOrdering();

    public boolean isClusterKeyColumn();

    public boolean isCompositePrimaryKey();

    public boolean isMapLike();

    public boolean isPartitionKeyColumn();

    public boolean isPrimaryKeyColumn();

    @Nullable
    public AnnotatedType findAnnotatedType(Class<? extends Annotation> var1);
}

