/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.generator;

import java.util.Map;
import org.springframework.data.cassandra.core.cql.generator.AddColumnCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.AlterColumnCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.ColumnChangeCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.DropColumnCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.RenameColumnCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.TableOptionsCqlGenerator;
import org.springframework.data.cassandra.core.cql.keyspace.AddColumnSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.AlterColumnSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.AlterTableSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.ColumnChangeSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.DropColumnSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.RenameColumnSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.TableOption;

public class AlterTableCqlGenerator
extends TableOptionsCqlGenerator<AlterTableSpecification> {
    public AlterTableCqlGenerator(AlterTableSpecification specification) {
        super(specification);
    }

    public static String toCql(AlterTableSpecification specification) {
        return new AlterTableCqlGenerator(specification).toCql();
    }

    @Override
    public StringBuilder toCql(StringBuilder cql) {
        this.preambleCql(cql);
        if (!((AlterTableSpecification)this.spec()).getChanges().isEmpty()) {
            cql.append(' ');
            this.changesCql(cql);
        }
        if (!((AlterTableSpecification)this.spec()).getOptions().isEmpty()) {
            cql.append(' ');
            this.optionsCql(cql);
        }
        cql.append(";");
        return cql;
    }

    private void preambleCql(StringBuilder cql) {
        cql.append("ALTER TABLE ").append(((AlterTableSpecification)this.spec()).getName());
    }

    private void changesCql(StringBuilder cql) {
        boolean first = true;
        for (ColumnChangeSpecification change : ((AlterTableSpecification)this.spec()).getChanges()) {
            if (first) {
                first = false;
            } else {
                cql.append(" ");
            }
            this.getCqlGeneratorFor(change).toCql(cql);
        }
    }

    private ColumnChangeCqlGenerator<?> getCqlGeneratorFor(ColumnChangeSpecification change) {
        if (change instanceof AddColumnSpecification) {
            return new AddColumnCqlGenerator((AddColumnSpecification)change);
        }
        if (change instanceof DropColumnSpecification) {
            return new DropColumnCqlGenerator((DropColumnSpecification)change);
        }
        if (change instanceof AlterColumnSpecification) {
            return new AlterColumnCqlGenerator((AlterColumnSpecification)change);
        }
        if (change instanceof RenameColumnSpecification) {
            return new RenameColumnCqlGenerator((RenameColumnSpecification)change);
        }
        throw new IllegalArgumentException("unknown ColumnChangeSpecification type: " + change.getClass().getName());
    }

    private void optionsCql(StringBuilder cql) {
        Map<String, Object> options = ((AlterTableSpecification)this.spec()).getOptions();
        if (options.isEmpty()) {
            return;
        }
        cql.append("WITH ");
        boolean first = true;
        for (String key : options.keySet()) {
            if (key.equals(TableOption.COMPACT_STORAGE.getName())) {
                throw new IllegalArgumentException("Alter table cannot contain the COMPACT STORAGE option");
            }
            if (first) {
                first = false;
            } else {
                cql.append(" AND ");
            }
            cql.append(key);
            Object value = options.get(key);
            if (value == null) continue;
            cql.append(" = ");
            if (value instanceof Map) {
                this.optionValueMap((Map)value, cql);
                continue;
            }
            cql.append(value.toString());
        }
    }
}

