/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.core.convert.AbstractCassandraConverter;
import org.springframework.data.cassandra.core.convert.BasicCassandraRowValueProvider;
import org.springframework.data.cassandra.core.convert.CassandraCustomConversions;
import org.springframework.data.cassandra.core.convert.CassandraTupleValueProvider;
import org.springframework.data.cassandra.core.convert.CassandraUDTValueProvider;
import org.springframework.data.cassandra.core.convert.CassandraValueProvider;
import org.springframework.data.cassandra.core.convert.RowReaderPropertyAccessor;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.BasicMapId;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.CassandraType;
import org.springframework.data.cassandra.core.mapping.MapId;
import org.springframework.data.cassandra.core.mapping.MapIdentifiable;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.PropertyAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class MappingCassandraConverter
extends AbstractCassandraConverter
implements ApplicationContextAware,
BeanClassLoaderAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CassandraMappingContext mappingContext;
    @Nullable
    private ClassLoader beanClassLoader;
    private SpELContext spELContext;

    private static ConversionService newConversionService() {
        return new DefaultConversionService();
    }

    private static CassandraMappingContext newDefaultMappingContext() {
        CassandraMappingContext mappingContext = new CassandraMappingContext();
        mappingContext.setCustomConversions(new CassandraCustomConversions(Collections.emptyList()));
        return mappingContext;
    }

    public MappingCassandraConverter() {
        this(MappingCassandraConverter.newDefaultMappingContext());
    }

    public MappingCassandraConverter(CassandraMappingContext mappingContext) {
        super(MappingCassandraConverter.newConversionService());
        Assert.notNull((Object)((Object)mappingContext), (String)"CassandraMappingContext must not be null");
        this.mappingContext = mappingContext;
        this.spELContext = new SpELContext((PropertyAccessor)RowReaderPropertyAccessor.INSTANCE);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.spELContext = new SpELContext(this.spELContext, (BeanFactory)applicationContext);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    private TypeCodec<Object> getCodec(CassandraPersistentProperty property) {
        return this.getCodecRegistry().codecFor(this.getMappingContext().getDataType(property));
    }

    private CodecRegistry getCodecRegistry() {
        return CodecRegistry.DEFAULT_INSTANCE;
    }

    @Override
    public CassandraMappingContext getMappingContext() {
        return this.mappingContext;
    }

    private ConvertingPropertyAccessor newConvertingPropertyAccessor(Object source, CassandraPersistentEntity<?> entity) {
        PersistentPropertyAccessor propertyAccessor = source instanceof PersistentPropertyAccessor ? (PersistentPropertyAccessor)source : entity.getPropertyAccessor(source);
        return new ConvertingPropertyAccessor(propertyAccessor, this.getConversionService());
    }

    private <S> PersistentEntityParameterValueProvider<CassandraPersistentProperty> newParameterValueProvider(CassandraPersistentEntity<S> entity, CassandraValueProvider valueProvider) {
        return new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)new MappingAndConvertingValueProvider(valueProvider), null);
    }

    private <T> Class<T> transformClassToBeanClassLoaderClass(Class<T> entity) {
        try {
            return ClassUtils.forName((String)entity.getName(), (ClassLoader)this.beanClassLoader);
        }
        catch (ClassNotFoundException | LinkageError ignore) {
            return entity;
        }
    }

    public <R> R read(Class<R> type, Object row) {
        if (row instanceof Row) {
            return this.readRow(type, (Row)row);
        }
        throw new MappingException(String.format("Unknown row object [%s]", ObjectUtils.nullSafeClassName((Object)row)));
    }

    public <R> R readRow(Class<R> type, Row row) {
        Class<R> beanClassLoaderClass = this.transformClassToBeanClassLoaderClass(type);
        ClassTypeInformation typeInfo = ClassTypeInformation.from(beanClassLoaderClass);
        Class rawType = typeInfo.getType();
        if (Row.class.isAssignableFrom(rawType)) {
            return (R)row;
        }
        if (this.getCustomConversions().hasCustomReadTarget(Row.class, rawType) || this.getConversionService().canConvert(Row.class, rawType)) {
            return (R)this.getConversionService().convert((Object)row, rawType);
        }
        if (typeInfo.isCollectionLike() || typeInfo.isMap()) {
            return (R)this.getConversionService().convert((Object)row, type);
        }
        CassandraPersistentEntity persistentEntity = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity((TypeInformation)typeInfo);
        return (R)this.readEntityFromRow(persistentEntity, row);
    }

    private <S> S readEntityFromRow(CassandraPersistentEntity<S> entity, Row row) {
        return this.doRead(entity, row, expressionEvaluator -> new BasicCassandraRowValueProvider(row, (SpELExpressionEvaluator)expressionEvaluator));
    }

    private <S> S readEntityFromTuple(CassandraPersistentEntity<S> entity, TupleValue tupleValue) {
        return this.doRead(entity, tupleValue, expressionEvaluator -> new CassandraTupleValueProvider(tupleValue, this.getCodecRegistry(), (SpELExpressionEvaluator)expressionEvaluator));
    }

    private <S> S readEntityFromUdt(CassandraPersistentEntity<S> entity, UDTValue udtValue) {
        return this.doRead(entity, udtValue, expressionEvaluator -> new CassandraUDTValueProvider(udtValue, this.getCodecRegistry(), (SpELExpressionEvaluator)expressionEvaluator));
    }

    private <S, V> S doRead(CassandraPersistentEntity<S> entity, V value, Function<SpELExpressionEvaluator, CassandraValueProvider> valueProviderSupplier) {
        DefaultSpELExpressionEvaluator expressionEvaluator = new DefaultSpELExpressionEvaluator(value, this.spELContext);
        CassandraValueProvider valueProvider = valueProviderSupplier.apply((SpELExpressionEvaluator)expressionEvaluator);
        PersistentEntityParameterValueProvider<CassandraPersistentProperty> parameterValueProvider = this.newParameterValueProvider(entity, valueProvider);
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, parameterValueProvider);
        ConvertingPropertyAccessor propertyAccessor = this.newConvertingPropertyAccessor(instance, entity);
        this.readProperties(entity, valueProvider, (PersistentPropertyAccessor)propertyAccessor);
        return (S)propertyAccessor.getBean();
    }

    private void readProperties(CassandraPersistentEntity<?> entity, CassandraValueProvider valueProvider, PersistentPropertyAccessor propertyAccessor) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            this.readProperty(entity, property, valueProvider, propertyAccessor);
        }
    }

    private void readProperty(CassandraPersistentEntity<?> entity, CassandraPersistentProperty property, CassandraValueProvider valueProvider, PersistentPropertyAccessor propertyAccessor) {
        if (entity.isConstructorArgument(property)) {
            return;
        }
        if (property.isCompositePrimaryKey()) {
            CassandraPersistentEntity keyEntity = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(property);
            Object key = propertyAccessor.getProperty((PersistentProperty)property);
            if (key == null) {
                key = this.instantiatePrimaryKey(keyEntity, property, valueProvider);
            }
            ConvertingPropertyAccessor pkPropertyAccessor = this.newConvertingPropertyAccessor(key, keyEntity);
            this.readProperties(keyEntity, valueProvider, (PersistentPropertyAccessor)pkPropertyAccessor);
            propertyAccessor.setProperty((PersistentProperty)property, pkPropertyAccessor.getBean());
            return;
        }
        if (!valueProvider.hasProperty(property)) {
            return;
        }
        propertyAccessor.setProperty((PersistentProperty)property, this.getReadValue(valueProvider, property));
    }

    private Object instantiatePrimaryKey(CassandraPersistentEntity<?> entity, CassandraPersistentProperty keyProperty, CassandraValueProvider propertyProvider) {
        return this.instantiators.getInstantiatorFor(entity).createInstance(entity, this.newParameterValueProvider(entity, propertyProvider));
    }

    @Override
    public Object convertToColumnType(Object obj) {
        return this.convertToColumnType(obj, (TypeInformation<?>)ClassTypeInformation.from(obj.getClass()));
    }

    @Override
    public Object convertToColumnType(Object value, TypeInformation<?> typeInformation) {
        Assert.notNull((Object)value, (String)"Value must not be null");
        Assert.notNull(typeInformation, (String)"TypeInformation must not be null");
        return value.getClass().isArray() ? value : this.getWriteValue(value, typeInformation);
    }

    public void write(Object source, Object sink) {
        Assert.notNull((Object)source, (String)"Value must not be null");
        Class<?> beanClassLoaderClass = this.transformClassToBeanClassLoaderClass(source.getClass());
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(beanClassLoaderClass);
        this.write(source, sink, entity);
    }

    @Override
    public void write(Object source, Object sink, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)source, (String)"Value must not be null");
        if (entity == null) {
            throw new MappingException("No mapping metadata found for " + source.getClass());
        }
        if (sink instanceof Map) {
            this.writeMapFromWrapper(this.newConvertingPropertyAccessor(source, entity), (Map)sink, entity);
        } else if (sink instanceof Insert) {
            this.writeInsertFromWrapper(this.newConvertingPropertyAccessor(source, entity), (Insert)sink, entity);
        } else if (sink instanceof Update) {
            this.writeUpdateFromWrapper(this.newConvertingPropertyAccessor(source, entity), (Update)sink, entity);
        } else if (sink instanceof Select.Where) {
            this.writeSelectWhereFromObject(source, (Select.Where)sink, entity);
        } else if (sink instanceof Delete.Where) {
            this.writeDeleteWhereFromObject(source, (Delete.Where)sink, entity);
        } else if (sink instanceof TupleValue) {
            this.writeTupleValue(this.newConvertingPropertyAccessor(source, entity), (TupleValue)sink, entity);
        } else if (sink instanceof UDTValue) {
            this.writeUDTValue(this.newConvertingPropertyAccessor(source, entity), (UDTValue)sink, entity);
        } else {
            throw new MappingException(String.format("Unknown write target [%s]", ObjectUtils.nullSafeClassName((Object)sink)));
        }
    }

    private void writeMapFromWrapper(ConvertingPropertyAccessor accessor, Map<String, Object> insert, CassandraPersistentEntity<?> entity) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            Object value = this.getWriteValue(property, accessor);
            if (this.log.isDebugEnabled()) {
                this.log.debug("doWithProperties Property.type {}, Property.value {}", (Object)property.getType().getName(), value);
            }
            if (property.isCompositePrimaryKey()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Property is a compositeKey");
                }
                if (value == null) continue;
                CassandraPersistentEntity compositePrimaryKey = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(property);
                this.writeMapFromWrapper(this.newConvertingPropertyAccessor(value, compositePrimaryKey), insert, compositePrimaryKey);
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Adding map.entry [{}] - [{}]", (Object)property.getRequiredColumnName().toCql(), value);
            }
            insert.put(property.getRequiredColumnName().toCql(), value);
        }
    }

    private void writeInsertFromWrapper(ConvertingPropertyAccessor propertyAccessor, Insert insert, CassandraPersistentEntity<?> entity) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            Object value = this.getWriteValue(property, propertyAccessor);
            if (this.log.isDebugEnabled()) {
                this.log.debug("doWithProperties Property.type {}, Property.value {}", (Object)property.getType().getName(), value);
            }
            if (property.isCompositePrimaryKey()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Property is a compositeKey");
                }
                if (value == null) continue;
                CassandraPersistentEntity compositePrimaryKey = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(property);
                this.writeInsertFromWrapper(this.newConvertingPropertyAccessor(value, compositePrimaryKey), insert, compositePrimaryKey);
                continue;
            }
            if (value == null) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Adding insert.value [{}] - [{}]", (Object)property.getRequiredColumnName().toCql(), value);
            }
            insert.value(property.getRequiredColumnName().toCql(), value);
        }
    }

    private void writeUpdateFromWrapper(ConvertingPropertyAccessor propertyAccessor, Update update, CassandraPersistentEntity<?> entity) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            Object value = this.getWriteValue(property, propertyAccessor);
            if (property.isCompositePrimaryKey()) {
                CassandraPersistentEntity compositePrimaryKey = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(property);
                if (value == null) continue;
                this.writeUpdateFromWrapper(this.newConvertingPropertyAccessor(value, compositePrimaryKey), update, compositePrimaryKey);
                continue;
            }
            if (this.isPrimaryKeyPart(property)) {
                update.where(QueryBuilder.eq((String)property.getRequiredColumnName().toCql(), value));
                continue;
            }
            update.with(QueryBuilder.set((String)property.getRequiredColumnName().toCql(), value));
        }
    }

    private boolean isPrimaryKeyPart(CassandraPersistentProperty property) {
        return property.isCompositePrimaryKey() || property.isPrimaryKeyColumn() || property.isIdProperty();
    }

    private void writeSelectWhereFromObject(Object object, Select.Where where, CassandraPersistentEntity<?> entity) {
        this.getWhereClauses(object, entity).forEach(arg_0 -> ((Select.Where)where).and(arg_0));
    }

    private void writeDeleteWhereFromObject(Object object, Delete.Where where, CassandraPersistentEntity<?> entity) {
        this.getWhereClauses(object, entity).forEach(arg_0 -> ((Delete.Where)where).and(arg_0));
    }

    @Nullable
    private Object extractId(Object source, CassandraPersistentEntity<?> entity) {
        if (ClassUtils.isAssignableValue((Class)entity.getType(), (Object)source)) {
            return this.getId(source, entity);
        }
        if (source instanceof MapId) {
            return source;
        }
        if (source instanceof MapIdentifiable) {
            return ((MapIdentifiable)source).getMapId();
        }
        return source;
    }

    private Collection<Clause> getWhereClauses(Object source, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)source, (String)"Id source must not be null");
        Object id = this.extractId(source, entity);
        Assert.notNull((Object)id, (String)String.format("No Id value found in object %s", source));
        CassandraPersistentProperty idProperty = (CassandraPersistentProperty)entity.getIdProperty();
        CassandraPersistentProperty compositeIdProperty = null;
        if (idProperty != null && idProperty.isCompositePrimaryKey()) {
            compositeIdProperty = idProperty;
        }
        if (id instanceof MapId) {
            CassandraPersistentEntity whereEntity = compositeIdProperty != null ? (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(compositeIdProperty) : entity;
            return this.getWhereClauses((MapId)MapId.class.cast(id), whereEntity);
        }
        if (idProperty == null) {
            throw new InvalidDataAccessApiUsageException(String.format("Cannot obtain where clauses for entity [%s] using [%s]", entity.getName(), source));
        }
        if (compositeIdProperty != null) {
            if (!ClassUtils.isAssignableValue((Class)compositeIdProperty.getType(), (Object)id)) {
                throw new InvalidDataAccessApiUsageException(String.format("Cannot use [%s] as composite Id for [%s]", id, entity.getName()));
            }
            CassandraPersistentEntity compositePrimaryKey = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(compositeIdProperty);
            return this.getWhereClauses(this.newConvertingPropertyAccessor(id, compositePrimaryKey), compositePrimaryKey);
        }
        Class<?> targetType = this.getTargetType(idProperty);
        return Collections.singleton(QueryBuilder.eq((String)idProperty.getRequiredColumnName().toCql(), (Object)this.getPotentiallyConvertedSimpleValue(id, targetType)));
    }

    private Collection<Clause> getWhereClauses(MapId id, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)id, (String)"MapId must not be null");
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        for (Map.Entry entry : id.entrySet()) {
            CassandraPersistentProperty persistentProperty = (CassandraPersistentProperty)entity.getPersistentProperty((String)entry.getKey());
            if (persistentProperty == null) {
                throw new IllegalArgumentException(String.format("MapId contains references [%s] that is an unknown property of [%s]", entry.getKey(), entity.getName()));
            }
            Object writeValue = this.getWriteValue(entry.getValue(), persistentProperty.getTypeInformation());
            clauses.add(QueryBuilder.eq((String)persistentProperty.getRequiredColumnName().toCql(), (Object)writeValue));
        }
        return clauses;
    }

    private Collection<Clause> getWhereClauses(ConvertingPropertyAccessor accessor, CassandraPersistentEntity<?> entity) {
        Assert.isTrue((boolean)entity.isCompositePrimaryKey(), (String)String.format("Entity [%s] is not a composite primary key", entity.getName()));
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            TypeCodec<Object> codec = this.getCodec(property);
            Object value = accessor.getProperty((PersistentProperty)property, codec.getJavaType().getRawType());
            clauses.add(QueryBuilder.eq((String)property.getRequiredColumnName().toCql(), (Object)value));
        }
        return clauses;
    }

    private void writeTupleValue(ConvertingPropertyAccessor propertyAccessor, TupleValue tupleValue, CassandraPersistentEntity<?> entity) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            Object value = this.getWriteValue(property, propertyAccessor);
            if (this.log.isDebugEnabled()) {
                this.log.debug("writeTupleValue Property.type {}, Property.value {}", (Object)property.getType().getName(), value);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Adding tuple value [{}] - [{}]", (Object)property.getOrdinal(), value);
            }
            TypeCodec<Object> typeCodec = this.getCodec(property);
            tupleValue.set(property.getRequiredOrdinal(), value, typeCodec);
        }
    }

    private void writeUDTValue(ConvertingPropertyAccessor propertyAccessor, UDTValue udtValue, CassandraPersistentEntity<?> entity) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            Object value = this.getWriteValue(property, propertyAccessor);
            if (this.log.isDebugEnabled()) {
                this.log.debug("writeUDTValueWhereFromObject Property.type {}, Property.value {}", (Object)property.getType().getName(), value);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Adding udt.value [{}] - [{}]", (Object)property.getRequiredColumnName().toCql(), value);
            }
            TypeCodec<Object> typeCodec = this.getCodec(property);
            udtValue.set(property.getRequiredColumnName().toCql(), value, typeCodec);
        }
    }

    @Override
    public Object getId(Object object, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)object, (String)"Object instance must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        ConvertingPropertyAccessor propertyAccessor = this.newConvertingPropertyAccessor(object, entity);
        Assert.isTrue((boolean)entity.getType().isAssignableFrom(object.getClass()), (String)String.format("Given instance of type [%s] is not compatible with expected type [%s]", object.getClass().getName(), entity.getType().getName()));
        if (object instanceof MapIdentifiable) {
            return ((MapIdentifiable)object).getMapId();
        }
        CassandraPersistentProperty idProperty = (CassandraPersistentProperty)entity.getIdProperty();
        if (idProperty != null) {
            return propertyAccessor.getProperty((PersistentProperty)idProperty, idProperty.isCompositePrimaryKey() ? idProperty.getType() : this.getTargetType(idProperty));
        }
        MapId id = BasicMapId.id();
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            if (!property.isPrimaryKeyColumn()) continue;
            id.with(property.getName(), this.getWriteValue(property, propertyAccessor));
        }
        return id;
    }

    private Class<?> getTargetType(CassandraPersistentProperty property) {
        return this.getCustomConversions().getCustomWriteTarget(property.getType()).orElseGet(() -> {
            if (property.isAnnotationPresent(CassandraType.class)) {
                return this.getPropertyTargetType(property);
            }
            if (property.isCompositePrimaryKey() || property.isCollectionLike() || this.getCustomConversions().isSimpleType(property.getType())) {
                return property.getType();
            }
            return this.getPropertyTargetType(property);
        });
    }

    private Class<?> getPropertyTargetType(CassandraPersistentProperty property) {
        DataType dataType = this.getMappingContext().getDataType(property);
        if (dataType instanceof UserType || dataType instanceof TupleType) {
            return property.getType();
        }
        TypeCodec codec = this.getCodecRegistry().codecFor(dataType);
        return codec.getJavaType().getRawType();
    }

    @Nullable
    private <T> T getWriteValue(CassandraPersistentProperty property, ConvertingPropertyAccessor propertyAccessor) {
        return (T)this.getWriteValue(propertyAccessor.getProperty((PersistentProperty)property, this.getTargetType(property)), property.getTypeInformation());
    }

    @Nullable
    private Object getWriteValue(@Nullable Object value, @Nullable TypeInformation<?> typeInformation) {
        ClassTypeInformation type;
        Class requestedTargetType;
        if (value == null) {
            return null;
        }
        Class clazz = requestedTargetType = typeInformation != null ? typeInformation.getType() : Object.class;
        if (this.getCustomConversions().hasCustomWriteTarget(value.getClass(), requestedTargetType)) {
            Class resolvedTargetType = this.getCustomConversions().getCustomWriteTarget(value.getClass(), requestedTargetType).orElse(requestedTargetType);
            return this.getConversionService().convert(value, resolvedTargetType);
        }
        if (this.getCustomConversions().hasCustomWriteTarget(value.getClass())) {
            Class resolvedTargetType = (Class)this.getCustomConversions().getCustomWriteTarget(value.getClass()).orElseThrow(() -> new IllegalStateException(String.format("Unable to determined custom write target for value type [%s]", value.getClass().getName())));
            return this.getConversionService().convert(value, resolvedTargetType);
        }
        if (this.getCustomConversions().isSimpleType(value.getClass())) {
            return this.getPotentiallyConvertedSimpleValue(value, requestedTargetType);
        }
        ClassTypeInformation classTypeInformation = type = typeInformation != null ? typeInformation : ClassTypeInformation.from(value.getClass());
        if (value instanceof Collection) {
            return this.writeCollectionInternal((Collection)value, (TypeInformation<?>)type);
        }
        if (value instanceof Map) {
            return this.writeMapInternal((Map)value, (TypeInformation<?>)type);
        }
        TypeInformation actualType = type.getRequiredActualType();
        BasicCassandraPersistentEntity entity = (BasicCassandraPersistentEntity)this.getMappingContext().getPersistentEntity(actualType.getType());
        if (entity != null) {
            if (entity.isTupleType()) {
                TupleValue tupleValue = this.getMappingContext().getTupleType(entity).newValue();
                this.write(value, tupleValue, entity);
                return tupleValue;
            }
            if (entity.isUserDefinedType()) {
                UDTValue udtValue = entity.getUserType().newValue();
                this.write(value, udtValue, entity);
                return udtValue;
            }
        }
        return value;
    }

    private Object writeCollectionInternal(Collection<Object> source, TypeInformation<?> type) {
        Collection converted = CollectionFactory.createCollection(MappingCassandraConverter.getCollectionType(type), (int)source.size());
        TypeInformation actualType = type.getRequiredActualType();
        for (Object element : source) {
            converted.add(this.convertToColumnType(element, actualType));
        }
        return converted;
    }

    private Object writeMapInternal(Map<Object, Object> source, TypeInformation<?> type) {
        Map converted = CollectionFactory.createMap((Class)type.getType(), (int)source.size());
        TypeInformation keyType = type.getRequiredComponentType();
        TypeInformation valueType = type.getRequiredMapValueType();
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            converted.put(this.convertToColumnType(entry.getKey(), keyType), this.convertToColumnType(entry.getValue(), valueType));
        }
        return converted;
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleValue(@Nullable Object value, @Nullable Class<?> requestedTargetType) {
        if (value == null) {
            return null;
        }
        if (Enum.class.isAssignableFrom(value.getClass())) {
            if (requestedTargetType != null && !requestedTargetType.isEnum() && this.getConversionService().canConvert(value.getClass(), requestedTargetType)) {
                return this.getConversionService().convert(value, requestedTargetType);
            }
            return ((Enum)value).name();
        }
        return value;
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleRead(@Nullable Object value, @Nullable Class<?> target) {
        if (value == null || target == null || target.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (this.getCustomConversions().hasCustomReadTarget(value.getClass(), target)) {
            return this.getConversionService().convert(value, target);
        }
        if (Enum.class.isAssignableFrom(target)) {
            return Enum.valueOf(target, value.toString());
        }
        return this.getConversionService().convert(value, target);
    }

    private static Class<?> getCollectionType(TypeInformation<?> type) {
        if (type.getType().isInterface()) {
            return type.getType();
        }
        if (ClassTypeInformation.LIST.isAssignableFrom(type)) {
            return ClassTypeInformation.LIST.getType();
        }
        if (ClassTypeInformation.SET.isAssignableFrom(type)) {
            return ClassTypeInformation.SET.getType();
        }
        if (!type.isCollectionLike()) {
            return ClassTypeInformation.LIST.getType();
        }
        return type.getType();
    }

    @Nullable
    private Object getReadValue(CassandraValueProvider valueProvider, CassandraPersistentProperty property) {
        if (property.isCompositePrimaryKey()) {
            CassandraPersistentEntity keyEntity = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(property);
            return this.instantiatePrimaryKey(keyEntity, property, valueProvider);
        }
        Object value = valueProvider.getPropertyValue(property);
        return value == null ? null : this.convertReadValue(value, property.getTypeInformation());
    }

    @Nullable
    private Object convertReadValue(Object value, TypeInformation<?> typeInformation) {
        BasicCassandraPersistentEntity udtEntity;
        BasicCassandraPersistentEntity tupleEntity;
        if (typeInformation.isCollectionLike() && value instanceof Collection) {
            return this.readCollectionOrArrayInternal((Collection)value, typeInformation);
        }
        if (typeInformation.isMap() && value instanceof Map) {
            return this.readMapInternal((Map)value, typeInformation);
        }
        if (value instanceof TupleValue && (tupleEntity = (BasicCassandraPersistentEntity)this.getMappingContext().getPersistentEntity(typeInformation.getRequiredActualType())) != null) {
            return this.readEntityFromTuple(tupleEntity, (TupleValue)value);
        }
        if (value instanceof UDTValue && (udtEntity = (BasicCassandraPersistentEntity)this.getMappingContext().getPersistentEntity(typeInformation.getRequiredActualType())) != null && udtEntity.isUserDefinedType()) {
            return this.readEntityFromUdt(udtEntity, (UDTValue)value);
        }
        return this.getPotentiallyConvertedSimpleRead(value, typeInformation.getType());
    }

    @Nullable
    private Object readCollectionOrArrayInternal(Collection<?> source, TypeInformation<?> targetType) {
        ArrayList<Object> collection;
        Assert.notNull(targetType, (String)"Target type must not be null");
        Class<?> collectionType = this.resolveCollectionType(targetType);
        Class<?> elementType = this.resolveElementType(targetType);
        Collection<Object> collection2 = collection = targetType.getType().isArray() ? new ArrayList<Object>() : CollectionFactory.createCollection(collectionType, elementType, (int)source.size());
        if (source.isEmpty()) {
            return this.getPotentiallyConvertedSimpleRead(collection, collectionType);
        }
        BasicCassandraPersistentEntity entity = (BasicCassandraPersistentEntity)this.getMappingContext().getPersistentEntity(elementType);
        if (entity != null && entity.isUserDefinedType()) {
            for (Object element : source) {
                collection.add(this.readEntityFromUdt(entity, (UDTValue)element));
            }
        } else if (entity != null && entity.isTupleType()) {
            for (Object element : source) {
                collection.add(this.readEntityFromTuple(entity, (TupleValue)element));
            }
        } else {
            for (Object element : source) {
                collection.add(this.getPotentiallyConvertedSimpleRead(element, elementType));
            }
        }
        return this.getPotentiallyConvertedSimpleRead(collection, targetType.getType());
    }

    private Class<?> resolveCollectionType(TypeInformation typeInformation) {
        Class<List> collectionType = typeInformation.getType();
        return Collection.class.isAssignableFrom(collectionType) ? collectionType : List.class;
    }

    private Class<?> resolveElementType(TypeInformation typeInformation) {
        TypeInformation componentType = typeInformation.getComponentType();
        return componentType != null ? componentType.getType() : Object.class;
    }

    private Object readMapInternal(Map<Object, Object> source, TypeInformation<?> targetType) {
        Assert.notNull(targetType, (String)"Target type must not be null");
        TypeInformation keyType = targetType.getComponentType();
        TypeInformation valueType = targetType.getMapValueType();
        Class rawKeyType = keyType != null ? keyType.getType() : null;
        Map map = CollectionFactory.createMap(this.resolveMapType(targetType), (Class)rawKeyType, (int)source.size());
        if (source.isEmpty()) {
            return map;
        }
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            Object key = entry.getKey();
            if (key != null && rawKeyType != null && !rawKeyType.isAssignableFrom(key.getClass())) {
                key = this.convertReadValue(key, keyType);
            }
            Object value = entry.getValue();
            map.put(key, this.convertReadValue(value, valueType));
        }
        return map;
    }

    private Class<?> resolveMapType(TypeInformation<?> typeInformation) {
        Class<Map> mapType = typeInformation.getType();
        return Map.class.isAssignableFrom(mapType) ? mapType : Map.class;
    }

    class MappingAndConvertingValueProvider
    implements CassandraValueProvider {
        private final CassandraValueProvider parent;

        @Override
        public boolean hasProperty(CassandraPersistentProperty property) {
            return this.parent.hasProperty(property);
        }

        @Nullable
        public <T> T getPropertyValue(CassandraPersistentProperty property) {
            return (T)MappingCassandraConverter.this.getReadValue(this.parent, property);
        }

        public MappingAndConvertingValueProvider(CassandraValueProvider parent) {
            this.parent = parent;
        }
    }
}

