/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.keyspace;

import org.springframework.data.cassandra.core.cql.KeyspaceIdentifier;
import org.springframework.data.cassandra.core.cql.keyspace.DataCenterReplication;
import org.springframework.data.cassandra.core.cql.keyspace.DefaultOption;
import org.springframework.data.cassandra.core.cql.keyspace.KeyspaceDescriptor;
import org.springframework.data.cassandra.core.cql.keyspace.KeyspaceOption;
import org.springframework.data.cassandra.core.cql.keyspace.KeyspaceOptionsSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.Option;
import org.springframework.data.cassandra.util.MapBuilder;
import org.springframework.lang.Nullable;

public class CreateKeyspaceSpecification
extends KeyspaceOptionsSpecification<CreateKeyspaceSpecification>
implements KeyspaceDescriptor {
    private boolean ifNotExists = false;

    private CreateKeyspaceSpecification(KeyspaceIdentifier name) {
        super(name);
    }

    public static CreateKeyspaceSpecification createKeyspace(String name) {
        return new CreateKeyspaceSpecification(KeyspaceIdentifier.of(name));
    }

    public static CreateKeyspaceSpecification createKeyspace(KeyspaceIdentifier name) {
        return new CreateKeyspaceSpecification(name);
    }

    public CreateKeyspaceSpecification ifNotExists() {
        return this.ifNotExists(true);
    }

    public CreateKeyspaceSpecification ifNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
        return this;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public CreateKeyspaceSpecification withSimpleReplication() {
        return this.withSimpleReplication(1L);
    }

    public CreateKeyspaceSpecification withSimpleReplication(long replicationFactor) {
        return this.with(KeyspaceOption.REPLICATION, MapBuilder.map(Option.class, Object.class).entry(new DefaultOption("class", String.class, true, false, true), KeyspaceOption.ReplicationStrategy.SIMPLE_STRATEGY.getValue()).entry(new DefaultOption("replication_factor", Long.class, true, false, false), replicationFactor).build());
    }

    public CreateKeyspaceSpecification withNetworkReplication(DataCenterReplication ... dcrs) {
        MapBuilder<Option, Object> builder = MapBuilder.map(Option.class, Object.class).entry(new DefaultOption("class", String.class, true, false, true), KeyspaceOption.ReplicationStrategy.NETWORK_TOPOLOGY_STRATEGY.getValue());
        for (DataCenterReplication dcr : dcrs) {
            builder.entry(new DefaultOption(dcr.getDataCenter(), Long.class, true, false, false), dcr.getReplicationFactor());
        }
        return this.with(KeyspaceOption.REPLICATION, builder.build());
    }

    @Override
    public CreateKeyspaceSpecification with(KeyspaceOption option) {
        return (CreateKeyspaceSpecification)super.with(option);
    }

    @Override
    public CreateKeyspaceSpecification with(KeyspaceOption option, Object value) {
        return (CreateKeyspaceSpecification)super.with(option, value);
    }

    @Override
    public CreateKeyspaceSpecification with(String name, @Nullable Object value, boolean escape, boolean quote) {
        return (CreateKeyspaceSpecification)super.with(name, value, escape, quote);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateKeyspaceSpecification)) {
            return false;
        }
        CreateKeyspaceSpecification other = (CreateKeyspaceSpecification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getIfNotExists() == other.getIfNotExists();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CreateKeyspaceSpecification;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.getIfNotExists() ? 79 : 97);
        return result;
    }
}

