/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import io.netty.util.concurrent.ImmediateExecutor;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.SettableListenableFuture;
import org.springframework.util.concurrent.SuccessCallback;

public class GuavaListenableFutureAdapter<T>
implements ListenableFuture<T> {
    private final com.google.common.util.concurrent.ListenableFuture<T> adaptee;
    private final ListenableFuture<T> future;

    public GuavaListenableFutureAdapter(com.google.common.util.concurrent.ListenableFuture<T> adaptee, PersistenceExceptionTranslator persistenceExceptionTranslator) {
        Assert.notNull(adaptee, (String)"ListenableFuture must not be null");
        Assert.notNull((Object)persistenceExceptionTranslator, (String)"PersistenceExceptionTranslator must not be null");
        this.adaptee = adaptee;
        this.future = GuavaListenableFutureAdapter.adaptListenableFuture(adaptee, persistenceExceptionTranslator);
    }

    private static <T> ListenableFuture<T> adaptListenableFuture(com.google.common.util.concurrent.ListenableFuture<T> guavaFuture, final PersistenceExceptionTranslator exceptionTranslator) {
        final SettableListenableFuture settableFuture = new SettableListenableFuture();
        Futures.addCallback(guavaFuture, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(@Nullable T result) {
                settableFuture.set(result);
            }

            public void onFailure(Throwable t) {
                DataAccessException dataAccessException;
                if (t instanceof RuntimeException && (dataAccessException = exceptionTranslator.translateExceptionIfPossible((RuntimeException)t)) != null) {
                    settableFuture.setException((Throwable)dataAccessException);
                    return;
                }
                settableFuture.setException(t);
            }
        }, (Executor)ImmediateExecutor.INSTANCE);
        return settableFuture;
    }

    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.future.addCallback(callback);
    }

    public void addCallback(SuccessCallback<? super T> successCallback, FailureCallback failureCallback) {
        this.future.addCallback(successCallback, failureCallback);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.adaptee.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.adaptee.isCancelled();
    }

    public boolean isDone() {
        return this.future.isDone();
    }

    public T get() throws InterruptedException, ExecutionException {
        return (T)this.future.get();
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.future.get(timeout, unit);
    }
}

