/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.policies.RetryPolicy;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.lang.Nullable;

public class InsertOptions
extends WriteOptions {
    private static final InsertOptions EMPTY = new InsertOptionsBuilder().build();
    private boolean ifNotExists;

    private InsertOptions(@Nullable ConsistencyLevel consistencyLevel, @Nullable RetryPolicy retryPolicy, @Nullable Boolean tracing, @Nullable Integer fetchSize, Duration readTimeout, Duration ttl, boolean ifNotExists) {
        super(consistencyLevel, retryPolicy, tracing, fetchSize, readTimeout, ttl);
        this.ifNotExists = ifNotExists;
    }

    public static InsertOptionsBuilder builder() {
        return new InsertOptionsBuilder();
    }

    public static InsertOptions empty() {
        return EMPTY;
    }

    @Override
    public InsertOptionsBuilder mutate() {
        return new InsertOptionsBuilder(this);
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InsertOptions)) {
            return false;
        }
        InsertOptions other = (InsertOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.isIfNotExists() == other.isIfNotExists();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InsertOptions;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + (this.isIfNotExists() ? 79 : 97);
        return result;
    }

    public static class InsertOptionsBuilder
    extends WriteOptions.WriteOptionsBuilder {
        private boolean ifNotExists;

        private InsertOptionsBuilder() {
        }

        private InsertOptionsBuilder(InsertOptions insertOptions) {
            super(insertOptions);
            this.ifNotExists = insertOptions.ifNotExists;
        }

        @Override
        public InsertOptionsBuilder consistencyLevel(ConsistencyLevel consistencyLevel) {
            return (InsertOptionsBuilder)super.consistencyLevel(consistencyLevel);
        }

        @Override
        public InsertOptionsBuilder retryPolicy(RetryPolicy driverRetryPolicy) {
            return (InsertOptionsBuilder)super.retryPolicy(driverRetryPolicy);
        }

        @Override
        public InsertOptionsBuilder fetchSize(int fetchSize) {
            return (InsertOptionsBuilder)super.fetchSize(fetchSize);
        }

        @Override
        public InsertOptionsBuilder readTimeout(long readTimeout) {
            return (InsertOptionsBuilder)super.readTimeout(readTimeout);
        }

        @Override
        @Deprecated
        public InsertOptionsBuilder readTimeout(long readTimeout, TimeUnit timeUnit) {
            return (InsertOptionsBuilder)super.readTimeout(readTimeout, timeUnit);
        }

        @Override
        public InsertOptionsBuilder readTimeout(Duration readTimeout) {
            return (InsertOptionsBuilder)super.readTimeout(readTimeout);
        }

        @Override
        public InsertOptionsBuilder ttl(Duration ttl) {
            return (InsertOptionsBuilder)super.ttl(ttl);
        }

        @Override
        public InsertOptionsBuilder tracing(boolean tracing) {
            return (InsertOptionsBuilder)super.tracing(tracing);
        }

        @Override
        public InsertOptionsBuilder withTracing() {
            return (InsertOptionsBuilder)super.withTracing();
        }

        @Override
        public InsertOptionsBuilder ttl(int ttl) {
            return (InsertOptionsBuilder)super.ttl(ttl);
        }

        public InsertOptionsBuilder withIfNotExists() {
            return this.ifNotExists(true);
        }

        public InsertOptionsBuilder ifNotExists(boolean ifNotExists) {
            this.ifNotExists = ifNotExists;
            return this;
        }

        @Override
        public InsertOptions build() {
            return new InsertOptions(this.consistencyLevel, this.retryPolicy, this.tracing, this.fetchSize, this.readTimeout, this.ttl, this.ifNotExists);
        }
    }
}

