/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.session;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.cassandra.ReactiveResultSet;
import org.springframework.data.cassandra.ReactiveSession;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class DefaultBridgedReactiveSession
implements ReactiveSession {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Session session;
    private final Scheduler scheduler;

    public DefaultBridgedReactiveSession(Session session, Scheduler scheduler) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        Assert.notNull((Object)scheduler, (String)"Scheduler must not be null");
        this.session = session;
        this.scheduler = scheduler;
    }

    @Override
    public Mono<ReactiveResultSet> execute(String query) {
        Assert.hasText((String)query, (String)"Query must not be empty");
        return this.execute((Statement)new SimpleStatement(query));
    }

    @Override
    public Mono<ReactiveResultSet> execute(String query, Object ... values) {
        Assert.hasText((String)query, (String)"Query must not be empty");
        return this.execute((Statement)new SimpleStatement(query, values));
    }

    @Override
    public Mono<ReactiveResultSet> execute(String query, Map<String, Object> values) {
        Assert.hasText((String)query, (String)"Query must not be empty");
        return this.execute((Statement)new SimpleStatement(query, values));
    }

    @Override
    public Mono<ReactiveResultSet> execute(Statement statement) {
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        return Mono.defer(() -> {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Executing Statement [{}]", (Object)statement);
                }
                CompletableFuture future = new CompletableFuture();
                ResultSetFuture resultSetFuture = this.session.executeAsync(statement);
                resultSetFuture.addListener(() -> {
                    if (resultSetFuture.isDone()) {
                        try {
                            future.complete(new DefaultReactiveResultSet(resultSetFuture.getUninterruptibly(), this.scheduler));
                        }
                        catch (Exception e) {
                            future.completeExceptionally(e);
                        }
                    }
                }, Runnable::run);
                return Mono.fromFuture(future);
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
        }).subscribeOn(this.scheduler);
    }

    @Override
    public Mono<PreparedStatement> prepare(String query) {
        Assert.hasText((String)query, (String)"Query must not be empty");
        return this.prepare((RegularStatement)new SimpleStatement(query));
    }

    @Override
    public Mono<PreparedStatement> prepare(RegularStatement statement) {
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        return Mono.defer(() -> {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Preparing Statement [{}]", (Object)statement);
                }
                CompletableFuture future = new CompletableFuture();
                ListenableFuture resultSetFuture = this.session.prepareAsync(statement);
                resultSetFuture.addListener(() -> {
                    if (resultSetFuture.isDone()) {
                        try {
                            future.complete(resultSetFuture.get());
                        }
                        catch (Exception e) {
                            future.completeExceptionally(e);
                        }
                    }
                }, Runnable::run);
                return Mono.fromFuture(future);
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
        }).subscribeOn(this.scheduler);
    }

    @Override
    public void close() {
        this.session.close();
    }

    @Override
    public boolean isClosed() {
        return this.session.isClosed();
    }

    @Override
    public Cluster getCluster() {
        return this.session.getCluster();
    }

    private static class DefaultReactiveResultSet
    implements ReactiveResultSet {
        private final ResultSet resultSet;
        private final Scheduler scheduler;

        DefaultReactiveResultSet(ResultSet resultSet, Scheduler scheduler) {
            this.resultSet = resultSet;
            this.scheduler = scheduler;
        }

        @Override
        public Flux<Row> rows() {
            int prefetch = Math.max(1, this.resultSet.getAvailableWithoutFetching());
            return Flux.fromIterable((Iterable)this.resultSet).subscribeOn(this.scheduler).publishOn(Schedulers.immediate(), prefetch);
        }

        @Override
        public ColumnDefinitions getColumnDefinitions() {
            return this.resultSet.getColumnDefinitions();
        }

        @Override
        public boolean wasApplied() {
            return this.resultSet.wasApplied();
        }

        @Override
        public ExecutionInfo getExecutionInfo() {
            return this.resultSet.getExecutionInfo();
        }

        @Override
        public List<ExecutionInfo> getAllExecutionInfo() {
            return this.resultSet.getAllExecutionInfo();
        }
    }
}

