/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.UserType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.CassandraAdminOperations;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class CassandraPersistentEntitySchemaDropper {
    private final CassandraAdminOperations cassandraAdminOperations;
    private final CassandraMappingContext mappingContext;

    public CassandraPersistentEntitySchemaDropper(CassandraMappingContext mappingContext, CassandraAdminOperations cassandraAdminOperations) {
        Assert.notNull((Object)cassandraAdminOperations, (String)"CassandraAdminOperations must not be null");
        Assert.notNull((Object)mappingContext, (String)"CassandraMappingContext must not be null");
        this.cassandraAdminOperations = cassandraAdminOperations;
        this.mappingContext = mappingContext;
    }

    public void dropTables(boolean dropUnused) {
        KeyspaceMetadata keyspaceMetadata = this.cassandraAdminOperations.getKeyspaceMetadata();
        for (TableMetadata table : keyspaceMetadata.getTables()) {
            if (!dropUnused && !this.mappingContext.usesTable(table)) continue;
            this.cassandraAdminOperations.dropTable(CqlIdentifier.cqlId((CharSequence)table.getName()));
        }
    }

    public void dropUserTypes(boolean dropUnused) {
        HashSet<CqlIdentifier> canRecreate = new HashSet<CqlIdentifier>();
        for (CassandraPersistentEntity<?> entity : this.mappingContext.getUserDefinedTypeEntities()) {
            canRecreate.add(entity.getTableName());
        }
        Collection userTypes = this.cassandraAdminOperations.getKeyspaceMetadata().getUserTypes();
        List<CqlIdentifier> identifiers = this.getUserTypesToDrop(userTypes);
        for (CqlIdentifier identifier : identifiers) {
            if (!canRecreate.contains(identifier) && (!dropUnused || this.mappingContext.usesUserType(identifier))) continue;
            this.cassandraAdminOperations.dropUserType(identifier);
        }
    }

    private List<CqlIdentifier> getUserTypesToDrop(Collection<UserType> knownUserTypes) {
        ArrayList<CqlIdentifier> toDrop = new ArrayList<CqlIdentifier>();
        UserTypeDependencyGraphBuilder builder = new UserTypeDependencyGraphBuilder();
        for (UserType userType : knownUserTypes) {
            builder.addUserType(userType);
        }
        UserTypeDependencyGraph dependencyGraph = builder.build();
        final LinkedHashSet globalSeen = new LinkedHashSet();
        for (UserType userType : knownUserTypes) {
            CqlIdentifier typeName = CqlIdentifier.cqlId((CharSequence)userType.getTypeName());
            toDrop.addAll(dependencyGraph.getDropOrder(typeName, new Predicate<CqlIdentifier>(){

                @Override
                public boolean test(CqlIdentifier type) {
                    return globalSeen.add(type);
                }
            }));
        }
        return toDrop;
    }

    static interface Consumer<T> {
        public void accept(T var1);
    }

    static interface Predicate<T> {
        public boolean test(T var1);
    }

    static class UserTypeDependencyGraph {
        private final MultiValueMap<CqlIdentifier, CqlIdentifier> dependencies;

        UserTypeDependencyGraph(MultiValueMap<CqlIdentifier, CqlIdentifier> dependencies) {
            this.dependencies = dependencies;
        }

        List<CqlIdentifier> getDropOrder(CqlIdentifier typeName, Predicate<CqlIdentifier> typeFilter) {
            ArrayList<CqlIdentifier> toDrop = new ArrayList<CqlIdentifier>();
            if (typeFilter.test(typeName)) {
                List dependants = (List)this.dependencies.get((Object)typeName);
                if (dependants != null) {
                    for (CqlIdentifier dependant : dependants) {
                        toDrop.addAll(this.getDropOrder(dependant, typeFilter));
                    }
                }
                toDrop.add(typeName);
            }
            return toDrop;
        }
    }

    static class UserTypeDependencyGraphBuilder {
        private final MultiValueMap<CqlIdentifier, CqlIdentifier> dependencies = new LinkedMultiValueMap();

        UserTypeDependencyGraphBuilder() {
        }

        void addUserType(UserType userType) {
            final LinkedHashSet seen = new LinkedHashSet();
            this.visitTypes(userType, new Predicate<CqlIdentifier>(){

                @Override
                public boolean test(CqlIdentifier type) {
                    return seen.add(type);
                }
            });
        }

        UserTypeDependencyGraph build() {
            return new UserTypeDependencyGraph((MultiValueMap<CqlIdentifier, CqlIdentifier>)new LinkedMultiValueMap(this.dependencies));
        }

        private void visitTypes(UserType userType, final Predicate<CqlIdentifier> typeFilter) {
            final CqlIdentifier typeName = CqlIdentifier.cqlId((CharSequence)userType.getTypeName());
            if (!typeFilter.test(typeName)) {
                return;
            }
            for (UserType.Field field : userType) {
                if (field.getType() instanceof UserType) {
                    this.addDependency((UserType)field.getType(), typeName, typeFilter);
                    return;
                }
                UserTypeDependencyGraphBuilder.doWithTypeArguments(field.getType(), new Consumer<DataType>(){

                    @Override
                    public void accept(DataType type) {
                        if (type instanceof UserType) {
                            UserTypeDependencyGraphBuilder.this.addDependency((UserType)type, typeName, typeFilter);
                        }
                    }
                });
            }
        }

        private void addDependency(UserType userType, CqlIdentifier requiredBy, Predicate<CqlIdentifier> typeFilter) {
            this.dependencies.add((Object)CqlIdentifier.cqlId((CharSequence)userType.getTypeName()), (Object)requiredBy);
            this.visitTypes(userType, typeFilter);
        }

        private static void doWithTypeArguments(DataType type, Consumer<DataType> callback) {
            for (DataType nested : type.getTypeArguments()) {
                callback.accept(nested);
                UserTypeDependencyGraphBuilder.doWithTypeArguments(nested, callback);
            }
            if (type instanceof TupleType) {
                TupleType tupleType = (TupleType)type;
                for (DataType nested : tupleType.getComponentTypes()) {
                    callback.accept(nested);
                    UserTypeDependencyGraphBuilder.doWithTypeArguments(nested, callback);
                }
            }
        }
    }
}

