/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.UserType;
import java.util.Collection;
import java.util.HashSet;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.CassandraAdminOperations;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.util.Assert;

public class CassandraPersistentEntitySchemaDropper {
    private final CassandraAdminOperations cassandraAdminOperations;
    private final CassandraMappingContext mappingContext;

    public CassandraPersistentEntitySchemaDropper(CassandraMappingContext mappingContext, CassandraAdminOperations cassandraAdminOperations) {
        Assert.notNull((Object)cassandraAdminOperations, (String)"CassandraAdminOperations must not be null");
        Assert.notNull((Object)mappingContext, (String)"CassandraMappingContext must not be null");
        this.cassandraAdminOperations = cassandraAdminOperations;
        this.mappingContext = mappingContext;
    }

    public void dropTables(boolean dropUnused) {
        KeyspaceMetadata keyspaceMetadata = this.cassandraAdminOperations.getKeyspaceMetadata();
        for (TableMetadata table : keyspaceMetadata.getTables()) {
            if (!dropUnused && !this.mappingContext.usesTable(table)) continue;
            this.cassandraAdminOperations.dropTable(CqlIdentifier.cqlId((CharSequence)table.getName()));
        }
    }

    public void dropUserTypes(boolean dropUnused) {
        KeyspaceMetadata keyspaceMetadata = this.cassandraAdminOperations.getKeyspaceMetadata();
        Collection<CassandraPersistentEntity<?>> userDefinedTypeEntities = this.mappingContext.getUserDefinedTypeEntities();
        HashSet<CqlIdentifier> canRecreate = new HashSet<CqlIdentifier>();
        for (CassandraPersistentEntity<?> userDefinedTypeEntity : userDefinedTypeEntities) {
            canRecreate.add(userDefinedTypeEntity.getTableName());
        }
        for (UserType userType : keyspaceMetadata.getUserTypes()) {
            CqlIdentifier identifier = CqlIdentifier.cqlId((CharSequence)userType.getTypeName());
            if (canRecreate.contains(identifier)) {
                this.cassandraAdminOperations.dropUserType(identifier);
                continue;
            }
            if (!dropUnused || this.mappingContext.usesUserType(userType)) continue;
            this.cassandraAdminOperations.dropUserType(identifier);
        }
    }
}

