/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import com.datastax.driver.core.Session;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.data.cassandra.config.BeanDefinitionUtils;
import org.springframework.data.cassandra.config.CassandraSessionFactoryBean;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.mapping.BasicCassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.util.StringUtils;

@Deprecated
public class CassandraMappingBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) throws BeansException {
        if (!(factory instanceof BeanDefinitionRegistry)) {
            return;
        }
        this.registerMissingDefaultableBeanDefinitions((BeanDefinitionRegistry)factory, (ListableBeanFactory)factory);
    }

    private void registerMissingDefaultableBeanDefinitions(BeanDefinitionRegistry registry, ListableBeanFactory factory) {
        BeanDefinitionHolder[] templateBeans = BeanDefinitionUtils.getBeanDefinitionsOfType(registry, factory, CassandraOperations.class, true, true);
        if (templateBeans.length >= 1) {
            return;
        }
        String sessionBeanName = this.findSessionBeanName(registry, factory);
        BeanDefinitionHolder[] converterBeans = BeanDefinitionUtils.getBeanDefinitionsOfType(registry, factory, MappingCassandraConverter.class, true, false);
        if (converterBeans.length > 1) {
            throw this.createAmbiguousBeansException(converterBeans.length, CassandraConverter.class, CassandraTemplate.class);
        }
        if (converterBeans.length == 1) {
            this.registerDefaultTemplate(registry, sessionBeanName, converterBeans[0].getBeanName());
            return;
        }
        BeanDefinitionHolder[] contextBeans = BeanDefinitionUtils.getBeanDefinitionsOfType(registry, factory, CassandraMappingContext.class, true, false);
        if (contextBeans.length > 1) {
            throw this.createAmbiguousBeansException(contextBeans.length, MappingCassandraConverter.class, CassandraMappingContext.class);
        }
        BeanDefinitionHolder contextBean = contextBeans.length == 1 ? contextBeans[0] : this.registerDefaultContext(registry);
        BeanDefinitionHolder converter = this.registerDefaultConverter(registry, contextBean.getBeanName());
        this.registerDefaultTemplate(registry, sessionBeanName, converter.getBeanName());
    }

    private String findSessionBeanName(BeanDefinitionRegistry registry, ListableBeanFactory factory) {
        BeanDefinitionHolder[] sessionBeans = BeanDefinitionUtils.getBeanDefinitionsOfType(registry, factory, Session.class, true, true);
        if (sessionBeans.length == 1) {
            return sessionBeans[0].getBeanName();
        }
        throw this.createAmbiguousBeansException(sessionBeans.length, CassandraTemplate.class, Session.class, CassandraSessionFactoryBean.class);
    }

    private IllegalStateException createAmbiguousBeansException(int beanDefinitionCount, Class<?> defaultBeanType, Class<?> ... types) {
        return new IllegalStateException(String.format("found %d beans of type%s [%s] - %s for creation of default [%s]", beanDefinitionCount, beanDefinitionCount == 1 ? "" : "s", StringUtils.collectionToCommaDelimitedString(this.getNames(types)), beanDefinitionCount == 0 ? "need exactly one" : "can't disambiguate", defaultBeanType.getName()));
    }

    private BeanDefinitionHolder registerDefaultContext(BeanDefinitionRegistry registry) {
        BeanDefinitionHolder contextBean = new BeanDefinitionHolder((BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(BasicCassandraMappingContext.class).getBeanDefinition(), "cassandraMapping");
        registry.registerBeanDefinition(contextBean.getBeanName(), contextBean.getBeanDefinition());
        return contextBean;
    }

    private BeanDefinitionHolder registerDefaultConverter(BeanDefinitionRegistry registry, String contextBeanName) {
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(MappingCassandraConverter.class).addConstructorArgReference(contextBeanName).getBeanDefinition();
        BeanDefinitionHolder converter = new BeanDefinitionHolder((BeanDefinition)beanDefinition, "cassandraConverter");
        registry.registerBeanDefinition(converter.getBeanName(), converter.getBeanDefinition());
        return converter;
    }

    private BeanDefinitionHolder registerDefaultTemplate(BeanDefinitionRegistry registry, String sessionBeanName, String converterBeanName) {
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(CassandraTemplate.class).addConstructorArgReference(sessionBeanName).addConstructorArgReference(converterBeanName).getBeanDefinition();
        BeanDefinitionHolder template = new BeanDefinitionHolder((BeanDefinition)beanDefinition, "cqlTemplate");
        registry.registerBeanDefinition(template.getBeanName(), template.getBeanDefinition());
        return template;
    }

    private Collection<String> getNames(Class<?>[] types) {
        ArrayList<String> names = new ArrayList<String>();
        for (Class<?> type : types) {
            names.add(type.getName());
        }
        return names;
    }
}

