/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.ResultSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.repository.Query;
import org.springframework.data.cassandra.repository.query.CassandraParameters;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class CassandraQueryMethod
extends QueryMethod {
    public static final List<Class<?>> ALLOWED_PARAMETER_TYPES = Collections.unmodifiableList(Arrays.asList(String.class, CharSequence.class, Character.TYPE, Character.class, char[].class, Long.TYPE, Long.class, Boolean.TYPE, Boolean.class, BigDecimal.class, BigInteger.class, Double.TYPE, Double.class, Float.TYPE, Float.class, InetAddress.class, Date.class, UUID.class, Integer.TYPE, Integer.class));
    public static final List<Class<?>> STRING_LIKE_PARAMETER_TYPES = Collections.unmodifiableList(Arrays.asList(CharSequence.class, Character.TYPE, Character.class, char[].class));
    public static final List<Class<?>> DATE_PARAMETER_TYPES = Collections.unmodifiableList(Arrays.asList(Date.class));
    protected Method method;
    protected CassandraMappingContext mappingContext;
    protected Query query;
    protected String queryString;
    protected boolean queryCached = false;
    protected Set<Integer> stringLikeParameterIndexes = new HashSet<Integer>();
    protected Set<Integer> dateParameterIndexes = new HashSet<Integer>();

    public static boolean isMapOfCharSequenceToObject(TypeInformation<?> type) {
        if (!type.isMap()) {
            return false;
        }
        TypeInformation keyType = type.getComponentType();
        TypeInformation valueType = type.getMapValueType();
        return ClassUtils.isAssignable(CharSequence.class, (Class)keyType.getType()) && Object.class.equals((Object)valueType.getType());
    }

    public CassandraQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory, CassandraMappingContext mappingContext) {
        super(method, metadata, factory);
        this.verify(method, metadata);
        this.method = method;
        Assert.notNull((Object)mappingContext, (String)"MappingContext must not be null!");
        this.mappingContext = mappingContext;
    }

    public void verify(Method method, RepositoryMetadata metadata) {
        if (this.isSliceQuery() || this.isPageQuery()) {
            throw new InvalidDataAccessApiUsageException("neither slice nor page queries are supported yet");
        }
        HashSet offendingTypes = new HashSet();
        int i = 0;
        for (Class<?> type : method.getParameterTypes()) {
            if (!ALLOWED_PARAMETER_TYPES.contains(type)) {
                offendingTypes.add(type);
            }
            for (Class<?> quotedType : STRING_LIKE_PARAMETER_TYPES) {
                if (!quotedType.isAssignableFrom(type)) continue;
                this.stringLikeParameterIndexes.add(i);
            }
            for (Class<?> quotedType : DATE_PARAMETER_TYPES) {
                if (!quotedType.isAssignableFrom(type)) continue;
                this.dateParameterIndexes.add(i);
            }
            ++i;
        }
        if (offendingTypes.size() > 0) {
            throw new IllegalArgumentException(String.format("encountered unsupported query parameter type%s [%s] in method %s", offendingTypes.size() == 1 ? "" : "s", StringUtils.arrayToCommaDelimitedString((Object[])new ArrayList(offendingTypes).toArray()), method));
        }
    }

    protected CassandraParameters createParameters(Method method) {
        return new CassandraParameters(method);
    }

    Query getQueryAnnotation() {
        if (this.query == null) {
            this.query = this.method.getAnnotation(Query.class);
            this.queryCached = true;
        }
        return this.query;
    }

    public boolean hasAnnotatedQuery() {
        return this.getAnnotatedQuery() != null;
    }

    public String getAnnotatedQuery() {
        if (!this.queryCached) {
            this.queryString = (String)AnnotationUtils.getValue((Annotation)this.getQueryAnnotation());
            this.queryString = StringUtils.hasText((String)this.queryString) ? this.queryString : null;
        }
        return this.queryString;
    }

    public TypeInformation<?> getReturnType() {
        return ClassTypeInformation.fromReturnTypeOf((Method)this.method);
    }

    public boolean isResultSetQuery() {
        return ResultSet.class.isAssignableFrom(this.method.getReturnType());
    }

    public boolean isSingleEntityQuery() {
        return ClassUtils.isAssignable((Class)this.getDomainClass(), this.method.getReturnType());
    }

    public boolean isCollectionOfEntityQuery() {
        return this.isQueryForEntity() && this.isCollectionQuery();
    }

    public boolean isMapOfCharSequenceToObjectQuery() {
        return CassandraQueryMethod.isMapOfCharSequenceToObject(this.getReturnType());
    }

    public boolean isListOfMapOfCharSequenceToObject() {
        TypeInformation<?> type = this.getReturnType();
        if (!ClassUtils.isAssignable(List.class, (Class)type.getType())) {
            return false;
        }
        return CassandraQueryMethod.isMapOfCharSequenceToObject(type.getComponentType());
    }

    public boolean isStringLikeParameter(int parameterIndex) {
        return this.stringLikeParameterIndexes.contains(parameterIndex);
    }

    public boolean isDateParameter(int parameterIndex) {
        return this.dateParameterIndexes.contains(parameterIndex);
    }
}

