/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Batch;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.cassandra.core.AsynchronousQueryListener;
import org.springframework.cassandra.core.Cancellable;
import org.springframework.cassandra.core.CqlTemplate;
import org.springframework.cassandra.core.QueryForObjectListener;
import org.springframework.cassandra.core.QueryOptions;
import org.springframework.cassandra.core.SessionCallback;
import org.springframework.cassandra.core.WriteOptions;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.cassandra.core.util.CollectionUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.CassandraConverterRowCallback;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.DeletionListener;
import org.springframework.data.cassandra.core.WriteListener;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.util.Assert;

public class CassandraTemplate
extends CqlTemplate
implements CassandraOperations {
    protected CassandraConverter cassandraConverter;
    protected CassandraMappingContext mappingContext;

    public CassandraTemplate() {
    }

    public CassandraTemplate(Session session) {
        this(session, new MappingCassandraConverter());
    }

    public CassandraTemplate(Session session, CassandraConverter converter) {
        this.setSession(session);
        this.setConverter(converter);
    }

    private static CassandraConverter getDefaultCassandraConverter() {
        MappingCassandraConverter mappingCassandraConverter = new MappingCassandraConverter();
        mappingCassandraConverter.afterPropertiesSet();
        return mappingCassandraConverter;
    }

    public void setConverter(CassandraConverter cassandraConverter) {
        Assert.notNull((Object)cassandraConverter, (String)"CassandraConverter must not be null");
        this.cassandraConverter = cassandraConverter;
        this.mappingContext = cassandraConverter.getMappingContext();
    }

    @Override
    public CassandraConverter getConverter() {
        return this.cassandraConverter;
    }

    public CassandraMappingContext getCassandraMappingContext() {
        return this.mappingContext;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.cassandraConverter);
        Assert.notNull((Object)this.mappingContext);
    }

    @Override
    public boolean exists(Class<?> type, Object id) {
        Assert.notNull(type);
        Assert.notNull((Object)id);
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.mappingContext.getPersistentEntity(type);
        Select select = QueryBuilder.select().countAll().from(entity.getTableName().toCql());
        this.appendIdCriteria(select.where(), entity, id);
        Long count = (Long)this.queryForObject(select, Long.class);
        return count != 0L;
    }

    @Override
    public long count(Class<?> type) {
        return this.count(this.getTableName(type).toCql());
    }

    @Override
    public <T> void delete(List<T> entities) {
        this.delete((T)entities, null);
    }

    @Override
    public <T> void delete(List<T> entities, QueryOptions options) {
        this.doBatchDelete(entities, options);
    }

    @Override
    public void deleteById(Class<?> type, Object id) {
        Assert.notNull(type);
        Assert.notNull((Object)id);
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.mappingContext.getPersistentEntity(type);
        Delete delete = QueryBuilder.delete().from(entity.getTableName().toCql());
        this.appendIdCriteria(delete.where(), entity, id);
        this.execute(delete);
    }

    @Override
    public <T> void delete(T entity) {
        this.delete(entity, null);
    }

    @Override
    public <T> void delete(T entity, QueryOptions options) {
        this.doDelete(entity, options);
    }

    @Override
    public <T> Cancellable deleteAsynchronously(List<T> entities) {
        return this.doBatchDeleteAsync(entities, null, null);
    }

    @Override
    public <T> Cancellable deleteAsynchronously(List<T> entities, QueryOptions options) {
        return this.doBatchDeleteAsync(entities, null, options);
    }

    @Override
    public <T> Cancellable deleteAsynchronously(List<T> entities, DeletionListener<T> listener) {
        return this.doBatchDeleteAsync(entities, listener, null);
    }

    @Override
    public <T> Cancellable deleteAsynchronously(List<T> entities, DeletionListener<T> listener, QueryOptions options) {
        return this.doBatchDeleteAsync(entities, listener, options);
    }

    @Override
    public <T> Cancellable deleteAsynchronously(T entity) {
        return this.doDeleteAsync(entity, null, null);
    }

    @Override
    public <T> Cancellable deleteAsynchronously(T entity, QueryOptions options) {
        return this.doDeleteAsync(entity, null, options);
    }

    @Override
    public <T> Cancellable deleteAsynchronously(T entity, DeletionListener<T> listener) {
        return this.doDeleteAsync(entity, listener, null);
    }

    @Override
    public <T> Cancellable deleteAsynchronously(T entity, DeletionListener<T> listener, QueryOptions options) {
        return this.doDeleteAsync(entity, listener, options);
    }

    @Override
    public CqlIdentifier getTableName(Class<?> entityClass) {
        if (entityClass == null) {
            throw new InvalidDataAccessApiUsageException("No class parameter provided, entity table can't be determined!");
        }
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        if (entity == null) {
            throw new InvalidDataAccessApiUsageException("No Persistent Entity information found for the class " + entityClass.getName());
        }
        return entity.getTableName();
    }

    @Override
    public <T> List<T> insert(List<T> entities) {
        return this.insert((T)entities, null);
    }

    @Override
    public <T> List<T> insert(List<T> entities, WriteOptions options) {
        return this.doBatchInsert(entities, options);
    }

    @Override
    public <T> T insert(T entity) {
        return this.insert(entity, null);
    }

    @Override
    public <T> T insert(T entity, WriteOptions options) {
        return this.doInsert(entity, options);
    }

    @Override
    @Deprecated
    public <T> List<T> insertAsynchronously(List<T> entities) {
        this.insertAsynchronously((T)entities, (WriteOptions)null);
        return entities;
    }

    @Override
    @Deprecated
    public <T> List<T> insertAsynchronously(List<T> entities, WriteOptions options) {
        this.doInsertAsynchronously(entities, null, options);
        return entities;
    }

    @Override
    public <T> Cancellable insertAsynchronously(List<T> entities, WriteListener<T> listener) {
        return this.doInsertAsynchronously(entities, listener, null);
    }

    @Override
    public <T> Cancellable insertAsynchronously(List<T> entities, WriteListener<T> listener, WriteOptions options) {
        return this.doInsertAsynchronously(entities, listener, options);
    }

    protected <T> Cancellable doInsertAsynchronously(List<T> entities, WriteListener<T> listener, WriteOptions options) {
        return this.doBatchInsertAsync(entities, listener, options);
    }

    @Override
    @Deprecated
    public <T> T insertAsynchronously(T entity) {
        this.insertAsynchronously(entity, null, null);
        return entity;
    }

    @Override
    @Deprecated
    public <T> T insertAsynchronously(T entity, WriteOptions options) {
        this.insertAsynchronously(entity, null, options);
        return entity;
    }

    @Override
    public <T> Cancellable insertAsynchronously(T entity, WriteListener<T> listener) {
        return this.insertAsynchronously(entity, listener, null);
    }

    @Override
    public <T> Cancellable insertAsynchronously(T entity, WriteListener<T> listener, WriteOptions options) {
        return this.doInsertAsync(entity, listener, options);
    }

    @Override
    public <T> List<T> selectAll(Class<T> type) {
        return this.select(QueryBuilder.select().all().from(this.getTableName(type).toCql()), type);
    }

    @Override
    public <T> List<T> select(String cql, Class<T> type) {
        Assert.hasText((String)cql);
        Assert.notNull(type);
        return this.select(cql, new CassandraConverterRowCallback<T>(this.cassandraConverter, type));
    }

    @Override
    public <T> List<T> select(Select select, Class<T> type) {
        Assert.notNull((Object)select);
        return this.select(select, new CassandraConverterRowCallback<T>(this.cassandraConverter, type));
    }

    @Override
    public <T> List<T> selectBySimpleIds(Class<T> type, Iterable<?> ids) {
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.mappingContext.getPersistentEntity(type);
        if (((CassandraPersistentProperty)entity.getIdProperty()).isCompositePrimaryKey()) {
            throw new IllegalArgumentException(String.format("entity class [%s] uses a composite primary key class [%s] which this method can't support", type.getName(), ((CassandraPersistentProperty)entity.getIdProperty()).getCompositePrimaryKeyEntity().getType().getName()));
        }
        Select select = QueryBuilder.select().all().from(entity.getTableName().toCql());
        select.where(QueryBuilder.in((String)((CassandraPersistentProperty)entity.getIdProperty()).getColumnName().toCql(), (Object[])CollectionUtils.toArray(ids)));
        return this.select(select, type);
    }

    @Override
    public <T> T selectOneById(Class<T> type, Object id) {
        Assert.notNull(type);
        Assert.notNull((Object)id);
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.mappingContext.getPersistentEntity(type);
        if (entity == null) {
            throw new IllegalArgumentException(String.format("unknown entity class [%s]", type.getName()));
        }
        Select select = QueryBuilder.select().all().from(entity.getTableName().toCql());
        this.appendIdCriteria(select.where(), entity, id);
        return this.selectOne(select, type);
    }

    protected void appendIdCriteria(ClauseCallback clauseCallback, CassandraPersistentEntity<?> entity, Map<?, ?> id) {
        for (Map.Entry<?, ?> entry : id.entrySet()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)entity.getPersistentProperty(entry.getKey().toString());
            clauseCallback.doWithClause(QueryBuilder.eq((String)property.getColumnName().toCql(), entry.getValue()));
        }
    }

    protected void appendIdCriteria(final ClauseCallback clauseCallback, CassandraPersistentEntity<?> entity, Object id) {
        if (id instanceof Map) {
            this.appendIdCriteria(clauseCallback, entity, (Map)id);
            return;
        }
        CassandraPersistentProperty idProperty = (CassandraPersistentProperty)entity.getIdProperty();
        if (idProperty.isCompositePrimaryKey()) {
            CassandraPersistentEntity<?> idEntity = idProperty.getCompositePrimaryKeyEntity();
            PersistentPropertyAccessor accessor = idEntity.getPropertyAccessor(id);
            final ConvertingPropertyAccessor idAccessor = new ConvertingPropertyAccessor(accessor, this.cassandraConverter.getConversionService());
            idEntity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

                public void doWithPersistentProperty(CassandraPersistentProperty p) {
                    clauseCallback.doWithClause(QueryBuilder.eq((String)p.getColumnName().toCql(), (Object)idAccessor.getProperty((PersistentProperty)p, p.getActualType())));
                }
            });
            return;
        }
        clauseCallback.doWithClause(QueryBuilder.eq((String)idProperty.getColumnName().toCql(), (Object)id));
    }

    protected void appendIdCriteria(final Select.Where where, CassandraPersistentEntity<?> entity, Object id) {
        this.appendIdCriteria(new ClauseCallback(){

            @Override
            public void doWithClause(Clause clause) {
                where.and(clause);
            }
        }, entity, id);
    }

    protected void appendIdCriteria(final Delete.Where where, CassandraPersistentEntity<?> entity, Object id) {
        this.appendIdCriteria(new ClauseCallback(){

            @Override
            public void doWithClause(Clause clause) {
                where.and(clause);
            }
        }, entity, id);
    }

    @Override
    public <T> T selectOne(String cql, Class<T> type) {
        return this.selectOne(cql, new CassandraConverterRowCallback<T>(this.cassandraConverter, type));
    }

    @Override
    public <T> T selectOne(Select select, Class<T> type) {
        return this.selectOne(select, new CassandraConverterRowCallback<T>(this.cassandraConverter, type));
    }

    @Override
    public <T> List<T> update(List<T> entities) {
        return this.update((T)entities, null);
    }

    @Override
    public <T> List<T> update(List<T> entities, WriteOptions options) {
        return this.doBatchUpdate(entities, options);
    }

    @Override
    public <T> T update(T entity) {
        return this.update(entity, null);
    }

    @Override
    public <T> T update(T entity, WriteOptions options) {
        return this.doUpdate(entity, options);
    }

    @Override
    public <T> List<T> updateAsynchronously(List<T> entities) {
        this.doUpdateAsynchronously(entities, null, null);
        return entities;
    }

    @Override
    public <T> List<T> updateAsynchronously(List<T> entities, WriteOptions options) {
        this.doUpdateAsynchronously(entities, null, options);
        return entities;
    }

    @Override
    public <T> Cancellable updateAsynchronously(List<T> entities, WriteListener<T> listener) {
        return this.doUpdateAsynchronously(entities, listener, null);
    }

    @Override
    public <T> Cancellable updateAsynchronously(List<T> entities, WriteListener<T> listener, WriteOptions options) {
        return this.doUpdateAsynchronously(entities, listener, options);
    }

    protected <T> Cancellable doUpdateAsynchronously(List<T> entities, WriteListener<T> listener, WriteOptions options) {
        return this.doBatchUpdateAsync(entities, listener, options);
    }

    @Override
    public <T> T updateAsynchronously(T entity) {
        this.updateAsynchronously(entity, null, null);
        return entity;
    }

    @Override
    public <T> T updateAsynchronously(T entity, WriteOptions options) {
        this.updateAsynchronously(entity, null, options);
        return entity;
    }

    @Override
    public <T> Cancellable updateAsynchronously(T entity, WriteListener<T> listener) {
        return this.updateAsynchronously(entity, listener, null);
    }

    @Override
    public <T> Cancellable updateAsynchronously(T entity, WriteListener<T> listener, WriteOptions options) {
        return this.doUpdateAsync(entity, listener, options);
    }

    protected <T> List<T> select(final String query, CassandraConverterRowCallback<T> readRowCallback) {
        ResultSet resultSet = (ResultSet)this.doExecute((SessionCallback)new SessionCallback<ResultSet>(){

            public ResultSet doInSession(Session s) throws DataAccessException {
                return s.execute(query);
            }
        });
        if (resultSet == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Row row : resultSet) {
            result.add(readRowCallback.doWith(row));
        }
        return result;
    }

    protected <T> List<T> select(final Select query, CassandraConverterRowCallback<T> readRowCallback) {
        ResultSet resultSet = (ResultSet)this.doExecute((SessionCallback)new SessionCallback<ResultSet>(){

            public ResultSet doInSession(Session s) throws DataAccessException {
                return s.execute((Statement)query);
            }
        });
        if (resultSet == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Row row : resultSet) {
            result.add(readRowCallback.doWith(row));
        }
        return result;
    }

    protected <T> T selectOne(String query, CassandraConverterRowCallback<T> readRowCallback) {
        this.logger.debug(query);
        ResultSet resultSet = this.query(query);
        Iterator iterator = resultSet.iterator();
        if (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            T result = readRowCallback.doWith(row);
            if (iterator.hasNext()) {
                throw new DuplicateKeyException("found two or more results in query " + query);
            }
            return result;
        }
        return null;
    }

    protected <T> T selectOne(Select query, CassandraConverterRowCallback<T> readRowCallback) {
        ResultSet resultSet = this.query(query);
        Iterator iterator = resultSet.iterator();
        if (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            T result = readRowCallback.doWith(row);
            if (iterator.hasNext()) {
                throw new DuplicateKeyException("found two or more results in query " + query);
            }
            return result;
        }
        return null;
    }

    protected <T> void doBatchDelete(List<T> entities, QueryOptions options) {
        this.execute(CassandraTemplate.createDeleteBatchQuery(this.getTableName(entities.get(0).getClass()).toCql(), entities, options, (EntityWriter<Object, Object>)this.cassandraConverter));
    }

    protected <T> Cancellable doBatchDeleteAsync(final List<T> entities, final DeletionListener listener, QueryOptions options) {
        AsynchronousQueryListener aql = listener == null ? null : new AsynchronousQueryListener(){

            public void onQueryComplete(ResultSetFuture rsf) {
                try {
                    rsf.getUninterruptibly();
                    listener.onDeletionComplete(entities);
                }
                catch (Exception e) {
                    listener.onException(CassandraTemplate.this.translateExceptionIfPossible(e));
                }
            }
        };
        return this.executeAsynchronously(CassandraTemplate.createDeleteBatchQuery(this.getTableName(entities.get(0).getClass()).toCql(), entities, options, (EntityWriter<Object, Object>)this.cassandraConverter), aql);
    }

    protected <T> T doInsert(T entity, WriteOptions options) {
        Assert.notNull(entity);
        Insert insert = CassandraTemplate.createInsertQuery(this.getTableName(entity.getClass()).toCql(), entity, options, (EntityWriter<Object, Object>)this.cassandraConverter);
        this.execute(insert);
        return entity;
    }

    protected <T> Cancellable doInsertAsync(final T entity, final WriteListener<T> listener, WriteOptions options) {
        Assert.notNull(entity);
        Insert insert = CassandraTemplate.createInsertQuery(this.getTableName(entity.getClass()).toCql(), entity, options, (EntityWriter<Object, Object>)this.cassandraConverter);
        AsynchronousQueryListener aql = listener == null ? null : new AsynchronousQueryListener(){

            public void onQueryComplete(ResultSetFuture rsf) {
                try {
                    rsf.getUninterruptibly();
                    listener.onWriteComplete(CollectionUtils.toList((Object[])new Object[]{entity}));
                }
                catch (Exception x) {
                    listener.onException(CassandraTemplate.this.translateExceptionIfPossible(x));
                }
            }
        };
        return this.executeAsynchronously(insert, aql);
    }

    protected <T> List<T> doBatchInsert(List<T> entities, WriteOptions options) {
        return this.doBatchWrite(entities, options, true);
    }

    protected <T> List<T> doBatchUpdate(List<T> entities, WriteOptions options) {
        return this.doBatchWrite(entities, options, false);
    }

    protected <T> List<T> doBatchWrite(List<T> entities, WriteOptions options, boolean insert) {
        if (entities == null || entities.size() == 0) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("no-op due to given null or empty list");
            }
            return entities;
        }
        String tableName = this.getTableName(entities.get(0).getClass()).toCql();
        Batch b = insert ? CassandraTemplate.createInsertBatchQuery(tableName, entities, options, (EntityWriter<Object, Object>)this.cassandraConverter) : CassandraTemplate.createUpdateBatchQuery(tableName, entities, options, (EntityWriter<Object, Object>)this.cassandraConverter);
        this.execute(b);
        return entities;
    }

    protected <T> Cancellable doBatchInsertAsync(List<T> entities, WriteListener<T> listener, WriteOptions options) {
        return this.doBatchWriteAsync(entities, listener, options, true);
    }

    protected <T> Cancellable doBatchUpdateAsync(List<T> entities, WriteListener<T> listener, WriteOptions options) {
        return this.doBatchWriteAsync(entities, listener, options, false);
    }

    protected <T> Cancellable doBatchWriteAsync(final List<T> entities, final WriteListener<T> listener, WriteOptions options, boolean insert) {
        if (entities == null || entities.size() == 0) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("no-op due to given null or empty list");
            }
            return new Cancellable(){

                public void cancel() {
                    if (CassandraTemplate.this.logger.isWarnEnabled()) {
                        CassandraTemplate.this.logger.warn("no-op query cancellation due to given null or empty list");
                    }
                }
            };
        }
        String tableName = this.getTableName(entities.get(0).getClass()).toCql();
        Batch b = insert ? CassandraTemplate.createInsertBatchQuery(tableName, entities, options, (EntityWriter<Object, Object>)this.cassandraConverter) : CassandraTemplate.createUpdateBatchQuery(tableName, entities, options, (EntityWriter<Object, Object>)this.cassandraConverter);
        AsynchronousQueryListener aql = listener == null ? null : new AsynchronousQueryListener(){

            public void onQueryComplete(ResultSetFuture rsf) {
                try {
                    rsf.getUninterruptibly();
                    listener.onWriteComplete(entities);
                }
                catch (Exception e) {
                    listener.onException(CassandraTemplate.this.translateExceptionIfPossible(e));
                }
            }
        };
        return this.executeAsynchronously(b, aql);
    }

    protected <T> void doDelete(T entity, QueryOptions options) {
        Assert.notNull(entity);
        Delete delete = CassandraTemplate.createDeleteQuery(this.getTableName(entity.getClass()).toCql(), entity, options, (EntityWriter<Object, Object>)this.cassandraConverter);
        this.execute(delete);
    }

    protected <T> Cancellable doDeleteAsync(final T entity, final DeletionListener listener, QueryOptions options) {
        Assert.notNull(entity);
        Delete delete = CassandraTemplate.createDeleteQuery(this.getTableName(entity.getClass()).toCql(), entity, options, (EntityWriter<Object, Object>)this.cassandraConverter);
        AsynchronousQueryListener aql = listener == null ? null : new AsynchronousQueryListener(){

            public void onQueryComplete(ResultSetFuture rsf) {
                try {
                    rsf.getUninterruptibly();
                    listener.onDeletionComplete(CollectionUtils.toList((Object[])new Object[]{entity}));
                }
                catch (Exception x) {
                    listener.onException(CassandraTemplate.this.translateExceptionIfPossible(x));
                }
            }
        };
        return this.executeAsynchronously(delete, aql);
    }

    protected <T> T doUpdate(T entity, WriteOptions options) {
        Assert.notNull(entity);
        Update update = CassandraTemplate.createUpdateQuery(this.getTableName(entity.getClass()).toCql(), entity, options, (EntityWriter<Object, Object>)this.cassandraConverter);
        this.execute(update);
        return entity;
    }

    protected <T> Cancellable doUpdateAsync(final T entity, final WriteListener<T> listener, WriteOptions options) {
        Assert.notNull(entity);
        Update update = CassandraTemplate.createUpdateQuery(this.getTableName(entity.getClass()).toCql(), entity, options, (EntityWriter<Object, Object>)this.cassandraConverter);
        AsynchronousQueryListener aql = listener == null ? null : new AsynchronousQueryListener(){

            public void onQueryComplete(ResultSetFuture rsf) {
                try {
                    rsf.getUninterruptibly();
                    listener.onWriteComplete(CollectionUtils.toList((Object[])new Object[]{entity}));
                }
                catch (Exception x) {
                    listener.onException(CassandraTemplate.this.translateExceptionIfPossible(x));
                }
            }
        };
        return this.executeAsynchronously(update, aql);
    }

    public static Insert createInsertQuery(String tableName, Object objectToSave, WriteOptions options, EntityWriter<Object, Object> entityWriter) {
        Insert insert = QueryBuilder.insertInto((String)tableName);
        entityWriter.write(objectToSave, (Object)insert);
        CqlTemplate.addWriteOptions((Insert)insert, (WriteOptions)options);
        return insert;
    }

    @Deprecated
    public static Update toUpdateQueryX(String tableName, Object objectToSave, WriteOptions options, EntityWriter<Object, Object> entityWriter) {
        return CassandraTemplate.createUpdateQuery(tableName, objectToSave, options, entityWriter);
    }

    public static Update createUpdateQuery(String tableName, Object objectToSave, WriteOptions options, EntityWriter<Object, Object> entityWriter) {
        Update update = QueryBuilder.update((String)tableName);
        entityWriter.write(objectToSave, (Object)update);
        CqlTemplate.addWriteOptions((Update)update, (WriteOptions)options);
        return update;
    }

    @Deprecated
    public static <T> Batch toUpdateBatchQuery(String tableName, List<T> objectsToSave, WriteOptions options, EntityWriter<Object, Object> entityWriter) {
        return CassandraTemplate.createUpdateBatchQuery(tableName, objectsToSave, options, entityWriter);
    }

    public static <T> Batch createUpdateBatchQuery(String tableName, List<T> objectsToSave, WriteOptions options, EntityWriter<Object, Object> entityWriter) {
        Batch b = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]);
        for (T objectToSave : objectsToSave) {
            b.add((RegularStatement)CassandraTemplate.createUpdateQuery(tableName, objectToSave, options, entityWriter));
        }
        CqlTemplate.addQueryOptions((Statement)b, (QueryOptions)options);
        return b;
    }

    public static <T> Batch createInsertBatchQuery(String tableName, List<T> entities, WriteOptions options, EntityWriter<Object, Object> entityWriter) {
        Batch batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]);
        for (T entity : entities) {
            batch.add((RegularStatement)CassandraTemplate.createInsertQuery(tableName, entity, options, entityWriter));
        }
        CqlTemplate.addQueryOptions((Statement)batch, (QueryOptions)options);
        return batch;
    }

    public static Delete createDeleteQuery(String tableName, Object object, QueryOptions options, EntityWriter<Object, Object> entityWriter) {
        Delete.Selection ds = QueryBuilder.delete();
        Delete delete = ds.from(tableName);
        Delete.Where w = delete.where();
        entityWriter.write(object, (Object)w);
        CqlTemplate.addQueryOptions((Statement)delete, (QueryOptions)options);
        return delete;
    }

    public static <T> Batch createDeleteBatchQuery(String tableName, List<T> entities, QueryOptions options, EntityWriter<Object, Object> entityWriter) {
        Assert.notEmpty(entities);
        Assert.hasText((String)tableName);
        Batch batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]);
        for (T entity : entities) {
            batch.add((RegularStatement)CassandraTemplate.createDeleteQuery(tableName, entity, options, entityWriter));
        }
        CqlTemplate.addQueryOptions((Statement)batch, (QueryOptions)options);
        return batch;
    }

    @Override
    public <T> void deleteAll(Class<T> clazz) {
        if (!this.mappingContext.contains(clazz)) {
            throw new IllegalArgumentException(String.format("unknown persistent entity class [%s]", clazz.getName()));
        }
        this.truncate(((CassandraPersistentEntity)this.mappingContext.getPersistentEntity(clazz)).getTableName());
    }

    @Override
    public <T> Cancellable selectOneAsynchronously(Select select, Class<T> type, QueryForObjectListener<T> listener) {
        return this.selectOneAsynchronously(select, type, listener, null);
    }

    @Override
    public <T> Cancellable selectOneAsynchronously(String cql, Class<T> type, QueryForObjectListener<T> listener) {
        return this.selectOneAsynchronously(cql, type, listener, null);
    }

    @Override
    public <T> Cancellable selectOneAsynchronously(Select select, Class<T> type, QueryForObjectListener<T> listener, QueryOptions options) {
        return this.doSelectOneAsync(select, type, listener, options);
    }

    @Override
    public <T> Cancellable selectOneAsynchronously(String cql, Class<T> type, QueryForObjectListener<T> listener, QueryOptions options) {
        return this.doSelectOneAsync(cql, type, listener, options);
    }

    protected <T> Cancellable doSelectOneAsync(final Object query, final Class<T> type, final QueryForObjectListener<T> listener, QueryOptions options) {
        AsynchronousQueryListener aql = new AsynchronousQueryListener(){

            public void onQueryComplete(ResultSetFuture rsf) {
                try {
                    ResultSet rs = rsf.getUninterruptibly();
                    Iterator iterator = rs.iterator();
                    if (iterator.hasNext()) {
                        Row row = (Row)iterator.next();
                        Object result = new CassandraConverterRowCallback(CassandraTemplate.this.cassandraConverter, type).doWith(row);
                        if (iterator.hasNext()) {
                            throw new DuplicateKeyException("found two or more results in query " + query);
                        }
                        listener.onQueryComplete(result);
                    } else {
                        listener.onQueryComplete(null);
                    }
                }
                catch (Exception e) {
                    listener.onException((Exception)CassandraTemplate.this.translateExceptionIfPossible(e));
                }
            }
        };
        if (query instanceof String) {
            return this.queryAsynchronously((String)query, aql, options);
        }
        if (query instanceof Select) {
            return this.queryAsynchronously((Select)query, aql);
        }
        throw new IllegalArgumentException(String.format("Expected type String or Select; got type [%s] with value [%s]", query.getClass(), query));
    }

    protected static interface ClauseCallback {
        public void doWithClause(Clause var1);
    }
}

