/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.mapping;

import com.datastax.driver.core.DataType;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cassandra.core.Ordering;
import org.springframework.cassandra.core.PrimaryKeyType;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.mapping.CassandraSimpleTypeHolder;
import org.springframework.data.cassandra.mapping.CassandraType;
import org.springframework.data.cassandra.mapping.Column;
import org.springframework.data.cassandra.mapping.Indexed;
import org.springframework.data.cassandra.mapping.PrimaryKey;
import org.springframework.data.cassandra.mapping.PrimaryKeyClass;
import org.springframework.data.cassandra.mapping.PrimaryKeyColumn;
import org.springframework.data.cassandra.util.SpelUtils;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BasicCassandraPersistentProperty
extends AnnotationBasedPersistentProperty<CassandraPersistentProperty>
implements CassandraPersistentProperty,
ApplicationContextAware {
    protected ApplicationContext context;
    protected StandardEvaluationContext spelContext;
    protected List<CqlIdentifier> columnNames;
    protected List<CqlIdentifier> explicitColumnNames;
    protected Boolean forceQuote;

    public BasicCassandraPersistentProperty(Field field, PropertyDescriptor propertyDescriptor, CassandraPersistentEntity<?> owner, CassandraSimpleTypeHolder simpleTypeHolder) {
        super(field, propertyDescriptor, owner, (SimpleTypeHolder)simpleTypeHolder);
        if (owner != null && owner.getApplicationContext() != null) {
            this.setApplicationContext(owner.getApplicationContext());
        }
    }

    public void setApplicationContext(ApplicationContext context) {
        Assert.notNull((Object)context);
        this.context = context;
        this.spelContext = new StandardEvaluationContext();
        this.spelContext.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        this.spelContext.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)context));
        this.spelContext.setRootObject((Object)context);
    }

    @Override
    public CassandraPersistentEntity<?> getOwner() {
        return (CassandraPersistentEntity)super.getOwner();
    }

    @Override
    public boolean isCompositePrimaryKey() {
        return this.getField().getType().isAnnotationPresent(PrimaryKeyClass.class);
    }

    public Class<?> getCompositePrimaryKeyType() {
        if (!this.isCompositePrimaryKey()) {
            return null;
        }
        return this.getField().getType();
    }

    @Override
    public TypeInformation<?> getCompositePrimaryKeyTypeInformation() {
        if (!this.isCompositePrimaryKey()) {
            return null;
        }
        return ClassTypeInformation.from(this.getCompositePrimaryKeyType());
    }

    @Override
    public CqlIdentifier getColumnName() {
        List<CqlIdentifier> columnNames = this.getColumnNames();
        if (columnNames.size() != 1) {
            throw new IllegalStateException("property does not have a single column mapping");
        }
        return columnNames.get(0);
    }

    @Override
    public Ordering getPrimaryKeyOrdering() {
        PrimaryKeyColumn anno = (PrimaryKeyColumn)this.findAnnotation(PrimaryKeyColumn.class);
        return anno == null ? null : anno.ordering();
    }

    @Override
    public DataType getDataType() {
        DataType dataType;
        CassandraType annotation = (CassandraType)this.findAnnotation(CassandraType.class);
        if (annotation != null) {
            return this.getDataTypeFor(annotation);
        }
        if (this.isMap()) {
            List args = this.getTypeInformation().getTypeArguments();
            this.ensureTypeArguments(args.size(), 2);
            return DataType.map((DataType)this.getDataTypeFor(((TypeInformation)args.get(0)).getType()), (DataType)this.getDataTypeFor(((TypeInformation)args.get(1)).getType()));
        }
        if (this.isCollectionLike()) {
            List args = this.getTypeInformation().getTypeArguments();
            this.ensureTypeArguments(args.size(), 1);
            if (Set.class.isAssignableFrom(this.getType())) {
                return DataType.set((DataType)this.getDataTypeFor(((TypeInformation)args.get(0)).getType()));
            }
            if (List.class.isAssignableFrom(this.getType())) {
                return DataType.list((DataType)this.getDataTypeFor(((TypeInformation)args.get(0)).getType()));
            }
        }
        if ((dataType = CassandraSimpleTypeHolder.getDataTypeFor(this.getType())) == null) {
            throw new InvalidDataAccessApiUsageException(String.format("unknown type for property [%s], type [%s] in entity [%s]; only primitive types and collections or maps of primitive types are allowed", this.getName(), this.getType(), this.getOwner().getName()));
        }
        return dataType;
    }

    private DataType getDataTypeFor(CassandraType annotation) {
        DataType.Name type = annotation.type();
        if (type.isCollection()) {
            switch (type) {
                case MAP: {
                    this.ensureTypeArguments(annotation.typeArguments().length, 2);
                    return DataType.map((DataType)this.getDataTypeFor(annotation.typeArguments()[0]), (DataType)this.getDataTypeFor(annotation.typeArguments()[1]));
                }
                case LIST: {
                    this.ensureTypeArguments(annotation.typeArguments().length, 1);
                    return DataType.list((DataType)this.getDataTypeFor(annotation.typeArguments()[0]));
                }
                case SET: {
                    this.ensureTypeArguments(annotation.typeArguments().length, 1);
                    return DataType.set((DataType)this.getDataTypeFor(annotation.typeArguments()[0]));
                }
            }
            throw new InvalidDataAccessApiUsageException(String.format("unknown multivalued DataType [%s] for property [%s] in entity [%s]", type, this.getType(), this.getOwner().getName()));
        }
        return CassandraSimpleTypeHolder.getDataTypeFor(type);
    }

    @Override
    public boolean isIndexed() {
        return this.isAnnotationPresent(Indexed.class);
    }

    @Override
    public boolean isPartitionKeyColumn() {
        PrimaryKeyColumn anno = (PrimaryKeyColumn)this.findAnnotation(PrimaryKeyColumn.class);
        return anno != null && anno.type() == PrimaryKeyType.PARTITIONED;
    }

    @Override
    public boolean isClusterKeyColumn() {
        PrimaryKeyColumn anno = (PrimaryKeyColumn)this.findAnnotation(PrimaryKeyColumn.class);
        return anno != null && anno.type() == PrimaryKeyType.CLUSTERED;
    }

    @Override
    public boolean isPrimaryKeyColumn() {
        return this.isAnnotationPresent(PrimaryKeyColumn.class);
    }

    protected DataType getDataTypeFor(DataType.Name typeName) {
        DataType dataType = CassandraSimpleTypeHolder.getDataTypeFor(typeName);
        if (dataType == null) {
            throw new InvalidDataAccessApiUsageException("only primitive types are allowed inside collections for the property  '" + this.getName() + "' type is '" + this.getType() + "' in the entity " + this.getOwner().getName());
        }
        return dataType;
    }

    protected DataType getDataTypeFor(Class<?> javaType) {
        DataType dataType = CassandraSimpleTypeHolder.getDataTypeFor(javaType);
        if (dataType == null) {
            throw new InvalidDataAccessApiUsageException("only primitive types are allowed inside collections for the property  '" + this.getName() + "' type is '" + this.getType() + "' in the entity " + this.getOwner().getName());
        }
        return dataType;
    }

    protected void ensureTypeArguments(int args, int expected) {
        if (args != expected) {
            throw new InvalidDataAccessApiUsageException("expected " + expected + " of typed arguments for the property  '" + this.getName() + "' type is '" + this.getType() + "' in the entity " + this.getOwner().getName());
        }
    }

    @Override
    public List<CqlIdentifier> getColumnNames() {
        if (this.columnNames != null) {
            return this.columnNames;
        }
        this.columnNames = Collections.unmodifiableList(this.determineColumnNames());
        return this.columnNames;
    }

    protected List<CqlIdentifier> determineColumnNames() {
        ArrayList<CqlIdentifier> columnNames = new ArrayList<CqlIdentifier>();
        if (this.isCompositePrimaryKey()) {
            this.addCompositePrimaryKeyColumnNames(this.getCompositePrimaryKeyEntity(), columnNames);
            return columnNames;
        }
        String defaultName = this.getField().getName();
        String overriddenName = null;
        boolean forceQuote = false;
        if (this.isIdProperty()) {
            PrimaryKey anno = (PrimaryKey)this.findAnnotation(PrimaryKey.class);
            overriddenName = anno == null ? null : anno.value();
            forceQuote = anno == null ? forceQuote : anno.forceQuote();
        } else if (this.isPrimaryKeyColumn()) {
            PrimaryKeyColumn anno = (PrimaryKeyColumn)this.findAnnotation(PrimaryKeyColumn.class);
            overriddenName = anno == null ? null : anno.name();
            forceQuote = anno == null ? forceQuote : anno.forceQuote();
        } else {
            Column anno = (Column)this.findAnnotation(Column.class);
            overriddenName = anno == null ? null : anno.value();
            forceQuote = anno == null ? forceQuote : anno.forceQuote();
        }
        columnNames.add(this.createColumnName(defaultName, overriddenName, forceQuote));
        return columnNames;
    }

    protected CqlIdentifier createColumnName(String defaultName, String overriddenName, boolean forceQuote) {
        String name = defaultName;
        if (StringUtils.hasText((String)overriddenName)) {
            name = this.spelContext == null ? overriddenName : SpelUtils.evaluate(overriddenName, (EvaluationContext)this.spelContext);
        }
        return CqlIdentifier.cqlId((CharSequence)name, (boolean)forceQuote);
    }

    protected void addCompositePrimaryKeyColumnNames(CassandraPersistentEntity<?> compositePrimaryKeyEntity, final List<CqlIdentifier> columnNames) {
        compositePrimaryKeyEntity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty p) {
                if (p.isCompositePrimaryKey()) {
                    BasicCassandraPersistentProperty.this.addCompositePrimaryKeyColumnNames(p.getCompositePrimaryKeyEntity(), columnNames);
                } else {
                    columnNames.add(p.getColumnName());
                }
            }
        });
    }

    @Override
    public void setColumnName(CqlIdentifier columnName) {
        Assert.notNull((Object)columnName);
        this.setColumnNames(Arrays.asList(columnName));
    }

    @Override
    public void setColumnNames(List<CqlIdentifier> columnNames) {
        Assert.notNull(columnNames);
        if (this.columnNames == null) {
            this.getColumnNames();
        }
        if (this.columnNames.size() != columnNames.size()) {
            throw new IllegalStateException(String.format("property [%s] on entity [%s] is mapped to [%s] column%s, but given column name list has size [%s]", this.getName(), this.getOwner().getType().getName(), this.columnNames.size(), this.columnNames.size() == 1 ? "" : "s", columnNames.size()));
        }
        this.explicitColumnNames = Collections.unmodifiableList(new ArrayList<CqlIdentifier>(columnNames));
        this.columnNames = this.explicitColumnNames;
    }

    @Override
    public void setForceQuote(boolean forceQuote) {
        if (this.forceQuote != null && this.forceQuote == forceQuote) {
            return;
        }
        this.forceQuote = forceQuote;
        ArrayList<CqlIdentifier> columnNames = new ArrayList<CqlIdentifier>(this.columnNames == null ? 0 : this.columnNames.size());
        for (CqlIdentifier columnName : this.getColumnNames()) {
            columnNames.add(CqlIdentifier.cqlId((CharSequence)columnName.getUnquoted(), (boolean)forceQuote));
        }
        this.setColumnNames(columnNames);
    }

    @Override
    public List<CassandraPersistentProperty> getCompositePrimaryKeyProperties() {
        if (!this.isCompositePrimaryKey()) {
            throw new IllegalStateException(String.format("[%s] does not represent a composite primary key property", this.getField()));
        }
        return this.getCompositePrimaryKeyEntity().getCompositePrimaryKeyProperties();
    }

    @Override
    public CassandraPersistentEntity<?> getCompositePrimaryKeyEntity() {
        CassandraMappingContext mappingContext = this.getOwner().getMappingContext();
        if (mappingContext == null) {
            throw new IllegalStateException("need CassandraMappingContext");
        }
        return (CassandraPersistentEntity)mappingContext.getPersistentEntity(this.getCompositePrimaryKeyTypeInformation());
    }

    public Association<CassandraPersistentProperty> getAssociation() {
        throw new UnsupportedOperationException("Cassandra does not support associations");
    }

    protected Association<CassandraPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }
}

