/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.keyspace;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.springframework.cassandra.core.cql.CqlStringUtils;
import org.springframework.cassandra.core.keyspace.Option;
import org.springframework.util.Assert;

public class DefaultOption
implements Option {
    private String name;
    private Class<?> type;
    private boolean requiresValue;
    private boolean escapesValue;
    private boolean quotesValue;

    public DefaultOption(String name, Class<?> type, boolean requiresValue, boolean escapesValue, boolean quotesValue) {
        this.setName(name);
        this.setType(type);
        this.requiresValue = requiresValue;
        this.escapesValue = escapesValue;
        this.quotesValue = quotesValue;
    }

    protected void setName(String name) {
        Assert.hasText((String)name, (String)"Name must not be null or empty");
        this.name = name;
    }

    protected void setType(Class<?> type) {
        if (type != null && type.isInterface() && !Map.class.isAssignableFrom(type) && !Collection.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("given type [" + type.getName() + "] must be a class, Map or Collection");
        }
        this.type = type;
    }

    @Override
    public boolean isCoerceable(Object value) {
        if (value == null || this.type == null) {
            return true;
        }
        if (Map.class.isAssignableFrom(this.type)) {
            return Map.class.isAssignableFrom(value.getClass());
        }
        if (Collection.class.isAssignableFrom(this.type)) {
            return Collection.class.isAssignableFrom(value.getClass());
        }
        if (this.type.isEnum()) {
            try {
                String name;
                name = value instanceof Enum ? (name = ((Enum)value).name()) : value.toString();
                Enum.valueOf(this.type, name);
                return true;
            }
            catch (NullPointerException x) {
                return false;
            }
            catch (IllegalArgumentException x) {
                return false;
            }
        }
        try {
            Constructor<?> ctor = this.type.getConstructor(String.class);
            if (!ctor.isAccessible()) {
                ctor.setAccessible(true);
            }
            ctor.newInstance(value.toString());
            return true;
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean takesValue() {
        return this.type != null;
    }

    @Override
    public boolean requiresValue() {
        return this.requiresValue;
    }

    @Override
    public boolean escapesValue() {
        return this.escapesValue;
    }

    @Override
    public boolean quotesValue() {
        return this.quotesValue;
    }

    @Override
    public void checkValue(Object value) {
        if (this.takesValue()) {
            if (value == null) {
                if (this.requiresValue) {
                    throw new IllegalArgumentException("Option [" + this.getName() + "] requires a value");
                }
                return;
            }
            if (this.isCoerceable(value)) {
                return;
            }
            throw new IllegalArgumentException("Option [" + this.getName() + "] takes value coerceable to type [" + this.getType().getName() + "]");
        }
        if (value != null) {
            throw new IllegalArgumentException("Option [" + this.getName() + "] takes no value");
        }
    }

    @Override
    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        this.checkValue(value);
        String string = value.toString();
        string = this.escapesValue ? CqlStringUtils.escapeSingle(string) : string;
        string = this.quotesValue ? CqlStringUtils.singleQuote(string) : string;
        return string;
    }

    public String toString() {
        return "[name=" + this.name + ", type=" + this.type.getName() + ", requiresValue=" + this.requiresValue + ", escapesValue=" + this.escapesValue + ", quotesValue=" + this.quotesValue + "]";
    }
}

