/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.config;

import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class PoolingOptionsFactoryBean
implements FactoryBean<PoolingOptions>,
InitializingBean,
DisposableBean {
    private Integer localMinSimultaneousRequests;
    private Integer localMaxSimultaneousRequests;
    private Integer localCoreConnections;
    private Integer localMaxConnections;
    private Integer remoteMinSimultaneousRequests;
    private Integer remoteMaxSimultaneousRequests;
    private Integer remoteCoreConnections;
    private Integer remoteMaxConnections;
    PoolingOptions poolingOptions;

    public void destroy() throws Exception {
        this.localMinSimultaneousRequests = null;
        this.localMaxSimultaneousRequests = null;
        this.localCoreConnections = null;
        this.localMaxConnections = null;
        this.remoteMinSimultaneousRequests = null;
        this.remoteMaxSimultaneousRequests = null;
        this.remoteCoreConnections = null;
        this.remoteMaxConnections = null;
    }

    public void afterPropertiesSet() throws Exception {
        int currentMax;
        this.poolingOptions = new PoolingOptions();
        if (this.localMaxConnections != null) {
            this.poolingOptions.setMaxConnectionsPerHost(HostDistance.LOCAL, this.localMaxConnections.intValue());
        }
        if (this.localCoreConnections != null) {
            this.poolingOptions.setCoreConnectionsPerHost(HostDistance.LOCAL, this.localCoreConnections.intValue());
        }
        if (this.localMinSimultaneousRequests != null) {
            currentMax = this.poolingOptions.getMaxSimultaneousRequestsPerConnectionThreshold(HostDistance.LOCAL);
            if (currentMax < this.localMinSimultaneousRequests) {
                this.poolingOptions.setMaxSimultaneousRequestsPerConnectionThreshold(HostDistance.LOCAL, this.localMinSimultaneousRequests.intValue());
            }
            this.poolingOptions.setMinSimultaneousRequestsPerConnectionThreshold(HostDistance.LOCAL, this.localMinSimultaneousRequests.intValue());
        }
        if (this.localMaxSimultaneousRequests != null) {
            this.poolingOptions.setMaxSimultaneousRequestsPerConnectionThreshold(HostDistance.LOCAL, this.localMaxSimultaneousRequests.intValue());
        }
        if (this.remoteMaxConnections != null) {
            this.poolingOptions.setMaxConnectionsPerHost(HostDistance.REMOTE, this.remoteMaxConnections.intValue());
        }
        if (this.remoteCoreConnections != null) {
            this.poolingOptions.setCoreConnectionsPerHost(HostDistance.REMOTE, this.remoteCoreConnections.intValue());
        }
        if (this.remoteMinSimultaneousRequests != null) {
            currentMax = this.poolingOptions.getMaxSimultaneousRequestsPerConnectionThreshold(HostDistance.REMOTE);
            if (currentMax < this.remoteMinSimultaneousRequests) {
                this.poolingOptions.setMaxSimultaneousRequestsPerConnectionThreshold(HostDistance.REMOTE, this.remoteMinSimultaneousRequests.intValue());
            }
            this.poolingOptions.setMinSimultaneousRequestsPerConnectionThreshold(HostDistance.REMOTE, this.remoteMinSimultaneousRequests.intValue());
        }
        if (this.remoteMaxSimultaneousRequests != null) {
            this.poolingOptions.setMaxSimultaneousRequestsPerConnectionThreshold(HostDistance.REMOTE, this.remoteMaxSimultaneousRequests.intValue());
        }
    }

    public PoolingOptions getObject() throws Exception {
        return this.poolingOptions;
    }

    public Class<?> getObjectType() {
        return PoolingOptions.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public Integer getLocalMinSimultaneousRequests() {
        return this.localMinSimultaneousRequests;
    }

    public void setLocalMinSimultaneousRequests(Integer localMinSimultaneousRequests) {
        this.localMinSimultaneousRequests = localMinSimultaneousRequests;
    }

    public Integer getLocalMaxSimultaneousRequests() {
        return this.localMaxSimultaneousRequests;
    }

    public void setLocalMaxSimultaneousRequests(Integer localMaxSimultaneousRequests) {
        this.localMaxSimultaneousRequests = localMaxSimultaneousRequests;
    }

    public Integer getLocalCoreConnections() {
        return this.localCoreConnections;
    }

    public void setLocalCoreConnections(Integer localCoreConnections) {
        this.localCoreConnections = localCoreConnections;
    }

    public Integer getLocalMaxConnections() {
        return this.localMaxConnections;
    }

    public void setLocalMaxConnections(Integer localMaxConnections) {
        this.localMaxConnections = localMaxConnections;
    }

    public Integer getRemoteMinSimultaneousRequests() {
        return this.remoteMinSimultaneousRequests;
    }

    public void setRemoteMinSimultaneousRequests(Integer remoteMinSimultaneousRequests) {
        this.remoteMinSimultaneousRequests = remoteMinSimultaneousRequests;
    }

    public Integer getRemoteMaxSimultaneousRequests() {
        return this.remoteMaxSimultaneousRequests;
    }

    public void setRemoteMaxSimultaneousRequests(Integer remoteMaxSimultaneousRequests) {
        this.remoteMaxSimultaneousRequests = remoteMaxSimultaneousRequests;
    }

    public Integer getRemoteCoreConnections() {
        return this.remoteCoreConnections;
    }

    public void setRemoteCoreConnections(Integer remoteCoreConnections) {
        this.remoteCoreConnections = remoteCoreConnections;
    }

    public Integer getRemoteMaxConnections() {
        return this.remoteMaxConnections;
    }

    public void setRemoteMaxConnections(Integer remoteMaxConnections) {
        this.remoteMaxConnections = remoteMaxConnections;
    }
}

