/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core;

import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public enum ReservedKeyword {
    ADD,
    ALTER,
    AND,
    ANY,
    APPLY,
    ASC,
    AUTHORIZE,
    BATCH,
    BEGIN,
    BY,
    COLUMNFAMILY,
    CREATE,
    DELETE,
    DESC,
    DROP,
    EACH_QUORUM,
    FROM,
    GRANT,
    IN,
    INDEX,
    INSERT,
    INTO,
    KEYSPACE,
    LIMIT,
    LOCAL_ONE,
    LOCAL_QUORUM,
    MODIFY,
    NORECURSIVE,
    OF,
    ON,
    ONE,
    ORDER,
    PRIMARY,
    QUORUM,
    REVOKE,
    SCHEMA,
    SELECT,
    SET,
    TABLE,
    THREE,
    TOKEN,
    TRUNCATE,
    TWO,
    UPDATE,
    USE,
    USING,
    WHERE,
    WITH;


    public static boolean isReserved(CharSequence candidate) {
        Assert.notNull((Object)candidate);
        return ReservedKeyword.isReserved(candidate.toString());
    }

    public static boolean isReserved(String candidate) {
        if (!StringUtils.hasText((String)candidate)) {
            return false;
        }
        try {
            Enum.valueOf(ReservedKeyword.class, candidate.toUpperCase());
            return true;
        }
        catch (IllegalArgumentException x) {
            return false;
        }
    }
}

