/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.jdbchdfs.common;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;

public class NamedColumnJdbcItemReader
extends JdbcCursorItemReader<String> {
    private String delimiter;

    public void afterPropertiesSet() throws Exception {
        this.setRowMapper((RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                StringBuilder builder = new StringBuilder();
                for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                    builder.append(JdbcUtils.getResultSetValue((ResultSet)rs, (int)i, String.class)).append(NamedColumnJdbcItemReader.this.delimiter);
                }
                return builder.substring(0, builder.length() - NamedColumnJdbcItemReader.this.delimiter.length());
            }
        });
        super.afterPropertiesSet();
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

