/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.jdbchdfs.common;

import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.hadoop.conf.Configuration;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.DefaultBatchConfigurer;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.explore.support.JobExplorerFactoryBean;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.listener.ExecutionContextPromotionListener;
import org.springframework.batch.core.partition.PartitionHandler;
import org.springframework.batch.core.partition.support.Partitioner;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.PartitionStepBuilder;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.deployer.resource.maven.MavenResource;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.task.batch.configuration.TaskBatchExecutionListenerFactoryBean;
import org.springframework.cloud.task.batch.partition.DeployerPartitionHandler;
import org.springframework.cloud.task.batch.partition.DeployerStepExecutionHandler;
import org.springframework.cloud.task.batch.partition.EnvironmentVariablesProvider;
import org.springframework.cloud.task.batch.partition.SimpleEnvironmentVariablesProvider;
import org.springframework.cloud.task.configuration.DefaultTaskConfigurer;
import org.springframework.cloud.task.configuration.EnableTask;
import org.springframework.cloud.task.configuration.TaskConfigurer;
import org.springframework.cloud.task.jdbchdfs.common.HdfsTextItemWriter;
import org.springframework.cloud.task.jdbchdfs.common.HdfsTextItemWriterFactory;
import org.springframework.cloud.task.jdbchdfs.common.IncrementalColumnRangePartitioner;
import org.springframework.cloud.task.jdbchdfs.common.JdbcHdfsTaskProperties;
import org.springframework.cloud.task.jdbchdfs.common.NamedColumnJdbcItemReader;
import org.springframework.cloud.task.jdbchdfs.common.NamedColumnJdbcItemReaderFactory;
import org.springframework.cloud.task.jdbchdfs.common.support.JdbcHdfsDataSourceConfiguration;
import org.springframework.cloud.task.repository.support.TaskRepositoryInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;

@EnableTask
@EnableBatchProcessing
@org.springframework.context.annotation.Configuration
@EnableConfigurationProperties(value={JdbcHdfsTaskProperties.class})
@Import(value={JdbcHdfsDataSourceConfiguration.class})
public class JdbcHdfsConfiguration {
    public static final String[] PROMOTION_LISTENER_KEYS = new String[]{"batch.incremental.maxId"};
    @Autowired
    private Configuration hadoopConfiguration;
    @Autowired
    private JdbcHdfsTaskProperties props;
    @Autowired
    public JobBuilderFactory jobBuilderFactory;
    @Autowired
    public StepBuilderFactory stepBuilderFactory;
    @Autowired
    @Qualifier(value="taskDataSource")
    public DataSource taskDataSource;
    @Autowired
    @Qualifier(value="jdbchdfsDataSource")
    public DataSource jdbcHdfsDataSource;
    @Autowired
    public JobRepository jobRepository;
    @Autowired
    private Environment environment;
    @Autowired(required=false)
    private ConfigurableApplicationContext context;
    @Value(value="${jdbc.hdfs.task.resource:org.springframework.cloud.task.app:jdbchdfs-local-task:1.0.2.BUILD-SNAPSHOT}")
    private String taskResource;

    @Bean
    @StepScope
    public NamedColumnJdbcItemReader namedColumnJdbcItemReader(@Value(value="#{stepExecutionContext['partClause']}") String partClause) throws Exception {
        NamedColumnJdbcItemReaderFactory namedColumnJdbcItemReaderFactory = new NamedColumnJdbcItemReaderFactory();
        namedColumnJdbcItemReaderFactory.setDataSource(this.jdbcHdfsDataSource);
        namedColumnJdbcItemReaderFactory.setPartitionClause(partClause);
        namedColumnJdbcItemReaderFactory.setTableName(this.props.getTableName());
        namedColumnJdbcItemReaderFactory.setColumnNames(this.props.getColumnNames());
        namedColumnJdbcItemReaderFactory.setSql(this.props.getSql());
        namedColumnJdbcItemReaderFactory.setFetchSize(this.props.getCommitInterval());
        namedColumnJdbcItemReaderFactory.setDelimiter(this.props.getDelimiter());
        namedColumnJdbcItemReaderFactory.afterPropertiesSet();
        return namedColumnJdbcItemReaderFactory.getObject();
    }

    @Bean
    public JobExplorerFactoryBean jobExplorer() {
        JobExplorerFactoryBean jobExplorerFactoryBean = new JobExplorerFactoryBean();
        jobExplorerFactoryBean.setDataSource(this.taskDataSource);
        return jobExplorerFactoryBean;
    }

    @Bean
    @Profile(value={"!worker"})
    public DeployerPartitionHandler partitionHandler(TaskLauncher taskLauncher, JobExplorer jobExplorer) throws Exception {
        MavenResource resource = MavenResource.parse((String)this.taskResource);
        DeployerPartitionHandler partitionHandler = new DeployerPartitionHandler(taskLauncher, jobExplorer, (Resource)resource, "workerStep");
        HashMap<String, String> environmentProperties = new HashMap<String, String>();
        environmentProperties.put("spring.profiles.active", "worker");
        environmentProperties.put("server.port", "0");
        SimpleEnvironmentVariablesProvider environmentVariablesProvider = new SimpleEnvironmentVariablesProvider(this.environment);
        environmentVariablesProvider.setEnvironmentProperties(environmentProperties);
        partitionHandler.setEnvironmentVariablesProvider((EnvironmentVariablesProvider)environmentVariablesProvider);
        partitionHandler.setMaxWorkers(this.props.getMaxWorkers());
        return partitionHandler;
    }

    @Bean
    @StepScope
    @Profile(value={"!worker"})
    public IncrementalColumnRangePartitioner partitioner(JobExplorer jobExplorer, @Value(value="#{stepExecutionContext['overrideCheckColumnValue']}") Long overrideValue) {
        IncrementalColumnRangePartitioner partitioner = new IncrementalColumnRangePartitioner();
        partitioner.setTable(this.props.getTableName());
        partitioner.setColumn(this.props.getPartitionColumn());
        partitioner.setJobExplorer(jobExplorer);
        partitioner.setCheckColumn(this.props.getCheckColumn());
        partitioner.setOverrideValue(overrideValue);
        partitioner.setDataSource(this.jdbcHdfsDataSource);
        partitioner.setPartitions(this.props.getPartitions());
        return partitioner;
    }

    @Bean
    @Profile(value={"worker"})
    public DeployerStepExecutionHandler stepExecutionHandler(JobExplorer jobExplorer) {
        DeployerStepExecutionHandler handler = new DeployerStepExecutionHandler((BeanFactory)this.context, jobExplorer, this.jobRepository);
        return handler;
    }

    @Bean
    @StepScope
    public HdfsTextItemWriter writer(@Value(value="#{stepExecutionContext['partSuffix']}") String suffix) throws Exception {
        HdfsTextItemWriterFactory factory = new HdfsTextItemWriterFactory(this.hadoopConfiguration, this.props, suffix);
        return factory.getObject();
    }

    @Bean
    public ExecutionContextPromotionListener promotionListener() {
        ExecutionContextPromotionListener executionContextPromotionListener = new ExecutionContextPromotionListener();
        executionContextPromotionListener.setKeys(PROMOTION_LISTENER_KEYS);
        return executionContextPromotionListener;
    }

    @Bean
    @Profile(value={"!worker"})
    public Step step1(PartitionHandler partitionHandler, ExecutionContextPromotionListener promotionListener, IncrementalColumnRangePartitioner partitioner) throws Exception {
        Step worker = this.workerStep();
        Step step1 = ((PartitionStepBuilder)((PartitionStepBuilder)this.stepBuilderFactory.get("step1").partitioner(worker.getName(), (Partitioner)partitioner).step(worker).partitionHandler(partitionHandler).listener((StepExecutionListener)promotionListener)).listener((StepExecutionListener)partitioner)).build();
        return step1;
    }

    @Bean
    public Step workerStep() throws Exception {
        TaskletStep step = this.stepBuilderFactory.get("workerStep").chunk(this.props.getCommitInterval()).reader((ItemReader)this.namedColumnJdbcItemReader(null)).writer((ItemWriter)this.writer(null)).build();
        return step;
    }

    @Bean
    @Profile(value={"!worker"})
    public Job partitionedJob(PartitionHandler partitionHandler, ExecutionContextPromotionListener promotionListener, IncrementalColumnRangePartitioner partitioner) throws Exception {
        String jobName = this.environment.getProperty("spring.cloud.task.name") != null ? this.environment.getProperty("spring.cloud.task.name") : this.context.getId();
        JobBuilder jobBuilder = this.jobBuilderFactory.get(jobName);
        if (!this.props.isRestartable()) {
            jobBuilder.preventRestart();
        }
        return jobBuilder.start(this.step1(partitionHandler, promotionListener, partitioner)).build();
    }

    @Bean
    public DefaultTaskConfigurer taskConfigurer() {
        return new DefaultTaskConfigurer(this.taskDataSource);
    }

    @Bean
    public DefaultBatchConfigurer batchConfigurer() {
        return new DefaultBatchConfigurer(this.taskDataSource);
    }

    @Bean
    public TaskRepositoryInitializer taskRepositoryInitializer() {
        TaskRepositoryInitializer taskRepositoryInitializer = new TaskRepositoryInitializer();
        taskRepositoryInitializer.setDataSource(this.taskDataSource);
        return taskRepositoryInitializer;
    }

    @Bean
    public TaskBatchExecutionListenerFactoryBean taskBatchExecutionListener(TaskConfigurer taskConfigurer) {
        return new TaskBatchExecutionListenerFactoryBean(this.taskDataSource, taskConfigurer.getTaskExplorer());
    }
}

