/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.jdbchdfs.common;

import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.support.DatabaseType;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.task.jdbchdfs.common.NamedColumnJdbcItemReader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class NamedColumnJdbcItemReaderFactory
implements FactoryBean<NamedColumnJdbcItemReader>,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(NamedColumnJdbcItemReaderFactory.class);
    private DataSource dataSource;
    private String tableName;
    private String columnNames;
    private String partitionClause;
    private String sql;
    private int fetchSize;
    private boolean verifyCursorPosition = true;
    private boolean initialized = false;
    private NamedColumnJdbcItemReader reader;
    private String delimiter;

    public NamedColumnJdbcItemReader getObject() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("Properties have not been initalized");
        }
        return this.reader;
    }

    public Class<?> getObjectType() {
        return NamedColumnJdbcItemReader.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (!StringUtils.hasText((String)this.sql)) {
            Assert.hasText((String)this.tableName, (String)"tableName must be set");
            Assert.hasText((String)this.columnNames, (String)"columns must be set");
            String sql = StringUtils.hasText((String)this.partitionClause) ? "SELECT " + this.columnNames + " FROM " + this.tableName + " " + this.partitionClause : "SELECT " + this.columnNames + " FROM " + this.tableName;
            log.info("Setting SQL to: " + sql);
            this.setSql(sql);
        } else if (StringUtils.hasText((String)this.columnNames) || StringUtils.hasText((String)this.tableName)) {
            log.warn("You must set either the 'sql' property or 'tableName' and 'columns'.");
        }
        DatabaseType type = DatabaseType.fromMetaData((DataSource)this.dataSource);
        switch (type) {
            case MYSQL: {
                this.fetchSize = Integer.MIN_VALUE;
                this.verifyCursorPosition = false;
                break;
            }
            case SQLITE: {
                this.fetchSize = -1;
                break;
            }
        }
        this.reader = new NamedColumnJdbcItemReader();
        this.reader.setSql(this.sql);
        this.reader.setFetchSize(this.fetchSize);
        this.reader.setDataSource(this.dataSource);
        this.reader.setVerifyCursorPosition(this.verifyCursorPosition);
        this.reader.setDelimiter(this.delimiter);
        this.reader.afterPropertiesSet();
        this.initialized = true;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setColumnNames(String columnNames) {
        this.columnNames = columnNames;
    }

    public void setPartitionClause(String partitionClause) {
        this.partitionClause = partitionClause;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setVerifyCursorPosition(boolean verify) {
        this.verifyCursorPosition = verify;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

