/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.app.timestamp;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.task.app.timestamp.TimestampTaskProperties;
import org.springframework.cloud.task.configuration.EnableTask;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableTask
@Configuration
@EnableConfigurationProperties(value={TimestampTaskProperties.class})
public class TimestampTaskConfiguration {
    @Bean
    public TimestampTask timeStampTask() {
        return new TimestampTask();
    }

    public class TimestampTask
    implements CommandLineRunner {
        private final Log logger = LogFactory.getLog(TimestampTask.class);
        @Autowired
        private TimestampTaskProperties config;

        public void run(String ... strings) throws Exception {
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.config.getFormat());
            this.logger.info((Object)dateFormat.format(new Date()));
        }
    }
}

