/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.app.spark.yarn;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.Client;
import org.apache.spark.deploy.yarn.ClientArguments;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.task.app.spark.yarn.SparkYarnTaskProperties;
import org.springframework.cloud.task.configuration.EnableTask;
import org.springframework.cloud.task.sparkapp.common.SparkAppCommonTaskProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@EnableTask
@Configuration
@EnableConfigurationProperties(value={SparkYarnTaskProperties.class, SparkAppCommonTaskProperties.class})
public class SparkYarnTaskConfiguration {
    @Bean
    public CommandLineRunner commandLineRunner() {
        return new SparkAppYarnRunner();
    }

    private class SparkAppYarnRunner
    implements CommandLineRunner {
        private final Log logger = LogFactory.getLog(SparkAppYarnRunner.class);
        @Autowired
        private org.apache.hadoop.conf.Configuration hadoopConfiguration;
        @Autowired
        private SparkYarnTaskProperties config;
        @Autowired
        private SparkAppCommonTaskProperties commonConfig;

        private SparkAppYarnRunner() {
        }

        public void run(String ... args) throws Exception {
            SparkConf sparkConf = new SparkConf();
            sparkConf.set("spark.yarn.jar", this.config.getAssemblyJar());
            ArrayList<String> submitArgs = new ArrayList<String>();
            if (StringUtils.hasText((String)this.commonConfig.getAppName())) {
                submitArgs.add("--name");
                submitArgs.add(this.commonConfig.getAppName());
            }
            submitArgs.add("--jar");
            submitArgs.add(this.commonConfig.getAppJar());
            submitArgs.add("--class");
            submitArgs.add(this.commonConfig.getAppClass());
            if (StringUtils.hasText((String)this.commonConfig.getResourceFiles())) {
                submitArgs.add("--files");
                submitArgs.add(this.commonConfig.getResourceFiles());
            }
            if (StringUtils.hasText((String)this.commonConfig.getResourceArchives())) {
                submitArgs.add("--archives");
                submitArgs.add(this.commonConfig.getResourceArchives());
            }
            submitArgs.add("--executor-memory");
            submitArgs.add(this.commonConfig.getExecutorMemory());
            submitArgs.add("--num-executors");
            submitArgs.add("" + this.config.getNumExecutors());
            for (String arg : this.commonConfig.getAppArgs()) {
                submitArgs.add("--arg");
                submitArgs.add(arg);
            }
            this.logger.info((Object)("Submit App with args: " + Arrays.asList(submitArgs)));
            ClientArguments clientArguments = new ClientArguments(submitArgs.toArray(new String[submitArgs.size()]), sparkConf);
            clientArguments.isClusterMode();
            Client client = new Client(clientArguments, this.hadoopConfiguration, sparkConf);
            System.setProperty("SPARK_YARN_MODE", "true");
            try {
                client.run();
            }
            catch (Throwable t) {
                this.logger.error((Object)("Spark Application failed: " + t.getMessage()), t);
                throw new RuntimeException("Spark Application failed", t);
            }
        }
    }
}

