/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.app.composedtaskrunner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.step.builder.AbstractTaskletStepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.dataflow.rest.client.TaskOperations;
import org.springframework.cloud.task.app.composedtaskrunner.TaskLauncherTasklet;
import org.springframework.cloud.task.app.composedtaskrunner.properties.ComposedTaskProperties;
import org.springframework.cloud.task.configuration.TaskConfigurer;
import org.springframework.cloud.task.configuration.TaskProperties;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.Assert;

public class ComposedTaskRunnerStepFactory
implements FactoryBean<Step> {
    private ComposedTaskProperties composedTaskProperties;
    private String taskName;
    private Map<String, String> taskSpecificProps = new HashMap<String, String>();
    private List<String> arguments = new ArrayList<String>();
    @Autowired
    private StepBuilderFactory steps;
    @Autowired
    private StepExecutionListener composedTaskStepExecutionListener;
    @Autowired
    private TaskOperations taskOperations;
    @Autowired
    private TaskConfigurer taskConfigurer;
    @Autowired
    private TaskProperties taskProperties;

    public ComposedTaskRunnerStepFactory(ComposedTaskProperties composedTaskProperties, String taskName) {
        Assert.notNull((Object)composedTaskProperties, (String)"composedTaskProperties must not be null");
        Assert.hasText((String)taskName, (String)"taskName must not be empty nor null");
        this.composedTaskProperties = composedTaskProperties;
        this.taskName = taskName;
    }

    public void setTaskSpecificProps(Map<String, String> taskSpecificProps) {
        if (taskSpecificProps != null) {
            this.taskSpecificProps = taskSpecificProps;
        }
    }

    public void setArguments(List<String> arguments) {
        if (arguments != null) {
            this.arguments = arguments;
        }
    }

    public Step getObject() throws Exception {
        TaskLauncherTasklet taskLauncherTasklet = new TaskLauncherTasklet(this.taskOperations, this.taskConfigurer.getTaskExplorer(), this.composedTaskProperties, this.taskName, this.taskProperties);
        taskLauncherTasklet.setArguments(this.arguments);
        taskLauncherTasklet.setProperties(this.taskSpecificProps);
        String stepName = this.taskName;
        return ((AbstractTaskletStepBuilder)this.steps.get(stepName).tasklet((Tasklet)taskLauncherTasklet).transactionAttribute(this.getTransactionAttribute()).listener(this.composedTaskStepExecutionListener)).build();
    }

    private TransactionAttribute getTransactionAttribute() {
        DefaultTransactionAttribute defaultTransactionAttribute = new DefaultTransactionAttribute();
        defaultTransactionAttribute.setIsolationLevel(Isolation.READ_COMMITTED.value());
        return defaultTransactionAttribute;
    }

    public Class<?> getObjectType() {
        return Step.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

