/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.app.composedtaskrunner;

import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.common.security.support.OAuth2AccessTokenProvidingClientHttpRequestInterceptor;
import org.springframework.cloud.dataflow.rest.client.DataFlowOperations;
import org.springframework.cloud.dataflow.rest.client.DataFlowTemplate;
import org.springframework.cloud.dataflow.rest.client.TaskOperations;
import org.springframework.cloud.dataflow.rest.util.HttpClientConfigurer;
import org.springframework.cloud.task.app.composedtaskrunner.properties.ComposedTaskProperties;
import org.springframework.cloud.task.app.composedtaskrunner.support.OnOAuth2ClientCredentialsEnabled;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.endpoint.DefaultClientCredentialsTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={ComposedTaskProperties.class})
public class DataFlowConfiguration {
    private static Log logger = LogFactory.getLog(DataFlowConfiguration.class);
    @Autowired
    private ComposedTaskProperties properties;

    @Bean
    public TaskOperations taskOperations(DataFlowOperations dataFlowOperations) {
        return dataFlowOperations.taskOperations();
    }

    @Bean
    public DataFlowOperations dataFlowOperations(@Autowired(required=false) ClientRegistrationRepository clientRegistrations, @Autowired(required=false) OAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient) {
        RestTemplate restTemplate = DataFlowTemplate.getDefaultDataflowRestTemplate();
        this.validateUsernamePassword(this.properties.getDataflowServerUsername(), this.properties.getDataflowServerPassword());
        HttpClientConfigurer clientHttpRequestFactoryBuilder = null;
        if (this.properties.getOauth2ClientCredentialsClientId() != null || StringUtils.hasText((String)this.properties.getDataflowServerAccessToken()) || StringUtils.hasText((String)this.properties.getDataflowServerUsername()) && StringUtils.hasText((String)this.properties.getDataflowServerPassword())) {
            clientHttpRequestFactoryBuilder = HttpClientConfigurer.create((URI)this.properties.getDataflowServerUri());
        }
        String accessTokenValue = null;
        if (this.properties.getOauth2ClientCredentialsClientId() != null) {
            ClientRegistration clientRegistration = clientRegistrations.findByRegistrationId("default");
            OAuth2ClientCredentialsGrantRequest grantRequest = new OAuth2ClientCredentialsGrantRequest(clientRegistration);
            OAuth2AccessTokenResponse res = clientCredentialsTokenResponseClient.getTokenResponse((AbstractOAuth2AuthorizationGrantRequest)grantRequest);
            accessTokenValue = res.getAccessToken().getTokenValue();
            logger.debug((Object)"Configured OAuth2 Client Credentials for accessing the Data Flow Server");
        } else if (StringUtils.hasText((String)this.properties.getDataflowServerAccessToken())) {
            accessTokenValue = this.properties.getDataflowServerAccessToken();
            logger.debug((Object)"Configured OAuth2 Access Token for accessing the Data Flow Server");
        } else if (StringUtils.hasText((String)this.properties.getDataflowServerUsername()) && StringUtils.hasText((String)this.properties.getDataflowServerPassword())) {
            accessTokenValue = null;
            clientHttpRequestFactoryBuilder.basicAuthCredentials(this.properties.getDataflowServerUsername(), this.properties.getDataflowServerPassword());
            logger.debug((Object)"Configured basic security for accessing the Data Flow Server");
        } else {
            logger.debug((Object)"Not configuring basic security for accessing the Data Flow Server");
        }
        if (accessTokenValue != null) {
            restTemplate.getInterceptors().add(new OAuth2AccessTokenProvidingClientHttpRequestInterceptor(accessTokenValue));
        }
        if (clientHttpRequestFactoryBuilder != null) {
            restTemplate.setRequestFactory(clientHttpRequestFactoryBuilder.buildClientHttpRequestFactory());
        }
        return new DataFlowTemplate(this.properties.getDataflowServerUri(), restTemplate);
    }

    private void validateUsernamePassword(String userName, String password) {
        if (!StringUtils.isEmpty((Object)password) && StringUtils.isEmpty((Object)userName)) {
            throw new IllegalArgumentException("A password may be specified only together with a username");
        }
        if (StringUtils.isEmpty((Object)password) && !StringUtils.isEmpty((Object)userName)) {
            throw new IllegalArgumentException("A username may be specified only together with a password");
        }
    }

    @Configuration
    @Conditional(value={OnOAuth2ClientCredentialsEnabled.class})
    static class clientCredentialsConfiguration {
        clientCredentialsConfiguration() {
        }

        @Bean
        public InMemoryClientRegistrationRepository clientRegistrationRepository(ComposedTaskProperties properties) {
            ClientRegistration clientRegistration = ClientRegistration.withRegistrationId((String)"default").authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).tokenUri(properties.getOauth2ClientCredentialsTokenUri()).clientId(properties.getOauth2ClientCredentialsClientId()).clientSecret(properties.getOauth2ClientCredentialsClientSecret()).scope(properties.getOauth2ClientCredentialsScopes()).build();
            return new InMemoryClientRegistrationRepository(new ClientRegistration[]{clientRegistration});
        }

        @Bean
        OAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient() {
            return new DefaultClientCredentialsTokenResponseClient();
        }
    }
}

