/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.app.composedtaskrunner;

import java.util.Deque;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.dataflow.core.dsl.FlowNode;
import org.springframework.cloud.dataflow.core.dsl.LabelledTaskNode;
import org.springframework.cloud.dataflow.core.dsl.SplitNode;
import org.springframework.cloud.dataflow.core.dsl.TaskAppNode;
import org.springframework.cloud.dataflow.core.dsl.TaskVisitor;

public class ComposedRunnerVisitor
extends TaskVisitor {
    private Deque<LabelledTaskNode> flowDeque = new LinkedList<LabelledTaskNode>();
    private static final Log logger = LogFactory.getLog(ComposedRunnerVisitor.class);

    public boolean preVisit(FlowNode flow) {
        logger.debug((Object)("Pre Visit Flow:  " + flow));
        this.flowDeque.push((LabelledTaskNode)flow);
        return true;
    }

    public void visit(SplitNode split) {
        logger.debug((Object)("Visit Split:  " + split));
        this.flowDeque.push((LabelledTaskNode)split);
    }

    public void postVisit(SplitNode split) {
        logger.debug((Object)("Post Visit Split:  " + split));
        this.flowDeque.push((LabelledTaskNode)split);
    }

    public void visit(TaskAppNode taskApp) {
        logger.debug((Object)("Visit taskApp:  " + taskApp));
        this.flowDeque.push((LabelledTaskNode)taskApp);
    }

    public Deque<LabelledTaskNode> getFlow() {
        return this.flowDeque;
    }
}

