/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.app.composedtaskrunner;

import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.common.security.support.OAuth2AccessTokenProvidingClientHttpRequestInterceptor;
import org.springframework.cloud.dataflow.rest.client.DataFlowOperations;
import org.springframework.cloud.dataflow.rest.client.DataFlowTemplate;
import org.springframework.cloud.dataflow.rest.client.TaskOperations;
import org.springframework.cloud.dataflow.rest.util.HttpClientConfigurer;
import org.springframework.cloud.task.app.composedtaskrunner.properties.ComposedTaskProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={ComposedTaskProperties.class})
public class DataFlowConfiguration {
    private static Log logger = LogFactory.getLog(DataFlowConfiguration.class);
    @Autowired
    private ComposedTaskProperties properties;

    @Bean
    public TaskOperations taskOperations(DataFlowOperations dataFlowOperations) {
        return dataFlowOperations.taskOperations();
    }

    @Bean
    public DataFlowOperations dataFlowOperations() {
        RestTemplate restTemplate = DataFlowTemplate.getDefaultDataflowRestTemplate();
        this.validateUsernamePassword(this.properties.getDataflowServerUsername(), this.properties.getDataflowServerPassword());
        if (StringUtils.hasText((String)this.properties.getDataflowServerAccessToken())) {
            restTemplate.setRequestFactory(HttpClientConfigurer.create((URI)this.properties.getDataflowServerUri()).buildClientHttpRequestFactory());
            restTemplate.getInterceptors().add(new OAuth2AccessTokenProvidingClientHttpRequestInterceptor(this.properties.getDataflowServerAccessToken()));
            logger.debug((Object)"Configured OAuth2 Access Token for accessing the Data Flow Server");
        } else if (StringUtils.hasText((String)this.properties.getDataflowServerUsername()) && StringUtils.hasText((String)this.properties.getDataflowServerPassword())) {
            restTemplate.setRequestFactory(HttpClientConfigurer.create((URI)this.properties.getDataflowServerUri()).basicAuthCredentials(this.properties.getDataflowServerUsername(), this.properties.getDataflowServerPassword()).buildClientHttpRequestFactory());
            logger.debug((Object)"Configured basic security for accessing the Data Flow Server");
        } else {
            logger.debug((Object)"Not configuring basic security for accessing the Data Flow Server");
        }
        return new DataFlowTemplate(this.properties.getDataflowServerUri(), restTemplate);
    }

    private void validateUsernamePassword(String userName, String password) {
        if (!StringUtils.isEmpty((Object)password) && StringUtils.isEmpty((Object)userName)) {
            throw new IllegalArgumentException("A password may be specified only together with a username");
        }
        if (StringUtils.isEmpty((Object)password) && !StringUtils.isEmpty((Object)userName)) {
            throw new IllegalArgumentException("A username may be specified only together with a password");
        }
    }
}

