/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.app.composedtaskrunner;

import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.job.builder.FlowBuilder;
import org.springframework.batch.core.job.builder.FlowJobBuilder;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.dataflow.core.dsl.FlowNode;
import org.springframework.cloud.dataflow.core.dsl.LabelledTaskNode;
import org.springframework.cloud.dataflow.core.dsl.SplitNode;
import org.springframework.cloud.dataflow.core.dsl.TaskAppNode;
import org.springframework.cloud.dataflow.core.dsl.TaskParser;
import org.springframework.cloud.dataflow.core.dsl.TaskVisitor;
import org.springframework.cloud.dataflow.core.dsl.TransitionNode;
import org.springframework.cloud.task.app.composedtaskrunner.ComposedRunnerVisitor;
import org.springframework.cloud.task.app.composedtaskrunner.properties.ComposedTaskProperties;
import org.springframework.cloud.task.repository.TaskNameResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;

public class ComposedRunnerJobFactory
implements FactoryBean<Job> {
    private static final String WILD_CARD = "*";
    @Autowired
    private ApplicationContext context;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    private TaskNameResolver taskNameResolver;
    private final ComposedTaskProperties composedTaskProperties;
    private FlowBuilder<Flow> flowBuilder;
    private Map<String, Integer> taskBeanSuffixes = new HashMap<String, Integer>();
    private Deque<Flow> jobDeque = new LinkedList<Flow>();
    private Deque<LabelledTaskNode> visitorDeque;
    private Deque<Flow> executionDeque = new LinkedList<Flow>();
    private String dsl;
    private boolean incrementInstanceEnabled;
    private int splitFlows = 1;
    private boolean hasNestedSplit = false;

    public ComposedRunnerJobFactory(ComposedTaskProperties properties) {
        this.composedTaskProperties = properties;
        Assert.notNull((Object)properties.getGraph(), (String)"The DSL must not be null");
        this.dsl = properties.getGraph();
        this.incrementInstanceEnabled = properties.isIncrementInstanceEnabled();
        this.flowBuilder = new FlowBuilder(UUID.randomUUID().toString());
    }

    public Job getObject() throws Exception {
        ComposedRunnerVisitor composedRunnerVisitor = new ComposedRunnerVisitor();
        TaskParser taskParser = new TaskParser("composed-task-runner", this.dsl, false, true);
        taskParser.parse().accept((TaskVisitor)composedRunnerVisitor);
        this.visitorDeque = composedRunnerVisitor.getFlow();
        FlowJobBuilder builder = (FlowJobBuilder)this.jobBuilderFactory.get(this.taskNameResolver.getTaskName()).start((Flow)this.flowBuilder.start(this.createFlow()).end()).end();
        if (this.incrementInstanceEnabled) {
            builder.incrementer((JobParametersIncrementer)new RunIdIncrementer());
        }
        return builder.build();
    }

    public Class<?> getObjectType() {
        return Job.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private Flow createFlow() {
        while (!this.visitorDeque.isEmpty()) {
            if (this.visitorDeque.peek() instanceof TaskAppNode) {
                TaskAppNode taskAppNode = (TaskAppNode)this.visitorDeque.pop();
                if (taskAppNode.hasTransitions()) {
                    this.handleTransition(this.executionDeque, taskAppNode);
                    continue;
                }
                this.executionDeque.push(this.getTaskAppFlow(taskAppNode));
                continue;
            }
            if (this.visitorDeque.peek() instanceof SplitNode) {
                LinkedList<LabelledTaskNode> splitNodeDeque = new LinkedList<LabelledTaskNode>();
                SplitNode splitNode = (SplitNode)this.visitorDeque.pop();
                splitNodeDeque.push((LabelledTaskNode)splitNode);
                while (!this.visitorDeque.isEmpty() && !this.visitorDeque.peek().equals(splitNode)) {
                    splitNodeDeque.push(this.visitorDeque.pop());
                }
                splitNodeDeque.push(this.visitorDeque.pop());
                this.handleSplit(splitNodeDeque, splitNode);
                continue;
            }
            if (!(this.visitorDeque.peek() instanceof FlowNode)) continue;
            this.handleFlow(this.executionDeque);
        }
        return this.jobDeque.pop();
    }

    private void handleFlow(Deque<Flow> executionDeque) {
        if (!executionDeque.isEmpty()) {
            this.flowBuilder.start(executionDeque.pop());
        }
        while (!executionDeque.isEmpty()) {
            this.flowBuilder.next(executionDeque.pop());
        }
        this.visitorDeque.pop();
        this.jobDeque.push((Flow)this.flowBuilder.end());
    }

    private void handleSplit(Deque<LabelledTaskNode> visitorDeque, SplitNode splitNode) {
        this.executionDeque.push(this.processSplitNode(visitorDeque, splitNode));
    }

    private Flow processSplitNode(Deque<LabelledTaskNode> visitorDeque, SplitNode splitNode) {
        LinkedList<Flow> flows = new LinkedList<Flow>();
        for (LabelledTaskNode taskNode : splitNode.getSeries()) {
            LinkedList<Flow> resultFlowDeque = new LinkedList<Flow>();
            flows.addAll(this.processSplitFlow(taskNode, resultFlowDeque));
        }
        this.removeProcessedNodes(visitorDeque, splitNode);
        Flow nestedSplitFlow = (Flow)new FlowBuilder.SplitBuilder(new FlowBuilder("Split" + UUID.randomUUID().toString()), this.taskExecutor).add(flows.toArray(new Flow[flows.size()])).build();
        FlowBuilder taskAppFlowBuilder = new FlowBuilder("Flow" + UUID.randomUUID().toString());
        if (this.hasNestedSplit) {
            this.splitFlows = flows.size();
            int threadCorePoolSize = this.composedTaskProperties.getSplitThreadCorePoolSize();
            Assert.isTrue((threadCorePoolSize >= this.splitFlows ? 1 : 0) != 0, (String)("Split thread core pool size " + threadCorePoolSize + " should be equal or greater than the depth of split flows " + (this.splitFlows + 1) + ". Try setting the composed task property `splitThreadCorePoolSize`"));
        }
        return (Flow)taskAppFlowBuilder.start(nestedSplitFlow).end();
    }

    private void removeProcessedNodes(Deque<LabelledTaskNode> visitorDeque, SplitNode splitNode) {
        while (visitorDeque.peek() != null && !visitorDeque.peek().equals(splitNode)) {
            visitorDeque.pop();
        }
        if (visitorDeque.peek() != null) {
            visitorDeque.pop();
        }
    }

    private Deque<Flow> processSplitFlow(LabelledTaskNode node, Deque<Flow> resultFlowDeque) {
        TaskParser taskParser = new TaskParser("split_flow" + UUID.randomUUID().toString(), node.stringify(), false, true);
        ComposedRunnerVisitor splitElementVisitor = new ComposedRunnerVisitor();
        taskParser.parse().accept((TaskVisitor)splitElementVisitor);
        Deque<LabelledTaskNode> splitElementDeque = splitElementVisitor.getFlow();
        LinkedList<Flow> elementFlowDeque = new LinkedList<Flow>();
        while (!splitElementDeque.isEmpty()) {
            if (splitElementDeque.peek() instanceof TaskAppNode) {
                TaskAppNode taskAppNode = (TaskAppNode)splitElementDeque.pop();
                if (taskAppNode.hasTransitions()) {
                    this.handleTransition(elementFlowDeque, taskAppNode);
                    continue;
                }
                elementFlowDeque.push(this.getTaskAppFlow(taskAppNode));
                continue;
            }
            if (splitElementDeque.peek() instanceof FlowNode) {
                resultFlowDeque.push(this.handleFlowForSegment(elementFlowDeque));
                splitElementDeque.pop();
                continue;
            }
            if (!(splitElementDeque.peek() instanceof SplitNode)) continue;
            this.hasNestedSplit = true;
            LinkedList<LabelledTaskNode> splitNodeDeque = new LinkedList<LabelledTaskNode>();
            SplitNode splitNode = (SplitNode)splitElementDeque.pop();
            splitNodeDeque.push((LabelledTaskNode)splitNode);
            while (!splitElementDeque.isEmpty() && !splitElementDeque.peek().equals(splitNode)) {
                splitNodeDeque.push(splitElementDeque.pop());
            }
            splitNodeDeque.push(splitElementDeque.pop());
            elementFlowDeque.push(this.processSplitNode(splitNodeDeque, splitNode));
        }
        return resultFlowDeque;
    }

    private Flow handleFlowForSegment(Deque<Flow> resultFlowDeque) {
        FlowBuilder localTaskAppFlowBuilder = new FlowBuilder("Flow" + UUID.randomUUID().toString());
        if (!resultFlowDeque.isEmpty()) {
            localTaskAppFlowBuilder.start(resultFlowDeque.pop());
        }
        while (!resultFlowDeque.isEmpty()) {
            localTaskAppFlowBuilder.next(resultFlowDeque.pop());
        }
        return (Flow)localTaskAppFlowBuilder.end();
    }

    private void handleTransition(Deque<Flow> resultFlowDeque, TaskAppNode taskAppNode) {
        String beanName = this.getBeanName(taskAppNode);
        Step currentStep = (Step)this.context.getBean(beanName, Step.class);
        FlowBuilder builder = new FlowBuilder(beanName).from(currentStep);
        boolean wildCardPresent = false;
        for (TransitionNode transitionNode : taskAppNode.getTransitions()) {
            String transitionBeanName = this.getBeanName(transitionNode);
            wildCardPresent = transitionNode.getStatusToCheck().equals(WILD_CARD);
            Step transitionStep = (Step)this.context.getBean(transitionBeanName, Step.class);
            builder.on(transitionNode.getStatusToCheck()).to(transitionStep).from(currentStep);
        }
        if (wildCardPresent && !resultFlowDeque.isEmpty()) {
            throw new IllegalStateException("Invalid flow following '*' specifier.");
        }
        if (!resultFlowDeque.isEmpty()) {
            builder.on(WILD_CARD).to(this.handleFlowForSegment(resultFlowDeque)).from(currentStep);
        }
        resultFlowDeque.push((Flow)builder.end());
    }

    private String getBeanName(TransitionNode transition) {
        if (transition.getTargetLabel() != null) {
            return transition.getTargetLabel();
        }
        return this.getBeanName(transition.getTargetApp());
    }

    private String getBeanName(TaskAppNode taskApp) {
        if (taskApp.getLabel() != null) {
            return taskApp.getLabel().stringValue();
        }
        String taskName = taskApp.getName();
        if (taskName.contains("->")) {
            taskName = taskName.substring(taskName.indexOf("->") + 2);
        }
        return this.getBeanName(taskName);
    }

    private String getBeanName(String taskName) {
        int taskSuffix = 0;
        if (this.taskBeanSuffixes.containsKey(taskName)) {
            taskSuffix = this.taskBeanSuffixes.get(taskName);
        }
        String result = String.format("%s_%s", taskName, taskSuffix++);
        this.taskBeanSuffixes.put(taskName, taskSuffix);
        return result;
    }

    private Flow getTaskAppFlow(TaskAppNode taskApp) {
        String beanName = this.getBeanName(taskApp);
        Step currentStep = (Step)this.context.getBean(beanName, Step.class);
        return (Flow)new FlowBuilder(beanName).from(currentStep).end();
    }
}

