/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.app.composedtaskrunner;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cloud.dataflow.core.dsl.TaskAppNode;
import org.springframework.cloud.dataflow.core.dsl.TaskParser;
import org.springframework.cloud.dataflow.core.dsl.TaskVisitor;
import org.springframework.cloud.dataflow.core.dsl.TransitionNode;
import org.springframework.cloud.dataflow.rest.util.DeploymentPropertiesUtils;
import org.springframework.cloud.task.app.composedtaskrunner.ComposedTaskRunnerStepFactory;
import org.springframework.cloud.task.app.composedtaskrunner.properties.ComposedTaskProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public class StepBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private Environment env;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        ComposedTaskProperties properties = this.composedTaskProperties();
        TaskParser taskParser = new TaskParser("bean-registration", properties.getGraph(), false, true);
        Map<String, Integer> taskSuffixMap = this.getTaskApps(taskParser);
        for (String taskName : taskSuffixMap.keySet()) {
            for (int taskSuffix = 0; taskSuffixMap.get(taskName) >= taskSuffix; ++taskSuffix) {
                BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ComposedTaskRunnerStepFactory.class);
                builder.addConstructorArgValue((Object)properties);
                builder.addConstructorArgValue((Object)String.format("%s_%s", taskName, taskSuffix));
                builder.addPropertyValue("taskSpecificProps", this.getPropertiesForTask(taskName, properties));
                builder.addPropertyValue("arguments", (Object)properties.getComposedTaskArguments());
                registry.registerBeanDefinition(String.format("%s_%s", taskName, taskSuffix), (BeanDefinition)builder.getBeanDefinition());
            }
        }
    }

    private Map<String, String> getPropertiesForTask(String taskName, ComposedTaskProperties properties) {
        Map taskDeploymentProperties = DeploymentPropertiesUtils.parse((String)properties.getComposedTaskProperties());
        HashMap<String, String> deploymentProperties = new HashMap<String, String>();
        this.updateDeploymentProperties(String.format("app.%s.", taskName), taskDeploymentProperties, deploymentProperties);
        this.updateDeploymentProperties(String.format("deployer.%s.", taskName), taskDeploymentProperties, deploymentProperties);
        return deploymentProperties;
    }

    private void updateDeploymentProperties(String prefix, Map<String, String> taskDeploymentProperties, Map<String, String> deploymentProperties) {
        for (Map.Entry<String, String> entry : taskDeploymentProperties.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            deploymentProperties.put(entry.getKey().substring(prefix.length()), entry.getValue());
        }
    }

    public void setEnvironment(Environment environment) {
        this.env = environment;
    }

    private ComposedTaskProperties composedTaskProperties() {
        ComposedTaskProperties properties = new ComposedTaskProperties();
        String dataFlowUriString = this.env.getProperty("dataflow-server-uri");
        String maxWaitTime = this.env.getProperty("max-wait-time");
        String intervalTimeBetweenChecks = this.env.getProperty("interval-time-between-checks");
        properties.setGraph(this.env.getProperty("graph"));
        properties.setComposedTaskArguments(this.env.getProperty("composed-task-arguments"));
        properties.setComposedTaskProperties(this.env.getProperty("composed-task-properties"));
        if (maxWaitTime != null) {
            properties.setMaxWaitTime(Integer.valueOf(maxWaitTime));
        }
        if (intervalTimeBetweenChecks != null) {
            properties.setIntervalTimeBetweenChecks(Integer.valueOf(intervalTimeBetweenChecks));
        }
        if (dataFlowUriString != null) {
            try {
                properties.setDataflowServerUri(new URI(dataFlowUriString));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid Data Flow URI");
            }
        }
        return properties;
    }

    private Map<String, Integer> getTaskApps(TaskParser taskParser) {
        TaskAppsMapCollector collector = new TaskAppsMapCollector();
        taskParser.parse().accept((TaskVisitor)collector);
        return collector.getTaskApps();
    }

    static class TaskAppsMapCollector
    extends TaskVisitor {
        Map<String, Integer> taskApps = new HashMap<String, Integer>();

        TaskAppsMapCollector() {
        }

        public void visit(TaskAppNode taskApp) {
            if (this.taskApps.containsKey(taskApp.getName())) {
                Integer updatedCount = this.taskApps.get(taskApp.getName()) + 1;
                this.taskApps.put(taskApp.getName(), updatedCount);
            } else {
                this.taskApps.put(taskApp.getName(), 0);
            }
        }

        public void visit(TransitionNode transition) {
            if (transition.isTargetApp()) {
                if (this.taskApps.containsKey(transition.getTargetApp())) {
                    Integer updatedCount = this.taskApps.get(transition.getTargetApp()) + 1;
                    this.taskApps.put(transition.getTargetApp().getName(), updatedCount);
                } else {
                    this.taskApps.put(transition.getTargetApp().getName(), 0);
                }
            }
        }

        public Map<String, Integer> getTaskApps() {
            return this.taskApps;
        }
    }
}

