/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.app.composedtaskrunner;

import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.task.app.composedtaskrunner.ComposedRunnerJobFactory;
import org.springframework.cloud.task.app.composedtaskrunner.ComposedTaskStepExecutionListener;
import org.springframework.cloud.task.app.composedtaskrunner.StepBeanDefinitionRegistrar;
import org.springframework.cloud.task.app.composedtaskrunner.properties.ComposedTaskProperties;
import org.springframework.cloud.task.configuration.EnableTask;
import org.springframework.cloud.task.configuration.TaskConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableBatchProcessing
@EnableTask
@EnableConfigurationProperties(value={ComposedTaskProperties.class})
@Import(value={StepBeanDefinitionRegistrar.class})
public class ComposedTaskRunnerConfiguration {
    @Autowired
    private ComposedTaskProperties properties;

    @Bean
    public StepExecutionListener composedTaskStepExecutionListener(TaskConfigurer taskConfigurer) {
        return new ComposedTaskStepExecutionListener(taskConfigurer.getTaskExplorer());
    }

    @Bean
    public ComposedRunnerJobFactory composedTaskJob() {
        return new ComposedRunnerJobFactory(this.properties);
    }

    @Bean
    public TaskExecutor taskExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(this.properties.getSplitThreadCorePoolSize());
        taskExecutor.setMaxPoolSize(this.properties.getSplitThreadMaxPoolSize());
        taskExecutor.setKeepAliveSeconds(this.properties.getSplitThreadKeepAliveSeconds());
        taskExecutor.setAllowCoreThreadTimeOut(this.properties.isSplitThreadAllowCoreThreadTimeout());
        taskExecutor.setQueueCapacity(this.properties.getSplitThreadQueueCapacity());
        taskExecutor.setWaitForTasksToCompleteOnShutdown(this.properties.isSplitThreadWaitForTasksToCompleteOnShutdown());
        return taskExecutor;
    }
}

