/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.app.composedtaskrunner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.cloud.dataflow.rest.client.TaskOperations;
import org.springframework.cloud.task.app.composedtaskrunner.properties.ComposedTaskProperties;
import org.springframework.cloud.task.app.composedtaskrunner.support.TaskExecutionTimeoutException;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.cloud.task.repository.TaskExplorer;
import org.springframework.util.Assert;

public class TaskLauncherTasklet
implements Tasklet {
    private ComposedTaskProperties composedTaskProperties;
    private TaskExplorer taskExplorer;
    private TaskOperations taskOperations;
    private Map<String, String> properties;
    private List<String> arguments;
    private String taskName;
    private static final Log logger = LogFactory.getLog(TaskLauncherTasklet.class);

    public TaskLauncherTasklet(TaskOperations taskOperations, TaskExplorer taskExplorer, ComposedTaskProperties composedTaskProperties, String taskName) {
        Assert.hasText((String)taskName, (String)"taskName must not be empty nor null.");
        Assert.notNull((Object)taskOperations, (String)"taskOperations must not be null.");
        Assert.notNull((Object)taskExplorer, (String)"taskExplorer must not be null.");
        Assert.notNull((Object)composedTaskProperties, (String)"composedTaskProperties must not be null");
        this.taskName = taskName;
        this.taskOperations = taskOperations;
        this.taskExplorer = taskExplorer;
        this.composedTaskProperties = composedTaskProperties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties != null ? properties : new HashMap<String, String>(0);
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments != null ? arguments : new ArrayList<String>(0);
    }

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        String tmpTaskName = this.taskName.substring(0, this.taskName.lastIndexOf(95));
        List args = this.arguments;
        ExecutionContext stepExecutionContext = chunkContext.getStepContext().getStepExecution().getExecutionContext();
        if (stepExecutionContext.containsKey("task-arguments")) {
            args = (List)stepExecutionContext.get("task-arguments");
        }
        long executionId = this.taskOperations.launch(tmpTaskName, this.properties, args);
        stepExecutionContext.put("task-execution-id", (Object)executionId);
        stepExecutionContext.put("task-arguments", (Object)args);
        this.waitForTaskToComplete(executionId);
        return RepeatStatus.FINISHED;
    }

    private void waitForTaskToComplete(long taskExecutionId) {
        block4: {
            long timeout = System.currentTimeMillis() + (long)this.composedTaskProperties.getMaxWaitTime();
            logger.debug((Object)("Wait time for this task to complete is " + this.composedTaskProperties.getMaxWaitTime()));
            logger.debug((Object)("Interval check time for this task to complete is " + this.composedTaskProperties.getIntervalTimeBetweenChecks()));
            do {
                try {
                    Thread.sleep(this.composedTaskProperties.getIntervalTimeBetweenChecks());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException(e.getMessage(), e);
                }
                TaskExecution taskExecution = this.taskExplorer.getTaskExecution(taskExecutionId);
                if (taskExecution == null || taskExecution.getEndTime() == null) continue;
                if (taskExecution.getExitCode() != 0) {
                    throw new UnexpectedJobExecutionException("Task returned a non zero exit code.");
                }
                break block4;
            } while (this.composedTaskProperties.getMaxWaitTime() <= 0 || System.currentTimeMillis() <= timeout);
            throw new TaskExecutionTimeoutException(String.format("Timeout occurred while processing task with Execution Id %s", taskExecutionId));
        }
    }
}

