/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.twitterstream.source;

import java.net.URI;
import org.springframework.cloud.stream.app.twitterstream.source.AbstractTwitterInboundChannelAdapter;
import org.springframework.cloud.stream.app.twitterstream.source.TwitterStreamProperties;
import org.springframework.cloud.stream.app.twitterstream.source.TwitterStreamType;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.social.support.URIBuilder;
import org.springframework.social.twitter.api.impl.TwitterTemplate;
import org.springframework.util.StringUtils;

class TwitterStreamMessageProducer
extends AbstractTwitterInboundChannelAdapter {
    private static final String API_URL_BASE = "https://stream.twitter.com/1.1/statuses/";
    private final TwitterStreamProperties twitterStreamProperties;

    TwitterStreamMessageProducer(TwitterTemplate twitterTemplate, TwitterStreamProperties twitterStreamProperties) {
        super(twitterTemplate);
        this.twitterStreamProperties = twitterStreamProperties;
    }

    @Override
    protected URI buildUri() {
        TwitterStreamType streamType = this.twitterStreamProperties.getStreamType();
        URIBuilder b = URIBuilder.fromUri((String)(API_URL_BASE + streamType.getPath()));
        if (streamType == TwitterStreamType.FILTER) {
            if (StringUtils.hasText((String)this.twitterStreamProperties.getFollow())) {
                b.queryParam("follow", this.twitterStreamProperties.getFollow());
            }
            if (StringUtils.hasText((String)this.twitterStreamProperties.getTrack())) {
                b.queryParam("track", this.twitterStreamProperties.getTrack());
            }
            if (StringUtils.hasText((String)this.twitterStreamProperties.getLocations())) {
                b.queryParam("locations", this.twitterStreamProperties.getLocations());
            }
        }
        if (StringUtils.hasText((String)this.twitterStreamProperties.getLanguage())) {
            b.queryParam("language", this.twitterStreamProperties.getLanguage());
        }
        URI uri = b.build();
        this.logger.info((Object)("Using twitter stream url: " + uri));
        return uri;
    }

    @Override
    protected void doSendLine(String line) {
        if (line.startsWith("{\"limit")) {
            this.logger.info((Object)"Twitter stream is being track limited.");
        } else if (!line.startsWith("{\"delete") && !line.startsWith("{\"warning")) {
            this.sendMessage(MessageBuilder.withPayload((Object)line).build());
        }
    }
}

