/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.tcp.source;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.tcp.EncoderDecoderFactoryBean;
import org.springframework.cloud.stream.app.tcp.TcpConnectionFactoryProperties;
import org.springframework.cloud.stream.app.tcp.source.TcpSourceProperties;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.core.serializer.Deserializer;
import org.springframework.integration.ip.config.TcpConnectionFactoryFactoryBean;
import org.springframework.integration.ip.tcp.TcpReceivingChannelAdapter;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.serializer.AbstractByteArraySerializer;

@EnableBinding(value={Source.class})
@EnableConfigurationProperties(value={TcpSourceProperties.class, TcpConnectionFactoryProperties.class})
public class TcpSourceConfiguration {
    @Autowired
    private TcpSourceProperties properties;
    @Autowired
    private TcpConnectionFactoryProperties tcpConnectionProperties;

    @Bean
    public TcpReceivingChannelAdapter adapter(@Qualifier(value="tcpSourceConnectionFactory") AbstractConnectionFactory connectionFactory) {
        TcpReceivingChannelAdapter adapter = new TcpReceivingChannelAdapter();
        adapter.setConnectionFactory(connectionFactory);
        adapter.setOutputChannelName("output");
        return adapter;
    }

    @Bean
    public TcpConnectionFactoryFactoryBean tcpSourceConnectionFactory(@Qualifier(value="tcpSourceDecoder") AbstractByteArraySerializer decoder) throws Exception {
        TcpConnectionFactoryFactoryBean factoryBean = new TcpConnectionFactoryFactoryBean();
        factoryBean.setType("server");
        factoryBean.setPort(this.tcpConnectionProperties.getPort());
        factoryBean.setUsingNio(this.tcpConnectionProperties.isNio());
        factoryBean.setUsingDirectBuffers(this.tcpConnectionProperties.isUseDirectBuffers());
        factoryBean.setLookupHost(this.tcpConnectionProperties.isReverseLookup());
        factoryBean.setDeserializer((Deserializer)decoder);
        factoryBean.setSoTimeout(this.tcpConnectionProperties.getSocketTimeout());
        return factoryBean;
    }

    @Bean
    public EncoderDecoderFactoryBean tcpSourceDecoder() {
        EncoderDecoderFactoryBean factoryBean = new EncoderDecoderFactoryBean(this.properties.getDecoder());
        factoryBean.setMaxMessageSize(this.properties.getBufferSize());
        return factoryBean;
    }
}

