/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.sftp.source.tasklauncher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.app.sftp.source.SftpSourceProperties;
import org.springframework.cloud.stream.app.sftp.source.batch.SftpSourceBatchProperties;
import org.springframework.cloud.stream.app.sftp.source.metadata.SftpSourceRedisIdempotentReceiverConfiguration;
import org.springframework.cloud.task.launcher.TaskLaunchRequest;
import org.springframework.context.annotation.Import;
import org.springframework.integration.annotation.IdempotentReceiver;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StringUtils;

@EnableConfigurationProperties(value={SftpSourceProperties.class, SftpSourceBatchProperties.class})
@Import(value={SftpSourceRedisIdempotentReceiverConfiguration.class})
public class SftpSourceTaskLauncherConfiguration {
    protected static final String SFTP_HOST_PROPERTY_KEY = "sftp_host";
    protected static final String SFTP_PORT_PROPERTY_KEY = "sftp_port";
    protected static final String SFTP_USERNAME_PROPERTY_KEY = "sftp_username";
    protected static final String SFTP_PASSWORD_PROPERTY_KEY = "sftp_password";
    protected static final String DATASOURCE_URL_PROPERTY_KEY = "spring.datasource.url";
    protected static final String DATASOURCE_USERNAME_PROPERTY_KEY = "spring.datasource.username";
    private SftpSourceProperties sftpSourceProperties;
    private SftpSourceBatchProperties sftpSourceBatchProperties;

    @Autowired
    public SftpSourceTaskLauncherConfiguration(SftpSourceProperties sftpSourceProperties, SftpSourceBatchProperties sftpSourceBatchProperties) {
        this.sftpSourceProperties = sftpSourceProperties;
        this.sftpSourceBatchProperties = sftpSourceBatchProperties;
    }

    @ConditionalOnProperty(name={"sftp.taskLauncherOutput"})
    @IdempotentReceiver(value={"idempotentReceiverInterceptor"})
    @ServiceActivator(inputChannel="sftpFileTaskLaunchChannel", outputChannel="output")
    public Message sftpFileTaskLauncherTransformer(Message message) {
        TaskLaunchRequest outboundPayload = new TaskLaunchRequest(this.sftpSourceBatchProperties.getBatchResourceUri(), this.getCommandLineArgs(message), this.getEnvironmentProperties(), this.getDeploymentProperties(), null);
        return MessageBuilder.withPayload((Object)outboundPayload).copyHeaders((Map)message.getHeaders()).setHeader("contentType", (Object)MimeTypeUtils.APPLICATION_JSON).build();
    }

    private Map<String, String> getEnvironmentProperties() {
        HashMap<String, String> environmentProperties = new HashMap<String, String>();
        environmentProperties.put(DATASOURCE_URL_PROPERTY_KEY, this.sftpSourceBatchProperties.getDataSourceUrl());
        environmentProperties.put(DATASOURCE_USERNAME_PROPERTY_KEY, this.sftpSourceBatchProperties.getDataSourceUserName());
        environmentProperties.put(SFTP_HOST_PROPERTY_KEY, this.sftpSourceProperties.getFactory().getHost());
        environmentProperties.put(SFTP_USERNAME_PROPERTY_KEY, this.sftpSourceProperties.getFactory().getUsername());
        environmentProperties.put(SFTP_PASSWORD_PROPERTY_KEY, this.sftpSourceProperties.getFactory().getPassword());
        environmentProperties.put(SFTP_PORT_PROPERTY_KEY, String.valueOf(this.sftpSourceProperties.getFactory().getPort()));
        String providedProperties = this.sftpSourceBatchProperties.getEnvironmentProperties();
        if (StringUtils.hasText((String)providedProperties)) {
            String[] splitProperties = StringUtils.split((String)providedProperties, (String)",");
            Properties properties = StringUtils.splitArrayElementsIntoProperties((String[])splitProperties, (String)"=");
            for (String key : properties.stringPropertyNames()) {
                environmentProperties.put(key, properties.getProperty(key));
            }
        }
        return environmentProperties;
    }

    protected Map<String, String> getDeploymentProperties() {
        ArrayList<String> pairs = new ArrayList<String>();
        HashMap<String, String> deploymentProperties = new HashMap<String, String>();
        String properties = this.sftpSourceBatchProperties.getDeploymentProperties();
        String[] candidates = StringUtils.commaDelimitedListToStringArray((String)properties);
        for (int i = 0; i < candidates.length; ++i) {
            if (i > 0 && !candidates[i].contains("=")) {
                pairs.set(pairs.size() - 1, (String)pairs.get(pairs.size() - 1) + "," + candidates[i]);
                continue;
            }
            pairs.add(candidates[i]);
        }
        for (String pair : pairs) {
            this.addKeyValuePairAsProperty(pair, deploymentProperties);
        }
        return deploymentProperties;
    }

    private void addKeyValuePairAsProperty(String pair, Map<String, String> properties) {
        int firstEquals = pair.indexOf(61);
        if (firstEquals != -1) {
            properties.put(pair.substring(0, firstEquals).trim(), pair.substring(firstEquals + 1).trim());
        }
    }

    private List<String> getCommandLineArgs(Message message) {
        Assert.notNull((Object)message, (String)"Message to create TaskLaunchRequest from cannot be null");
        String filename = (String)message.getPayload();
        String remoteDirectory = (String)message.getHeaders().get((Object)"file_remoteDirectory");
        String localFilePathJobParameterValue = this.sftpSourceBatchProperties.getLocalFilePathJobParameterValue();
        String remoteFilePath = remoteDirectory + filename;
        String localFilePath = localFilePathJobParameterValue + filename;
        String localFilePathJobParameterName = this.sftpSourceBatchProperties.getLocalFilePathJobParameterName();
        String remoteFilePathJobParameterName = this.sftpSourceBatchProperties.getRemoteFilePathJobParameterName();
        ArrayList<String> commandLineArgs = new ArrayList<String>();
        commandLineArgs.add(remoteFilePathJobParameterName + "=" + remoteFilePath);
        commandLineArgs.add(localFilePathJobParameterName + "=" + localFilePath);
        commandLineArgs.addAll(this.sftpSourceBatchProperties.getJobParameters());
        return commandLineArgs;
    }
}

