/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.sftp.source.batch;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="sftp.batch")
public class SftpSourceBatchProperties {
    protected static final String DEFAULT_LOCAL_FILE_PATH_JOB_PARAM_NAME = "localFilePath";
    protected static final String DEFAULT_REMOTE_FILE_PATH_JOB_PARAM_NAME = "remoteFilePath";
    private String batchResourceUri = "";
    private String dataSourceUrl = "jdbc:h2:tcp://localhost:19092/mem:dataflow";
    private String dataSourceUserName = "sa";
    private String dataSourcePassword;
    private String deploymentProperties;
    private String environmentProperties;
    private String remoteFilePathJobParameterName = "remoteFilePath";
    private String localFilePathJobParameterName = "localFilePath";
    private String localFilePathJobParameterValue = new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
    private List<String> jobParameters = new ArrayList<String>();

    @NotNull
    public String getBatchResourceUri() {
        return this.batchResourceUri;
    }

    public void setBatchResourceUri(String batchResourceUri) {
        this.batchResourceUri = batchResourceUri;
    }

    @NotBlank
    public String getDataSourceUrl() {
        return this.dataSourceUrl;
    }

    public void setDataSourceUrl(String dataSourceUrl) {
        this.dataSourceUrl = dataSourceUrl;
    }

    @NotBlank
    public String getDataSourceUserName() {
        return this.dataSourceUserName;
    }

    public void setDataSourceUserName(String dataSourceUserName) {
        this.dataSourceUserName = dataSourceUserName;
    }

    public String getDataSourcePassword() {
        return this.dataSourcePassword;
    }

    public void setDataSourcePassword(String dataSourcePassword) {
        this.dataSourcePassword = dataSourcePassword;
    }

    public String getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public void setDeploymentProperties(String deploymentProperties) {
        this.deploymentProperties = deploymentProperties;
    }

    public String getEnvironmentProperties() {
        return this.environmentProperties;
    }

    public void setEnvironmentProperties(String environmentProperties) {
        this.environmentProperties = environmentProperties;
    }

    public String getRemoteFilePathJobParameterName() {
        return this.remoteFilePathJobParameterName;
    }

    public void setRemoteFilePathJobParameterName(String remoteFilePathJobParameterName) {
        this.remoteFilePathJobParameterName = remoteFilePathJobParameterName;
    }

    public String getLocalFilePathJobParameterName() {
        return this.localFilePathJobParameterName;
    }

    public void setLocalFilePathJobParameterName(String localFilePathJobParameterName) {
        this.localFilePathJobParameterName = localFilePathJobParameterName;
    }

    @NotBlank
    public String getLocalFilePathJobParameterValue() {
        return this.localFilePathJobParameterValue;
    }

    public void setLocalFilePathJobParameterValue(String localFilePathJobParameterValue) {
        this.localFilePathJobParameterValue = localFilePathJobParameterValue;
    }

    public List<String> getJobParameters() {
        return this.jobParameters;
    }

    public void setJobParameters(List<String> jobParameters) {
        this.jobParameters = jobParameters;
    }
}

