/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.sftp.source;

import java.io.File;
import java.util.regex.Pattern;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.Range;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.expression.Expression;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="sftp")
@Validated
public class SftpSourceProperties {
    private final Factory factory = new Factory();
    private String remoteDir = "/";
    private String tmpFileSuffix = ".tmp";
    private String remoteFileSeparator = "/";
    private boolean deleteRemoteFiles = false;
    private File localDir = new File(System.getProperty("java.io.tmpdir") + "/xd/ftp");
    private boolean autoCreateLocalDir = true;
    private String filenamePattern;
    private Pattern filenameRegex;
    private boolean preserveTimestamp = true;
    private boolean stream = false;

    @NotBlank
    public String getRemoteDir() {
        return this.remoteDir;
    }

    public void setRemoteDir(String remoteDir) {
        this.remoteDir = remoteDir;
    }

    @NotBlank
    public String getTmpFileSuffix() {
        return this.tmpFileSuffix;
    }

    public void setTmpFileSuffix(String tmpFileSuffix) {
        this.tmpFileSuffix = tmpFileSuffix;
    }

    @NotBlank
    public String getRemoteFileSeparator() {
        return this.remoteFileSeparator;
    }

    public void setRemoteFileSeparator(String remoteFileSeparator) {
        this.remoteFileSeparator = remoteFileSeparator;
    }

    public boolean isAutoCreateLocalDir() {
        return this.autoCreateLocalDir;
    }

    public void setAutoCreateLocalDir(boolean autoCreateLocalDir) {
        this.autoCreateLocalDir = autoCreateLocalDir;
    }

    public boolean isDeleteRemoteFiles() {
        return this.deleteRemoteFiles;
    }

    public void setDeleteRemoteFiles(boolean deleteRemoteFiles) {
        this.deleteRemoteFiles = deleteRemoteFiles;
    }

    @NotNull
    public File getLocalDir() {
        return this.localDir;
    }

    public final void setLocalDir(File localDir) {
        this.localDir = localDir;
    }

    public String getFilenamePattern() {
        return this.filenamePattern;
    }

    public void setFilenamePattern(String filenamePattern) {
        this.filenamePattern = filenamePattern;
    }

    public Pattern getFilenameRegex() {
        return this.filenameRegex;
    }

    public void setFilenameRegex(Pattern filenameRegex) {
        this.filenameRegex = filenameRegex;
    }

    public boolean isPreserveTimestamp() {
        return this.preserveTimestamp;
    }

    public void setPreserveTimestamp(boolean preserveTimestamp) {
        this.preserveTimestamp = preserveTimestamp;
    }

    @AssertTrue(message="filenamePattern and filenameRegex are mutually exclusive")
    public boolean isExclusivePatterns() {
        return this.filenamePattern == null || this.filenameRegex == null;
    }

    public boolean isStream() {
        return this.stream;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public Factory getFactory() {
        return this.factory;
    }

    public static class Factory {
        private String host = "localhost";
        private String username;
        private String password;
        private Boolean cacheSessions;
        private int port = 22;
        private String privateKey = "";
        private String passPhrase = "";
        private boolean allowUnknownKeys = false;
        private Expression knownHostsExpression = null;

        @NotBlank
        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        @NotBlank
        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public Boolean getCacheSessions() {
            return this.cacheSessions;
        }

        public void setCacheSessions(Boolean cacheSessions) {
            this.cacheSessions = cacheSessions;
        }

        @Range(min=0L, max=65535L)
        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public String getPassPhrase() {
            return this.passPhrase;
        }

        public void setPassPhrase(String passPhrase) {
            this.passPhrase = passPhrase;
        }

        public boolean isAllowUnknownKeys() {
            return this.allowUnknownKeys;
        }

        public void setAllowUnknownKeys(boolean allowUnknownKeys) {
            this.allowUnknownKeys = allowUnknownKeys;
        }

        public Expression getKnownHostsExpression() {
            return this.knownHostsExpression;
        }

        public void setKnownHostsExpression(Expression knownHosts) {
            this.knownHostsExpression = knownHosts;
        }
    }
}

