/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.sftp.source;

import com.jcraft.jsch.ChannelSftp;
import java.util.Collections;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.file.FileConsumerProperties;
import org.springframework.cloud.stream.app.file.FileUtils;
import org.springframework.cloud.stream.app.file.remote.RemoteFileDeletingTransactionSynchronizationProcessor;
import org.springframework.cloud.stream.app.sftp.source.SftpSourceProperties;
import org.springframework.cloud.stream.app.sftp.source.SftpSourceSessionFactoryConfiguration;
import org.springframework.cloud.stream.app.trigger.TriggerConfiguration;
import org.springframework.cloud.stream.app.trigger.TriggerPropertiesMaxMessagesDefaultUnlimited;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.SourcePollingChannelAdapterSpec;
import org.springframework.integration.dsl.core.MessageSourceSpec;
import org.springframework.integration.dsl.sftp.Sftp;
import org.springframework.integration.dsl.sftp.SftpInboundChannelAdapterSpec;
import org.springframework.integration.dsl.support.Consumer;
import org.springframework.integration.file.filters.ChainFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;
import org.springframework.integration.scheduling.PollerMetadata;
import org.springframework.integration.sftp.filters.SftpPersistentAcceptOnceFileListFilter;
import org.springframework.integration.sftp.filters.SftpRegexPatternFileListFilter;
import org.springframework.integration.sftp.filters.SftpSimplePatternFileListFilter;
import org.springframework.integration.sftp.inbound.SftpStreamingMessageSource;
import org.springframework.integration.sftp.session.SftpRemoteFileTemplate;
import org.springframework.integration.transaction.DefaultTransactionSynchronizationFactory;
import org.springframework.integration.transaction.PseudoTransactionManager;
import org.springframework.integration.transaction.TransactionSynchronizationFactory;
import org.springframework.integration.transaction.TransactionSynchronizationProcessor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.MatchAlwaysTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.StringUtils;

@EnableBinding(value={Source.class})
@EnableConfigurationProperties(value={SftpSourceProperties.class, FileConsumerProperties.class})
@Import(value={TriggerConfiguration.class, SftpSourceSessionFactoryConfiguration.class, TriggerPropertiesMaxMessagesDefaultUnlimited.class})
public class SftpSourceConfiguration {
    @Autowired
    @Qualifier(value="defaultPoller")
    private PollerMetadata defaultPoller;
    @Autowired
    private Source source;
    @Autowired(required=false)
    private SftpRemoteFileTemplate sftpTemplate;

    @Bean
    public IntegrationFlow sftpInboundFlow(SessionFactory<ChannelSftp.LsEntry> sftpSessionFactory, SftpSourceProperties properties, FileConsumerProperties fileConsumerProperties) {
        IntegrationFlowBuilder flowBuilder;
        if (!properties.isStream()) {
            SftpInboundChannelAdapterSpec messageSourceBuilder = (SftpInboundChannelAdapterSpec)((SftpInboundChannelAdapterSpec)((SftpInboundChannelAdapterSpec)((SftpInboundChannelAdapterSpec)((SftpInboundChannelAdapterSpec)((SftpInboundChannelAdapterSpec)((SftpInboundChannelAdapterSpec)Sftp.inboundAdapter(sftpSessionFactory).preserveTimestamp(properties.isPreserveTimestamp())).remoteDirectory(properties.getRemoteDir())).remoteFileSeparator(properties.getRemoteFileSeparator())).localDirectory(properties.getLocalDir())).autoCreateLocalDirectory(properties.isAutoCreateLocalDir())).temporaryFileSuffix(properties.getTmpFileSuffix())).deleteRemoteFiles(properties.isDeleteRemoteFiles());
            if (StringUtils.hasText((String)properties.getFilenamePattern())) {
                messageSourceBuilder.patternFilter(properties.getFilenamePattern());
            } else if (properties.getFilenameRegex() != null) {
                messageSourceBuilder.filter((FileListFilter)new SftpRegexPatternFileListFilter(properties.getFilenameRegex()));
            }
            flowBuilder = FileUtils.enhanceFlowForReadingMode((IntegrationFlowBuilder)IntegrationFlows.from((MessageSourceSpec)messageSourceBuilder, this.consumerSpec()), (FileConsumerProperties)fileConsumerProperties);
        } else {
            flowBuilder = FileUtils.enhanceStreamFlowForReadingMode((IntegrationFlowBuilder)IntegrationFlows.from((MessageSource)this.streamSource(sftpSessionFactory, properties), properties.isDeleteRemoteFiles() ? this.consumerSpecWithDelete(properties) : this.consumerSpec()), (FileConsumerProperties)fileConsumerProperties);
        }
        return ((IntegrationFlowBuilder)flowBuilder.channel(this.source.output())).get();
    }

    private Consumer<SourcePollingChannelAdapterSpec> consumerSpec() {
        return new Consumer<SourcePollingChannelAdapterSpec>(){

            public void accept(SourcePollingChannelAdapterSpec sourcePollingChannelAdapterSpec) {
                sourcePollingChannelAdapterSpec.poller(SftpSourceConfiguration.this.defaultPoller);
            }
        };
    }

    private Consumer<SourcePollingChannelAdapterSpec> consumerSpecWithDelete(SftpSourceProperties properties) {
        final PollerMetadata poller = new PollerMetadata();
        BeanUtils.copyProperties((Object)this.defaultPoller, (Object)poller, (String[])new String[]{"transactionSynchronizationFactory"});
        RemoteFileDeletingTransactionSynchronizationProcessor processor = new RemoteFileDeletingTransactionSynchronizationProcessor((RemoteFileTemplate)this.sftpTemplate, properties.getRemoteFileSeparator());
        poller.setTransactionSynchronizationFactory((TransactionSynchronizationFactory)new DefaultTransactionSynchronizationFactory((TransactionSynchronizationProcessor)processor));
        poller.setAdviceChain(Collections.singletonList(new TransactionInterceptor((PlatformTransactionManager)new PseudoTransactionManager(), (TransactionAttributeSource)new MatchAlwaysTransactionAttributeSource())));
        return new Consumer<SourcePollingChannelAdapterSpec>(){

            public void accept(SourcePollingChannelAdapterSpec sourcePollingChannelAdapterSpec) {
                sourcePollingChannelAdapterSpec.poller(poller);
            }
        };
    }

    @Bean
    @ConditionalOnProperty(name={"sftp.stream"})
    public SftpStreamingMessageSource streamSource(SessionFactory<ChannelSftp.LsEntry> sftpSessionFactory, SftpSourceProperties properties) {
        SftpStreamingMessageSource messageSource = new SftpStreamingMessageSource((RemoteFileTemplate)this.sftpTemplate(sftpSessionFactory));
        messageSource.setRemoteDirectory(properties.getRemoteDir());
        messageSource.setRemoteFileSeparator(properties.getRemoteFileSeparator());
        ChainFileListFilter filterChain = new ChainFileListFilter();
        if (StringUtils.hasText((String)properties.getFilenamePattern())) {
            filterChain.addFilter((FileListFilter)new SftpSimplePatternFileListFilter(properties.getFilenamePattern()));
        } else if (properties.getFilenameRegex() != null) {
            filterChain.addFilter((FileListFilter)new SftpRegexPatternFileListFilter(properties.getFilenameRegex()));
        }
        filterChain.addFilter((FileListFilter)new SftpPersistentAcceptOnceFileListFilter((ConcurrentMetadataStore)new SimpleMetadataStore(), "sftpSource"));
        messageSource.setFilter((FileListFilter)filterChain);
        return messageSource;
    }

    @Bean
    @ConditionalOnProperty(name={"sftp.stream"})
    public SftpRemoteFileTemplate sftpTemplate(SessionFactory<ChannelSftp.LsEntry> sftpSessionFactory) {
        return new SftpRemoteFileTemplate(sftpSessionFactory);
    }
}

