/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.s3.source;

import java.io.File;
import java.util.regex.Pattern;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="s3")
@Validated
public class AmazonS3SourceProperties {
    private String remoteDir = "bucket";
    private String tmpFileSuffix = ".tmp";
    private String remoteFileSeparator = "/";
    private boolean deleteRemoteFiles = false;
    private File localDir = new File(System.getProperty("java.io.tmpdir"), "s3-source");
    private boolean autoCreateLocalDir = true;
    private String filenamePattern;
    private Pattern filenameRegex;
    private boolean preserveTimestamp = true;

    @Length(min=3)
    public @Length(min=3) String getRemoteDir() {
        return this.remoteDir;
    }

    public final void setRemoteDir(String remoteDir) {
        this.remoteDir = remoteDir;
    }

    @NotBlank
    public String getTmpFileSuffix() {
        return this.tmpFileSuffix;
    }

    public void setTmpFileSuffix(String tmpFileSuffix) {
        this.tmpFileSuffix = tmpFileSuffix;
    }

    @NotBlank
    public String getRemoteFileSeparator() {
        return this.remoteFileSeparator;
    }

    public void setRemoteFileSeparator(String remoteFileSeparator) {
        this.remoteFileSeparator = remoteFileSeparator;
    }

    public boolean isAutoCreateLocalDir() {
        return this.autoCreateLocalDir;
    }

    public void setAutoCreateLocalDir(boolean autoCreateLocalDir) {
        this.autoCreateLocalDir = autoCreateLocalDir;
    }

    public boolean isDeleteRemoteFiles() {
        return this.deleteRemoteFiles;
    }

    public void setDeleteRemoteFiles(boolean deleteRemoteFiles) {
        this.deleteRemoteFiles = deleteRemoteFiles;
    }

    @NotNull
    public File getLocalDir() {
        return this.localDir;
    }

    public final void setLocalDir(File localDir) {
        this.localDir = localDir;
    }

    public String getFilenamePattern() {
        return this.filenamePattern;
    }

    public void setFilenamePattern(String filenamePattern) {
        this.filenamePattern = filenamePattern;
    }

    public Pattern getFilenameRegex() {
        return this.filenameRegex;
    }

    public void setFilenameRegex(Pattern filenameRegex) {
        this.filenameRegex = filenameRegex;
    }

    public boolean isPreserveTimestamp() {
        return this.preserveTimestamp;
    }

    public void setPreserveTimestamp(boolean preserveTimestamp) {
        this.preserveTimestamp = preserveTimestamp;
    }

    @AssertTrue(message="filenamePattern and filenameRegex are mutually exclusive")
    public @AssertTrue(message="filenamePattern and filenameRegex are mutually exclusive") boolean isExclusivePatterns() {
        return this.filenamePattern == null || this.filenameRegex == null;
    }
}

