/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.rabbit.source;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="rabbit")
@Validated
public class RabbitSourceProperties {
    private boolean requeue = true;
    private boolean transacted = false;
    private String[] queues;
    private String[] mappedRequestHeaders = new String[]{"STANDARD_REQUEST_HEADERS"};
    private int initialRetryInterval = 1000;
    private int maxRetryInterval = 30000;
    private double retryMultiplier = 2.0;
    private int maxAttempts = 3;
    private boolean enableRetry = false;
    private boolean ownConnection;

    public boolean getRequeue() {
        return this.requeue;
    }

    public void setRequeue(boolean requeue) {
        this.requeue = requeue;
    }

    public boolean getTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    @NotNull(message="queue(s) are required")
    @Size(min=1, message="At least one queue is required")
    public String[] getQueues() {
        return this.queues;
    }

    public void setQueues(String[] queues) {
        this.queues = queues;
    }

    @NotNull
    public String[] getMappedRequestHeaders() {
        return this.mappedRequestHeaders;
    }

    public void setMappedRequestHeaders(String[] mappedRequestHeaders) {
        this.mappedRequestHeaders = mappedRequestHeaders;
    }

    public int getInitialRetryInterval() {
        return this.initialRetryInterval;
    }

    public void setInitialRetryInterval(int initialRetryInterval) {
        this.initialRetryInterval = initialRetryInterval;
    }

    public int getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    public void setMaxRetryInterval(int maxRetryInterval) {
        this.maxRetryInterval = maxRetryInterval;
    }

    public double getRetryMultiplier() {
        return this.retryMultiplier;
    }

    public void setRetryMultiplier(double retryMultiplier) {
        this.retryMultiplier = retryMultiplier;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public boolean isEnableRetry() {
        return this.enableRetry;
    }

    public void setEnableRetry(boolean enableRetry) {
        this.enableRetry = enableRetry;
    }

    public boolean isOwnConnection() {
        return this.ownConnection;
    }

    public void setOwnConnection(boolean ownConnection) {
        this.ownConnection = ownConnection;
    }
}

