/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.mongodb.source;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.mongodb.source.MongodbSourceProperties;
import org.springframework.cloud.stream.app.trigger.TriggerConfiguration;
import org.springframework.cloud.stream.app.trigger.TriggerPropertiesMaxMessagesDefaultUnlimited;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.mongodb.inbound.MongoDbMessageSource;
import org.springframework.messaging.MessageChannel;

@EnableBinding(value={Source.class})
@EnableConfigurationProperties(value={MongodbSourceProperties.class, TriggerPropertiesMaxMessagesDefaultUnlimited.class})
@Import(value={TriggerConfiguration.class})
public class MongodbSourceConfiguration {
    @Autowired
    private MongodbSourceProperties config;
    @Autowired
    @Qualifier(value="output")
    private MessageChannel output;
    @Autowired
    private MongoTemplate mongoTemplate;

    @Bean
    public IntegrationFlow startFlow() throws Exception {
        IntegrationFlowBuilder flow = IntegrationFlows.from((MessageSource)this.mongoSource());
        if (this.config.isSplit()) {
            flow.split();
        }
        flow.channel(this.output);
        return flow.get();
    }

    protected MongoDbMessageSource mongoSource() {
        LiteralExpression queryExpression = this.config.getQueryExpression() != null ? this.config.getQueryExpression() : new LiteralExpression(this.config.getQuery());
        MongoDbMessageSource mongoDbMessageSource = new MongoDbMessageSource((MongoOperations)this.mongoTemplate, (Expression)queryExpression);
        mongoDbMessageSource.setCollectionNameExpression((Expression)new LiteralExpression(this.config.getCollection()));
        mongoDbMessageSource.setEntityClass(String.class);
        return mongoDbMessageSource;
    }
}

