/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.jdbc.source;

import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.Bindings;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.jdbc.source.JdbcSourceProperties;
import org.springframework.cloud.stream.app.trigger.TriggerConfiguration;
import org.springframework.cloud.stream.app.trigger.TriggerPropertiesMaxMessagesDefaultOne;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.SourcePollingChannelAdapterSpec;
import org.springframework.integration.dsl.support.Consumer;
import org.springframework.integration.jdbc.JdbcPollingChannelAdapter;
import org.springframework.integration.scheduling.PollerMetadata;

@EnableBinding(value={Source.class})
@Import(value={TriggerConfiguration.class})
@EnableConfigurationProperties(value={JdbcSourceProperties.class, TriggerPropertiesMaxMessagesDefaultOne.class})
public class JdbcSourceConfiguration {
    @Autowired
    @Qualifier(value="defaultPoller")
    private PollerMetadata poller;
    @Autowired
    private JdbcSourceProperties properties;
    @Autowired
    private DataSource dataSource;
    @Autowired
    @Bindings(value=JdbcSourceConfiguration.class)
    private Source source;

    @Bean
    public MessageSource<Object> jdbcMessageSource() {
        JdbcPollingChannelAdapter jdbcPollingChannelAdapter = new JdbcPollingChannelAdapter(this.dataSource, this.properties.getQuery());
        jdbcPollingChannelAdapter.setMaxRowsPerPoll(this.properties.getMaxRowsPerPoll());
        jdbcPollingChannelAdapter.setUpdateSql(this.properties.getUpdate());
        return jdbcPollingChannelAdapter;
    }

    @Bean
    public IntegrationFlow pollingFlow() {
        IntegrationFlowBuilder flowBuilder = IntegrationFlows.from(this.jdbcMessageSource(), (Consumer)new Consumer<SourcePollingChannelAdapterSpec>(){

            public void accept(SourcePollingChannelAdapterSpec sourcePollingChannelAdapterSpec) {
                sourcePollingChannelAdapterSpec.poller(JdbcSourceConfiguration.this.poller);
            }
        });
        if (this.properties.isSplit()) {
            flowBuilder.split();
        }
        flowBuilder.channel(this.source.output());
        return flowBuilder.get();
    }
}

